/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.typing;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.TypingModuleBuiltins;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.typing.PTypeVarTuple;
import com.oracle.graal.python.builtins.objects.typing.TypeVarTupleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.typing.TypeVarTupleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.typing.TypeVarTupleBuiltinsSlotsGen;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTypeVarTuple})
public final class TypeVarTupleBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = TypeVarTupleBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TypeVarTupleBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PTypeVarTuple self) {
            return self.name;
        }
    }

    @Builtin(name="__mro_entries__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class MroEntriesNode
    extends PythonBinaryBuiltinNode {
        MroEntriesNode() {
        }

        @Specialization
        static Object mro(PTypeVarTuple self, Object bases, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SUBCLASS_AN_INSTANCE_OF_TYPEVARTUPLE);
        }
    }

    @Builtin(name="__typing_prepare_subst__", minNumOfPositionalArgs=3, parameterNames={"$self", "alias", "args"})
    @GenerateNodeFactory
    static abstract class TypingPrepareSubstNode
    extends PythonTernaryBuiltinNode {
        private static final TruffleString T_TYPEVARTUPLE_PREPARE_SUBST = PythonUtils.tsLiteral("_typevartuple_prepare_subst");

        TypingPrepareSubstNode() {
        }

        @Specialization
        static Object doTypingPrepareSubst(VirtualFrame frame, PTypeVarTuple self, Object alias, Object args, @Bind Node inliningTarget, @Cached TypingModuleBuiltins.CallTypingFuncObjectNode callTypingFuncObjectNode) {
            return callTypingFuncObjectNode.execute(frame, inliningTarget, T_TYPEVARTUPLE_PREPARE_SUBST, self, alias, args);
        }
    }

    @Builtin(name="__typing_subst__", minNumOfPositionalArgs=2, parameterNames={"$self", "arg"})
    @GenerateNodeFactory
    static abstract class TypingSubstNode
    extends PythonBinaryBuiltinNode {
        TypingSubstNode() {
        }

        @Specialization
        static Object doTypingSubst(PTypeVarTuple self, Object arg, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.SUBSTITUTION_OF_BARE_TYPEVARTUPLE_IS_NOT_SUPPORTED);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static PythonObject iter(VirtualFrame frame, PTypeVarTuple self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached TypingModuleBuiltins.UnpackNode unpackNode) {
            Object unpacked = unpackNode.execute(frame, inliningTarget, self);
            PTuple tuple = PFactory.createTuple(language, new Object[]{unpacked});
            return PFactory.createSequenceIterator(language, tuple);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(PTypeVarTuple self) {
            return self.name;
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static TruffleString doName(PTypeVarTuple self) {
            return self.name;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="TypeVarTuple", minNumOfPositionalArgs=2, parameterNames={"$cls", "name"}, needsFrame=true, alwaysNeedsCallerFrame=true)
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class TypeVarTupleNode
    extends PythonClinicBuiltinNode {
        TypeVarTupleNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TypeVarTupleBuiltinsClinicProviders.TypeVarTupleNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PTypeVarTuple newTypeVarTuple(VirtualFrame frame, Object cls, TruffleString name, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached TypingModuleBuiltins.CallerNode callerNode, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PyObjectSetAttr setAttrNode) {
            Object module = callerNode.execute(frame, inliningTarget);
            PTypeVarTuple result = PFactory.createTypeVarTuple(language, cls, getInstanceShape.execute(cls), name);
            setAttrNode.execute((Frame)frame, inliningTarget, result, SpecialAttributeNames.T___MODULE__, module);
            return result;
        }
    }
}

