/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotMpAssSubscript;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqAssItem;
import com.oracle.graal.python.lib.PyObjectSetItemNodeGen;
import com.oracle.graal.python.lib.PySequenceGetItemNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={PGuards.class})
public abstract class PyObjectSetItem
extends Node {
    public static void executeUncached(Frame frame, Object container, Object index, Object value) {
        PyObjectSetItemNodeGen.getUncached().execute(frame, null, container, index, value);
    }

    public static void executeUncached(Object container, Object index, Object value) {
        PyObjectSetItemNodeGen.getUncached().execute(null, null, container, index, value);
    }

    public final void executeCached(Frame frame, Object container, Object index, Object item) {
        this.execute(frame, this, container, index, item);
    }

    public abstract void execute(Frame var1, Node var2, Object var3, Object var4, Object var5);

    @Specialization(guards={"isBuiltinList(object)"}, excludeForUncached=true)
    static void doList(VirtualFrame frame, PList object, Object key, Object value, @Cached(inline=false) ListBuiltins.SetSubscriptNode setItemNode) {
        setItemNode.executeVoid(frame, object, key, value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"doList"})
    static void doGeneric(VirtualFrame frame, Node inliningTarget, Object object, Object key, Object value, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached PyObjectSetItemGeneric genericNode) {
        TpSlots slots = getSlotsNode.execute(inliningTarget, object);
        genericNode.execute((Frame)frame, inliningTarget, object, slots, key, value);
    }

    @NeverDefault
    public static PyObjectSetItem create() {
        return PyObjectSetItemNodeGen.create();
    }

    public static PyObjectSetItem getUncached() {
        return PyObjectSetItemNodeGen.getUncached();
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class PyObjectSetItemGeneric
    extends Node {
        PyObjectSetItemGeneric() {
        }

        public abstract void execute(Frame var1, Node var2, Object var3, TpSlots var4, Object var5, Object var6);

        @Specialization(guards={"slots.mp_ass_subscript() != null"})
        static void doMapping(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, Object key, Object value, @Cached TpSlotMpAssSubscript.CallSlotMpAssSubscriptNode callNode) {
            callNode.execute(frame, inliningTarget, slots.mp_ass_subscript(), object, key, value);
        }

        @Specialization(guards={"slots.mp_ass_subscript() == null", "slots.sq_ass_item() != null", "key >= 0"})
        static void doSequenceFastPath(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, int key, Object value, @Cached.Exclusive @Cached TpSlotSqAssItem.CallSlotSqAssItemNode callSqItem) {
            callSqItem.execute(frame, inliningTarget, slots.sq_ass_item(), object, key, value);
        }

        @Specialization(guards={"slots.mp_ass_subscript() == null", "slots.sq_ass_item() != null"}, replaces={"doSequenceFastPath"})
        @HostCompilerDirectives.InliningCutoff
        static void doSequence(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, Object key, Object value, @Cached PySequenceGetItemNode.IndexForSqSlot indexForSqSlot, @Cached.Exclusive @Cached TpSlotSqAssItem.CallSlotSqAssItemNode callSqItem) {
            int index = indexForSqSlot.execute(frame, inliningTarget, object, slots, key);
            callSqItem.execute(frame, inliningTarget, slots.sq_ass_item(), object, index, value);
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        static void error(Object object, TpSlots slots, Object key, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT, object);
        }
    }
}

