/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(value=false)
abstract class PyObjectSizeGenericNode
extends Node {
    PyObjectSizeGenericNode() {
    }

    abstract int execute(Frame var1, Object var2);

    @Specialization
    static int doIt(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getTpSlotsNode, @Cached TpSlotLen.CallSlotLenNode callSlotLenNode, @Cached PRaiseNode raiseNode) {
        TpSlots slots = getTpSlotsNode.execute(inliningTarget, object);
        if (slots.combined_sq_mp_length() != null) {
            return callSlotLenNode.execute(frame, inliningTarget, slots.combined_sq_mp_length(), object);
        }
        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_HAS_NO_LEN, object);
    }
}

