/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNodeGen;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(value=false)
public abstract class CastToJavaStringNode
extends PNodeWithContext {
    public abstract String execute(Object var1) throws CannotCastException;

    @Specialization
    static String doString(TruffleString x, @Cached.Shared @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        return toJavaStringNode.execute((AbstractTruffleString)x);
    }

    @Specialization(guards={"x.isMaterialized()"})
    static String doPStringMaterialized(PString x, @Cached.Shared @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        return toJavaStringNode.execute((AbstractTruffleString)x.getMaterialized());
    }

    @Specialization(guards={"!x.isMaterialized()"})
    static String doPStringGeneric(PString x, @Bind Node inliningTarget, @Cached StringNodes.StringMaterializeNode materializeNode, @Cached.Shared @Cached TruffleString.ToJavaStringNode toJavaString) {
        return toJavaString.execute((AbstractTruffleString)materializeNode.execute(inliningTarget, x));
    }

    @Specialization
    static String doNativeObject(PythonNativeObject x, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached.Shared @Cached TruffleString.ToJavaStringNode toJavaString, @Cached CastToTruffleStringNode.ReadNativeStringNode read) {
        if (isSubtypeNode.execute(getClassNode.execute(inliningTarget, x), (Object)PythonBuiltinClassType.PString)) {
            return toJavaString.execute((AbstractTruffleString)read.execute(x.getPtr()));
        }
        throw CannotCastException.INSTANCE;
    }

    @Specialization(guards={"!isString(x)", "!isNativeObject(x)"})
    static String other(Object x, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop) {
        if (interop.isString(x)) {
            try {
                return interop.asString(x);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        throw CannotCastException.INSTANCE;
    }

    public static CastToJavaStringNode getUncached() {
        return CastToJavaStringNodeGen.getUncached();
    }
}

