/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.util.Objects;
import java.util.StringJoiner;

public class QueryProgress {
    private final double percentage;
    private final long rowsProcessed;
    private final long totalRowsToProcess;

    QueryProgress(double percentage, long rowsProcessed, long totalRowsToProcess) {
        this.percentage = percentage;
        this.rowsProcessed = rowsProcessed;
        this.totalRowsToProcess = totalRowsToProcess;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public long getRowsProcessed() {
        return this.rowsProcessed;
    }

    public long getTotalRowsToProcess() {
        return this.totalRowsToProcess;
    }

    public String toString() {
        return new StringJoiner(", ", QueryProgress.class.getSimpleName() + "[", "]").add("percentage=" + this.percentage).add("rowsProcessed=" + this.rowsProcessed).add("totalRowsToProcess=" + this.totalRowsToProcess).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryProgress that = (QueryProgress)o;
        return Double.compare(that.percentage, this.percentage) == 0 && this.rowsProcessed == that.rowsProcessed && this.totalRowsToProcess == that.totalRowsToProcess;
    }

    public int hashCode() {
        return Objects.hash(this.percentage, this.rowsProcessed, this.totalRowsToProcess);
    }
}

