/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.inputenc;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.inputenc.InputEncoding;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;

public class InputEncSty
extends LaTeXSty {
    public static final String[] KNOWN_ENCODINGS = new String[]{"ascii", "latin1", "latin2", "latin3", "latin4", "latin5", "latin9", "latin10", "decmulti", "cp850", "cp852", "cp858", "cp437", "cp437de", "cp865", "applemac", "macce", "next", "cp1250", "cp1252", "cp1257", "ansinew", "utf8"};
    public static final String ERROR_UNKNOWN_ENCODING = "inputenc.unknown.encoding";

    public InputEncSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "inputenc", laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new InputEncoding());
    }

    @Override
    public void processOption(String string, TeXObject teXObject) throws IOException {
        if (InputEncSty.isKnownEncoding(string)) {
            this.getListener().setInputEncoding(string);
        }
    }

    public String getOption(Charset charset) throws LaTeXSyntaxException {
        return InputEncSty.getOption(this.getParser(), charset);
    }

    public static String getOption(TeXParser teXParser, Charset charset) throws LaTeXSyntaxException {
        String string = charset.name();
        if (string.equals("UTF-8")) {
            return "utf8";
        }
        if (string.equals("US-ASCII")) {
            return "ascii";
        }
        if (string.equals("ISO-8859-1")) {
            return "latin1";
        }
        if (string.equals("ISO-8859-2")) {
            return "latin2";
        }
        if (string.equals("ISO-8859-3")) {
            return "latin3";
        }
        if (string.equals("ISO-8859-4")) {
            return "latin4";
        }
        if (string.equals("ISO-8859-5")) {
            return "latin5";
        }
        if (string.equals("ISO-8859-9")) {
            return "latin9";
        }
        if (string.equals("ISO-8859-10")) {
            return "latin10";
        }
        if (string.equals("DEC-MCS")) {
            return "decmulti";
        }
        if (string.equals("Cp850")) {
            return "cp850";
        }
        if (string.equals("Cp852")) {
            return "cp852";
        }
        if (string.equals("Cp437")) {
            return "cp437";
        }
        if (string.equals("Cp865")) {
            return "cp865";
        }
        if (string.equals("MacRoman")) {
            return "applemac";
        }
        if (string.equals("MacCentralEurope")) {
            return "macce";
        }
        if (string.equals("Cp1250")) {
            return "cp1250";
        }
        if (string.equals("Cp1252")) {
            return "cp1252";
        }
        if (string.equals("Cp1257")) {
            return "cp1257";
        }
        throw new LaTeXSyntaxException(teXParser, ERROR_UNKNOWN_ENCODING, string);
    }

    public static Charset getCharSet(String string) throws IllegalCharsetNameException {
        return Charset.forName(InputEncSty.getCharSetName(string));
    }

    public static String getCharSetName(String string) throws IllegalCharsetNameException {
        if (string.equals("ascii")) {
            return "US-ASCII";
        }
        if (string.equals("latin1")) {
            return "ISO-8859-1";
        }
        if (string.equals("latin2")) {
            return "ISO-8859-2";
        }
        if (string.equals("latin3")) {
            return "ISO-8859-3";
        }
        if (string.equals("latin4")) {
            return "ISO-8859-4";
        }
        if (string.equals("latin5")) {
            return "ISO-8859-5";
        }
        if (string.equals("latin9")) {
            return "ISO-8859-9";
        }
        if (string.equals("latin10")) {
            return "ISO-8859-10";
        }
        if (string.equals("decmulti")) {
            return "DEC-MCS";
        }
        if (string.equals("cp850")) {
            return "Cp850";
        }
        if (string.equals("cp852")) {
            return "Cp852";
        }
        if (string.equals("cp858")) {
            return "Cp858";
        }
        if (string.equals("cp437") || string.equals("cp437de")) {
            return "Cp437";
        }
        if (string.equals("cp865")) {
            return "Cp865";
        }
        if (string.equals("applemac")) {
            return "MacRoman";
        }
        if (string.equals("macce")) {
            return "MacCentralEurope";
        }
        if (!string.equals("next")) {
            if (string.equals("cp1250")) {
                return "Cp1250";
            }
            if (string.equals("cp1252") || string.equals("ansinew")) {
                return "Cp1252";
            }
            if (string.equals("cp1257")) {
                return "Cp1257";
            }
            if (string.equals("utf8")) {
                return "UTF-8";
            }
        }
        return string;
    }

    public static boolean isKnownEncoding(String string) {
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            if (!KNOWN_ENCODINGS[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

