/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;

public class MediaType {
    private final String type;
    private final String subtype;
    private final LinkedHashMap<String, String> parameters;
    private final String charset;
    private volatile String noCharset;
    private volatile String withCharset;

    protected MediaType(String string, String string2, LinkedHashMap<String, String> linkedHashMap) {
        this.type = string;
        this.subtype = string2;
        this.parameters = linkedHashMap;
        String string3 = linkedHashMap.get("charset");
        if (string3 != null && !string3.isEmpty() && string3.charAt(0) == '\"') {
            string3 = HttpParser.unquote(string3);
        }
        this.charset = string3;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public String getParameterValue(String string) {
        return this.parameters.get(string.toLowerCase(Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.withCharset == null) {
            MediaType mediaType = this;
            synchronized (mediaType) {
                if (this.withCharset == null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.type);
                    stringBuilder.append('/');
                    stringBuilder.append(this.subtype);
                    for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                        String string = entry.getValue();
                        if (string == null || string.isEmpty()) continue;
                        stringBuilder.append(';');
                        stringBuilder.append(entry.getKey());
                        stringBuilder.append('=');
                        stringBuilder.append(string);
                    }
                    this.withCharset = stringBuilder.toString();
                }
            }
        }
        return this.withCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringNoCharset() {
        if (this.noCharset == null) {
            MediaType mediaType = this;
            synchronized (mediaType) {
                if (this.noCharset == null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.type);
                    stringBuilder.append('/');
                    stringBuilder.append(this.subtype);
                    for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                        if (entry.getKey().equalsIgnoreCase("charset")) continue;
                        stringBuilder.append(';');
                        stringBuilder.append(entry.getKey());
                        stringBuilder.append('=');
                        stringBuilder.append(entry.getValue());
                    }
                    this.noCharset = stringBuilder.toString();
                }
            }
        }
        return this.noCharset;
    }

    public static MediaType parseMediaType(Reader reader) throws IOException {
        String string = HttpParser.readToken(reader);
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (HttpParser.skipConstant(reader, "/") == SkipResult.NOT_FOUND) {
            return null;
        }
        String string2 = HttpParser.readToken(reader);
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        SkipResult skipResult = HttpParser.skipConstant(reader, ";");
        if (skipResult == SkipResult.NOT_FOUND) {
            return null;
        }
        while (skipResult == SkipResult.FOUND) {
            String string3 = HttpParser.readToken(reader);
            String string4 = HttpParser.skipConstant(reader, "=") == SkipResult.FOUND ? HttpParser.readTokenOrQuotedString(reader, true) : "";
            if (string3 != null) {
                linkedHashMap.put(string3.toLowerCase(Locale.ENGLISH), string4);
            }
            if ((skipResult = HttpParser.skipConstant(reader, ";")) != SkipResult.NOT_FOUND) continue;
            return null;
        }
        return new MediaType(string, string2, linkedHashMap);
    }

    public static String parseMediaTypeOnly(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        String string2 = n > -1 ? string.substring(0, n) : string;
        string2 = string2.trim();
        string2 = string2.toLowerCase(Locale.ENGLISH);
        return string2;
    }
}

