/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.util.LifecycleBase;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractResourceSet
extends LifecycleBase
implements WebResourceSet {
    private WebResourceRoot root;
    private String base;
    private String internalPath = "";
    private String webAppMount;
    private boolean classLoaderOnly;
    private boolean staticOnly;
    private Manifest manifest;
    protected static final StringManager sm = StringManager.getManager(AbstractResourceSet.class);

    protected final void checkPath(String string) {
        if (string == null || string.isEmpty() || string.charAt(0) != '/') {
            throw new IllegalArgumentException(sm.getString("abstractResourceSet.checkPath", new Object[]{string}));
        }
    }

    @Override
    public final void setRoot(WebResourceRoot webResourceRoot) {
        this.root = webResourceRoot;
    }

    protected final WebResourceRoot getRoot() {
        return this.root;
    }

    protected final String getInternalPath() {
        return this.internalPath;
    }

    public final void setInternalPath(String string) {
        this.checkPath(string);
        this.internalPath = string.equals("/") ? "" : string;
    }

    public final void setWebAppMount(String string) {
        this.checkPath(string);
        this.webAppMount = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
    }

    protected final String getWebAppMount() {
        return this.webAppMount;
    }

    protected boolean isPathMounted(String string, String string2) {
        if (string.startsWith(string2)) {
            return string.length() == string2.length() || string.charAt(string2.length()) == '/';
        }
        return false;
    }

    public final void setBase(String string) {
        this.base = string;
    }

    protected final String getBase() {
        return this.base;
    }

    @Override
    public boolean getClassLoaderOnly() {
        return this.classLoaderOnly;
    }

    @Override
    public void setClassLoaderOnly(boolean bl) {
        this.classLoaderOnly = bl;
    }

    @Override
    public boolean getStaticOnly() {
        return this.staticOnly;
    }

    @Override
    public void setStaticOnly(boolean bl) {
        this.staticOnly = bl;
    }

    protected final void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    protected final Manifest getManifest() {
        return this.manifest;
    }

    @Override
    protected final void startInternal() throws LifecycleException {
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected final void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
    }

    @Override
    protected final void destroyInternal() throws LifecycleException {
        this.gc();
    }
}

