﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codepipeline/CodePipeline_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace CodePipeline
{
namespace Model
{
  enum class PipelineTriggerProviderType
  {
    NOT_SET,
    CodeStarSourceConnection
  };

namespace PipelineTriggerProviderTypeMapper
{
AWS_CODEPIPELINE_API PipelineTriggerProviderType GetPipelineTriggerProviderTypeForName(const Aws::String& name);

AWS_CODEPIPELINE_API Aws::String GetNameForPipelineTriggerProviderType(PipelineTriggerProviderType value);
} // namespace PipelineTriggerProviderTypeMapper
} // namespace Model
} // namespace CodePipeline
} // namespace Aws
