﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/entityresolution/EntityResolution_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace EntityResolution
{
namespace Model
{
  enum class StatementEffect
  {
    NOT_SET,
    Allow,
    Deny
  };

namespace StatementEffectMapper
{
AWS_ENTITYRESOLUTION_API StatementEffect GetStatementEffectForName(const Aws::String& name);

AWS_ENTITYRESOLUTION_API Aws::String GetNameForStatementEffect(StatementEffect value);
} // namespace StatementEffectMapper
} // namespace Model
} // namespace EntityResolution
} // namespace Aws
