# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Annotation(msrest.serialization.Model):
    """Annotation associated with an application insights resource.

    :param annotation_name: Name of annotation.
    :type annotation_name: str
    :param category: Category of annotation, free form.
    :type category: str
    :param event_time: Time when event occurred.
    :type event_time: ~datetime.datetime
    :param id: Unique Id for annotation.
    :type id: str
    :param properties: Serialized JSON object for detailed properties.
    :type properties: str
    :param related_annotation: Related parent annotation if any.
    :type related_annotation: str
    """

    _attribute_map = {
        'annotation_name': {'key': 'AnnotationName', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'event_time': {'key': 'EventTime', 'type': 'iso-8601'},
        'id': {'key': 'Id', 'type': 'str'},
        'properties': {'key': 'Properties', 'type': 'str'},
        'related_annotation': {'key': 'RelatedAnnotation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Annotation, self).__init__(**kwargs)
        self.annotation_name = kwargs.get('annotation_name', None)
        self.category = kwargs.get('category', None)
        self.event_time = kwargs.get('event_time', None)
        self.id = kwargs.get('id', None)
        self.properties = kwargs.get('properties', None)
        self.related_annotation = kwargs.get('related_annotation', "null")


class AnnotationError(msrest.serialization.Model):
    """Error associated with trying to create annotation with Id that already exist.

    :param code: Error detail code and explanation.
    :type code: str
    :param message: Error message.
    :type message: str
    :param innererror: Inner error.
    :type innererror: ~azure.mgmt.applicationinsights.v2015_05_01.models.InnerError
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnnotationError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.innererror = kwargs.get('innererror', None)


class AnnotationsListResult(msrest.serialization.Model):
    """Annotations list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of annotations.
    :vartype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.Annotation]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Annotation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnnotationsListResult, self).__init__(**kwargs)
        self.value = None


class APIKeyRequest(msrest.serialization.Model):
    """An Application Insights component API Key creation request definition.

    :param name: The name of the API Key.
    :type name: str
    :param linked_read_properties: The read access rights of this API Key.
    :type linked_read_properties: list[str]
    :param linked_write_properties: The write access rights of this API Key.
    :type linked_write_properties: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'linked_read_properties': {'key': 'linkedReadProperties', 'type': '[str]'},
        'linked_write_properties': {'key': 'linkedWriteProperties', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(APIKeyRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.linked_read_properties = kwargs.get('linked_read_properties', None)
        self.linked_write_properties = kwargs.get('linked_write_properties', None)


class ComponentsResource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentsResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class ApplicationInsightsComponent(ComponentsResource):
    """An Application Insights component definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: Required. The kind of application that this component refers to, used to customize
     UI. This value is a freeform string, values should typically be one of the following: web, ios,
     other, store, java, phone.
    :type kind: str
    :ivar application_id: The unique ID of your application. This field mirrors the 'Name' field
     and cannot be changed.
    :vartype application_id: str
    :ivar app_id: Application Insights Unique ID for your Application.
    :vartype app_id: str
    :param application_type: Type of application being monitored. Possible values include: "web",
     "other". Default value: "web".
    :type application_type: str or
     ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationType
    :param flow_type: Used by the Application Insights system to determine what kind of flow this
     component was created by. This is to be set to 'Bluefield' when creating/updating a component
     via the REST API. Possible values include: "Bluefield". Default value: "Bluefield".
    :type flow_type: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.FlowType
    :param request_source: Describes what tool created this Application Insights component.
     Customers using this API should set this to the default 'rest'. Possible values include:
     "rest". Default value: "rest".
    :type request_source: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.RequestSource
    :ivar instrumentation_key: Application Insights Instrumentation key. A read-only value that
     applications can use to identify the destination for all telemetry sent to Azure Application
     Insights. This value will be supplied upon construction of each new Application Insights
     component.
    :vartype instrumentation_key: str
    :ivar creation_date: Creation Date for the Application Insights component, in ISO 8601 format.
    :vartype creation_date: ~datetime.datetime
    :ivar tenant_id: Azure Tenant Id.
    :vartype tenant_id: str
    :param hockey_app_id: The unique application ID created when a new application is added to
     HockeyApp, used for communications with HockeyApp.
    :type hockey_app_id: str
    :ivar hockey_app_token: Token used to authenticate communications with between Application
     Insights and HockeyApp.
    :vartype hockey_app_token: str
    :ivar provisioning_state: Current state of this component: whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
    :vartype provisioning_state: str
    :param sampling_percentage: Percentage of the data produced by the application being monitored
     that is being sampled for Application Insights telemetry.
    :type sampling_percentage: float
    :ivar connection_string: Application Insights component connection string.
    :vartype connection_string: str
    :param retention_in_days: Retention period in days.
    :type retention_in_days: int
    :param disable_ip_masking: Disable IP masking.
    :type disable_ip_masking: bool
    :param immediate_purge_data_on30_days: Purge data immediately after 30 days.
    :type immediate_purge_data_on30_days: bool
    :ivar private_link_scoped_resources: List of linked private link scope resources.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.PrivateLinkScopedResource]
    :param ingestion_mode: Indicates the flow of the ingestion. Possible values include:
     "ApplicationInsights", "ApplicationInsightsWithDiagnosticSettings", "LogAnalytics". Default
     value: "ApplicationInsights".
    :type ingestion_mode: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.IngestionMode
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'required': True},
        'application_id': {'readonly': True},
        'app_id': {'readonly': True},
        'instrumentation_key': {'readonly': True},
        'creation_date': {'readonly': True},
        'tenant_id': {'readonly': True},
        'hockey_app_token': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'connection_string': {'readonly': True},
        'private_link_scoped_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'application_id': {'key': 'properties.ApplicationId', 'type': 'str'},
        'app_id': {'key': 'properties.AppId', 'type': 'str'},
        'application_type': {'key': 'properties.Application_Type', 'type': 'str'},
        'flow_type': {'key': 'properties.Flow_Type', 'type': 'str'},
        'request_source': {'key': 'properties.Request_Source', 'type': 'str'},
        'instrumentation_key': {'key': 'properties.InstrumentationKey', 'type': 'str'},
        'creation_date': {'key': 'properties.CreationDate', 'type': 'iso-8601'},
        'tenant_id': {'key': 'properties.TenantId', 'type': 'str'},
        'hockey_app_id': {'key': 'properties.HockeyAppId', 'type': 'str'},
        'hockey_app_token': {'key': 'properties.HockeyAppToken', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sampling_percentage': {'key': 'properties.SamplingPercentage', 'type': 'float'},
        'connection_string': {'key': 'properties.ConnectionString', 'type': 'str'},
        'retention_in_days': {'key': 'properties.RetentionInDays', 'type': 'int'},
        'disable_ip_masking': {'key': 'properties.DisableIpMasking', 'type': 'bool'},
        'immediate_purge_data_on30_days': {'key': 'properties.ImmediatePurgeDataOn30Days', 'type': 'bool'},
        'private_link_scoped_resources': {'key': 'properties.PrivateLinkScopedResources', 'type': '[PrivateLinkScopedResource]'},
        'ingestion_mode': {'key': 'properties.IngestionMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponent, self).__init__(**kwargs)
        self.kind = kwargs['kind']
        self.application_id = None
        self.app_id = None
        self.application_type = kwargs.get('application_type', "web")
        self.flow_type = kwargs.get('flow_type', "Bluefield")
        self.request_source = kwargs.get('request_source', "rest")
        self.instrumentation_key = None
        self.creation_date = None
        self.tenant_id = None
        self.hockey_app_id = kwargs.get('hockey_app_id', None)
        self.hockey_app_token = None
        self.provisioning_state = None
        self.sampling_percentage = kwargs.get('sampling_percentage', None)
        self.connection_string = None
        self.retention_in_days = kwargs.get('retention_in_days', 90)
        self.disable_ip_masking = kwargs.get('disable_ip_masking', None)
        self.immediate_purge_data_on30_days = kwargs.get('immediate_purge_data_on30_days', None)
        self.private_link_scoped_resources = None
        self.ingestion_mode = kwargs.get('ingestion_mode', "ApplicationInsights")


class ApplicationInsightsComponentAnalyticsItem(msrest.serialization.Model):
    """Properties that define an Analytics item that is associated to an Application Insights component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Internally assigned unique id of the item definition.
    :type id: str
    :param name: The user-defined name of the item.
    :type name: str
    :param content: The content of this item.
    :type content: str
    :ivar version: This instance's version of the data model. This can change as new features are
     added.
    :vartype version: str
    :param scope: Enum indicating if this item definition is owned by a specific user or is shared
     between all users with access to the Application Insights component. Possible values include:
     "shared", "user".
    :type scope: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemScope
    :param type: Enum indicating the type of the Analytics item. Possible values include: "query",
     "function", "folder", "recent".
    :type type: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemType
    :ivar time_created: Date and time in UTC when this item was created.
    :vartype time_created: str
    :ivar time_modified: Date and time in UTC of the last modification that was made to this item.
    :vartype time_modified: str
    :param properties: A set of properties that can be defined in the context of a specific item
     type. Each type may have its own properties.
    :type properties:
     ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAnalyticsItemProperties
    """

    _validation = {
        'version': {'readonly': True},
        'time_created': {'readonly': True},
        'time_modified': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'content': {'key': 'Content', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'scope': {'key': 'Scope', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'time_created': {'key': 'TimeCreated', 'type': 'str'},
        'time_modified': {'key': 'TimeModified', 'type': 'str'},
        'properties': {'key': 'Properties', 'type': 'ApplicationInsightsComponentAnalyticsItemProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentAnalyticsItem, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.content = kwargs.get('content', None)
        self.version = None
        self.scope = kwargs.get('scope', None)
        self.type = kwargs.get('type', None)
        self.time_created = None
        self.time_modified = None
        self.properties = kwargs.get('properties', None)


class ApplicationInsightsComponentAnalyticsItemProperties(msrest.serialization.Model):
    """A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.

    :param function_alias: A function alias, used when the type of the item is Function.
    :type function_alias: str
    """

    _attribute_map = {
        'function_alias': {'key': 'functionAlias', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentAnalyticsItemProperties, self).__init__(**kwargs)
        self.function_alias = kwargs.get('function_alias', None)


class ApplicationInsightsComponentAPIKey(msrest.serialization.Model):
    """Properties that define an API key of an Application Insights Component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique ID of the API key inside an Application Insights component. It is auto
     generated when the API key is created.
    :vartype id: str
    :ivar api_key: The API key value. It will be only return once when the API Key was created.
    :vartype api_key: str
    :param created_date: The create date of this API key.
    :type created_date: str
    :param name: The name of the API key.
    :type name: str
    :param linked_read_properties: The read access rights of this API Key.
    :type linked_read_properties: list[str]
    :param linked_write_properties: The write access rights of this API Key.
    :type linked_write_properties: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'api_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'api_key': {'key': 'apiKey', 'type': 'str'},
        'created_date': {'key': 'createdDate', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'linked_read_properties': {'key': 'linkedReadProperties', 'type': '[str]'},
        'linked_write_properties': {'key': 'linkedWriteProperties', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentAPIKey, self).__init__(**kwargs)
        self.id = None
        self.api_key = None
        self.created_date = kwargs.get('created_date', None)
        self.name = kwargs.get('name', None)
        self.linked_read_properties = kwargs.get('linked_read_properties', None)
        self.linked_write_properties = kwargs.get('linked_write_properties', None)


class ApplicationInsightsComponentAPIKeyListResult(msrest.serialization.Model):
    """Describes the list of API Keys of an Application Insights Component.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of API Key definitions.
    :type value:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAPIKey]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationInsightsComponentAPIKey]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentAPIKeyListResult, self).__init__(**kwargs)
        self.value = kwargs['value']


class ApplicationInsightsComponentAvailableFeatures(msrest.serialization.Model):
    """An Application Insights component available features.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar result: A list of Application Insights component feature.
    :vartype result:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentFeature]
    """

    _validation = {
        'result': {'readonly': True},
    }

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[ApplicationInsightsComponentFeature]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentAvailableFeatures, self).__init__(**kwargs)
        self.result = None


class ApplicationInsightsComponentBillingFeatures(msrest.serialization.Model):
    """An Application Insights component billing features.

    :param data_volume_cap: An Application Insights component daily data volume cap.
    :type data_volume_cap:
     ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentDataVolumeCap
    :param current_billing_features: Current enabled pricing plan. When the component is in the
     Enterprise plan, this will list both 'Basic' and 'Application Insights Enterprise'.
    :type current_billing_features: list[str]
    """

    _attribute_map = {
        'data_volume_cap': {'key': 'DataVolumeCap', 'type': 'ApplicationInsightsComponentDataVolumeCap'},
        'current_billing_features': {'key': 'CurrentBillingFeatures', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentBillingFeatures, self).__init__(**kwargs)
        self.data_volume_cap = kwargs.get('data_volume_cap', None)
        self.current_billing_features = kwargs.get('current_billing_features', None)


class ApplicationInsightsComponentDataVolumeCap(msrest.serialization.Model):
    """An Application Insights component daily data volume cap.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param cap: Daily data volume cap in GB.
    :type cap: float
    :ivar reset_time: Daily data volume cap UTC reset hour.
    :vartype reset_time: int
    :param warning_threshold: Reserved, not used for now.
    :type warning_threshold: int
    :param stop_send_notification_when_hit_threshold: Reserved, not used for now.
    :type stop_send_notification_when_hit_threshold: bool
    :param stop_send_notification_when_hit_cap: Do not send a notification email when the daily
     data volume cap is met.
    :type stop_send_notification_when_hit_cap: bool
    :ivar max_history_cap: Maximum daily data volume cap that the user can set for this component.
    :vartype max_history_cap: float
    """

    _validation = {
        'reset_time': {'readonly': True},
        'max_history_cap': {'readonly': True},
    }

    _attribute_map = {
        'cap': {'key': 'Cap', 'type': 'float'},
        'reset_time': {'key': 'ResetTime', 'type': 'int'},
        'warning_threshold': {'key': 'WarningThreshold', 'type': 'int'},
        'stop_send_notification_when_hit_threshold': {'key': 'StopSendNotificationWhenHitThreshold', 'type': 'bool'},
        'stop_send_notification_when_hit_cap': {'key': 'StopSendNotificationWhenHitCap', 'type': 'bool'},
        'max_history_cap': {'key': 'MaxHistoryCap', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentDataVolumeCap, self).__init__(**kwargs)
        self.cap = kwargs.get('cap', None)
        self.reset_time = None
        self.warning_threshold = kwargs.get('warning_threshold', None)
        self.stop_send_notification_when_hit_threshold = kwargs.get('stop_send_notification_when_hit_threshold', None)
        self.stop_send_notification_when_hit_cap = kwargs.get('stop_send_notification_when_hit_cap', None)
        self.max_history_cap = None


class ApplicationInsightsComponentExportConfiguration(msrest.serialization.Model):
    """Properties that define a Continuous Export configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar export_id: The unique ID of the export configuration inside an Application Insights
     component. It is auto generated when the Continuous Export configuration is created.
    :vartype export_id: str
    :ivar instrumentation_key: The instrumentation key of the Application Insights component.
    :vartype instrumentation_key: str
    :param record_types: This comma separated list of document types that will be exported. The
     possible values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews',
     'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
    :type record_types: str
    :ivar application_name: The name of the Application Insights component.
    :vartype application_name: str
    :ivar subscription_id: The subscription of the Application Insights component.
    :vartype subscription_id: str
    :ivar resource_group: The resource group of the Application Insights component.
    :vartype resource_group: str
    :ivar destination_storage_subscription_id: The destination storage account subscription ID.
    :vartype destination_storage_subscription_id: str
    :ivar destination_storage_location_id: The destination account location ID.
    :vartype destination_storage_location_id: str
    :ivar destination_account_id: The name of destination account.
    :vartype destination_account_id: str
    :ivar destination_type: The destination type.
    :vartype destination_type: str
    :ivar is_user_enabled: This will be 'true' if the Continuous Export configuration is enabled,
     otherwise it will be 'false'.
    :vartype is_user_enabled: str
    :ivar last_user_update: Last time the Continuous Export configuration was updated.
    :vartype last_user_update: str
    :param notification_queue_enabled: Deprecated.
    :type notification_queue_enabled: str
    :ivar export_status: This indicates current Continuous Export configuration status. The
     possible values are 'Preparing', 'Success', 'Failure'.
    :vartype export_status: str
    :ivar last_success_time: The last time data was successfully delivered to the destination
     storage container for this Continuous Export configuration.
    :vartype last_success_time: str
    :ivar last_gap_time: The last time the Continuous Export configuration started failing.
    :vartype last_gap_time: str
    :ivar permanent_error_reason: This is the reason the Continuous Export configuration started
     failing. It can be 'AzureStorageNotFound' or 'AzureStorageAccessDenied'.
    :vartype permanent_error_reason: str
    :ivar storage_name: The name of the destination storage account.
    :vartype storage_name: str
    :ivar container_name: The name of the destination storage container.
    :vartype container_name: str
    """

    _validation = {
        'export_id': {'readonly': True},
        'instrumentation_key': {'readonly': True},
        'application_name': {'readonly': True},
        'subscription_id': {'readonly': True},
        'resource_group': {'readonly': True},
        'destination_storage_subscription_id': {'readonly': True},
        'destination_storage_location_id': {'readonly': True},
        'destination_account_id': {'readonly': True},
        'destination_type': {'readonly': True},
        'is_user_enabled': {'readonly': True},
        'last_user_update': {'readonly': True},
        'export_status': {'readonly': True},
        'last_success_time': {'readonly': True},
        'last_gap_time': {'readonly': True},
        'permanent_error_reason': {'readonly': True},
        'storage_name': {'readonly': True},
        'container_name': {'readonly': True},
    }

    _attribute_map = {
        'export_id': {'key': 'ExportId', 'type': 'str'},
        'instrumentation_key': {'key': 'InstrumentationKey', 'type': 'str'},
        'record_types': {'key': 'RecordTypes', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'subscription_id': {'key': 'SubscriptionId', 'type': 'str'},
        'resource_group': {'key': 'ResourceGroup', 'type': 'str'},
        'destination_storage_subscription_id': {'key': 'DestinationStorageSubscriptionId', 'type': 'str'},
        'destination_storage_location_id': {'key': 'DestinationStorageLocationId', 'type': 'str'},
        'destination_account_id': {'key': 'DestinationAccountId', 'type': 'str'},
        'destination_type': {'key': 'DestinationType', 'type': 'str'},
        'is_user_enabled': {'key': 'IsUserEnabled', 'type': 'str'},
        'last_user_update': {'key': 'LastUserUpdate', 'type': 'str'},
        'notification_queue_enabled': {'key': 'NotificationQueueEnabled', 'type': 'str'},
        'export_status': {'key': 'ExportStatus', 'type': 'str'},
        'last_success_time': {'key': 'LastSuccessTime', 'type': 'str'},
        'last_gap_time': {'key': 'LastGapTime', 'type': 'str'},
        'permanent_error_reason': {'key': 'PermanentErrorReason', 'type': 'str'},
        'storage_name': {'key': 'StorageName', 'type': 'str'},
        'container_name': {'key': 'ContainerName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentExportConfiguration, self).__init__(**kwargs)
        self.export_id = None
        self.instrumentation_key = None
        self.record_types = kwargs.get('record_types', None)
        self.application_name = None
        self.subscription_id = None
        self.resource_group = None
        self.destination_storage_subscription_id = None
        self.destination_storage_location_id = None
        self.destination_account_id = None
        self.destination_type = None
        self.is_user_enabled = None
        self.last_user_update = None
        self.notification_queue_enabled = kwargs.get('notification_queue_enabled', None)
        self.export_status = None
        self.last_success_time = None
        self.last_gap_time = None
        self.permanent_error_reason = None
        self.storage_name = None
        self.container_name = None


class ApplicationInsightsComponentExportRequest(msrest.serialization.Model):
    """An Application Insights component Continuous Export configuration request definition.

    :param record_types: The document types to be exported, as comma separated values. Allowed
     values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews',
     'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
    :type record_types: str
    :param destination_type: The Continuous Export destination type. This has to be 'Blob'.
    :type destination_type: str
    :param destination_address: The SAS URL for the destination storage container. It must grant
     write permission.
    :type destination_address: str
    :param is_enabled: Set to 'true' to create a Continuous Export configuration as enabled,
     otherwise set it to 'false'.
    :type is_enabled: str
    :param notification_queue_enabled: Deprecated.
    :type notification_queue_enabled: str
    :param notification_queue_uri: Deprecated.
    :type notification_queue_uri: str
    :param destination_storage_subscription_id: The subscription ID of the destination storage
     container.
    :type destination_storage_subscription_id: str
    :param destination_storage_location_id: The location ID of the destination storage container.
    :type destination_storage_location_id: str
    :param destination_account_id: The name of destination storage account.
    :type destination_account_id: str
    """

    _attribute_map = {
        'record_types': {'key': 'RecordTypes', 'type': 'str'},
        'destination_type': {'key': 'DestinationType', 'type': 'str'},
        'destination_address': {'key': 'DestinationAddress', 'type': 'str'},
        'is_enabled': {'key': 'IsEnabled', 'type': 'str'},
        'notification_queue_enabled': {'key': 'NotificationQueueEnabled', 'type': 'str'},
        'notification_queue_uri': {'key': 'NotificationQueueUri', 'type': 'str'},
        'destination_storage_subscription_id': {'key': 'DestinationStorageSubscriptionId', 'type': 'str'},
        'destination_storage_location_id': {'key': 'DestinationStorageLocationId', 'type': 'str'},
        'destination_account_id': {'key': 'DestinationAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentExportRequest, self).__init__(**kwargs)
        self.record_types = kwargs.get('record_types', None)
        self.destination_type = kwargs.get('destination_type', None)
        self.destination_address = kwargs.get('destination_address', None)
        self.is_enabled = kwargs.get('is_enabled', None)
        self.notification_queue_enabled = kwargs.get('notification_queue_enabled', None)
        self.notification_queue_uri = kwargs.get('notification_queue_uri', None)
        self.destination_storage_subscription_id = kwargs.get('destination_storage_subscription_id', None)
        self.destination_storage_location_id = kwargs.get('destination_storage_location_id', None)
        self.destination_account_id = kwargs.get('destination_account_id', None)


class ApplicationInsightsComponentFavorite(msrest.serialization.Model):
    """Properties that define a favorite that is associated to an Application Insights component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: The user-defined name of the favorite.
    :type name: str
    :param config: Configuration of this particular favorite, which are driven by the Azure portal
     UX. Configuration data is a string containing valid JSON.
    :type config: str
    :param version: This instance's version of the data model. This can change as new features are
     added that can be marked favorite. Current examples include MetricsExplorer (ME) and Search.
    :type version: str
    :ivar favorite_id: Internally assigned unique id of the favorite definition.
    :vartype favorite_id: str
    :param favorite_type: Enum indicating if this favorite definition is owned by a specific user
     or is shared between all users with access to the Application Insights component. Possible
     values include: "shared", "user".
    :type favorite_type: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.FavoriteType
    :param source_type: The source of the favorite definition.
    :type source_type: str
    :ivar time_modified: Date and time in UTC of the last modification that was made to this
     favorite definition.
    :vartype time_modified: str
    :param tags: A set of tags. A list of 0 or more tags that are associated with this favorite
     definition.
    :type tags: list[str]
    :param category: Favorite category, as defined by the user at creation time.
    :type category: str
    :param is_generated_from_template: Flag denoting wether or not this favorite was generated from
     a template.
    :type is_generated_from_template: bool
    :ivar user_id: Unique user id of the specific user that owns this favorite.
    :vartype user_id: str
    """

    _validation = {
        'favorite_id': {'readonly': True},
        'time_modified': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'config': {'key': 'Config', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'favorite_id': {'key': 'FavoriteId', 'type': 'str'},
        'favorite_type': {'key': 'FavoriteType', 'type': 'str'},
        'source_type': {'key': 'SourceType', 'type': 'str'},
        'time_modified': {'key': 'TimeModified', 'type': 'str'},
        'tags': {'key': 'Tags', 'type': '[str]'},
        'category': {'key': 'Category', 'type': 'str'},
        'is_generated_from_template': {'key': 'IsGeneratedFromTemplate', 'type': 'bool'},
        'user_id': {'key': 'UserId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentFavorite, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.config = kwargs.get('config', None)
        self.version = kwargs.get('version', None)
        self.favorite_id = None
        self.favorite_type = kwargs.get('favorite_type', None)
        self.source_type = kwargs.get('source_type', None)
        self.time_modified = None
        self.tags = kwargs.get('tags', None)
        self.category = kwargs.get('category', None)
        self.is_generated_from_template = kwargs.get('is_generated_from_template', None)
        self.user_id = None


class ApplicationInsightsComponentFeature(msrest.serialization.Model):
    """An Application Insights component daily data volume cap status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar feature_name: The pricing feature name.
    :vartype feature_name: str
    :ivar meter_id: The meter id used for the feature.
    :vartype meter_id: str
    :ivar meter_rate_frequency: The meter rate for the feature's meter.
    :vartype meter_rate_frequency: str
    :ivar resouce_id: Reserved, not used now.
    :vartype resouce_id: str
    :ivar is_hidden: Reserved, not used now.
    :vartype is_hidden: bool
    :ivar capabilities: A list of Application Insights component feature capability.
    :vartype capabilities:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentFeatureCapability]
    :ivar title: Display name of the feature.
    :vartype title: str
    :ivar is_main_feature: Whether can apply addon feature on to it.
    :vartype is_main_feature: bool
    :ivar supported_addon_features: The add on features on main feature.
    :vartype supported_addon_features: str
    """

    _validation = {
        'feature_name': {'readonly': True},
        'meter_id': {'readonly': True},
        'meter_rate_frequency': {'readonly': True},
        'resouce_id': {'readonly': True},
        'is_hidden': {'readonly': True},
        'capabilities': {'readonly': True},
        'title': {'readonly': True},
        'is_main_feature': {'readonly': True},
        'supported_addon_features': {'readonly': True},
    }

    _attribute_map = {
        'feature_name': {'key': 'FeatureName', 'type': 'str'},
        'meter_id': {'key': 'MeterId', 'type': 'str'},
        'meter_rate_frequency': {'key': 'MeterRateFrequency', 'type': 'str'},
        'resouce_id': {'key': 'ResouceId', 'type': 'str'},
        'is_hidden': {'key': 'IsHidden', 'type': 'bool'},
        'capabilities': {'key': 'Capabilities', 'type': '[ApplicationInsightsComponentFeatureCapability]'},
        'title': {'key': 'Title', 'type': 'str'},
        'is_main_feature': {'key': 'IsMainFeature', 'type': 'bool'},
        'supported_addon_features': {'key': 'SupportedAddonFeatures', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentFeature, self).__init__(**kwargs)
        self.feature_name = None
        self.meter_id = None
        self.meter_rate_frequency = None
        self.resouce_id = None
        self.is_hidden = None
        self.capabilities = None
        self.title = None
        self.is_main_feature = None
        self.supported_addon_features = None


class ApplicationInsightsComponentFeatureCapabilities(msrest.serialization.Model):
    """An Application Insights component feature capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar support_export_data: Whether allow to use continuous export feature.
    :vartype support_export_data: bool
    :ivar burst_throttle_policy: Reserved, not used now.
    :vartype burst_throttle_policy: str
    :ivar metadata_class: Reserved, not used now.
    :vartype metadata_class: str
    :ivar live_stream_metrics: Reserved, not used now.
    :vartype live_stream_metrics: bool
    :ivar application_map: Reserved, not used now.
    :vartype application_map: bool
    :ivar work_item_integration: Whether allow to use work item integration feature.
    :vartype work_item_integration: bool
    :ivar power_bi_integration: Reserved, not used now.
    :vartype power_bi_integration: bool
    :ivar open_schema: Reserved, not used now.
    :vartype open_schema: bool
    :ivar proactive_detection: Reserved, not used now.
    :vartype proactive_detection: bool
    :ivar analytics_integration: Reserved, not used now.
    :vartype analytics_integration: bool
    :ivar multiple_step_web_test: Whether allow to use multiple steps web test feature.
    :vartype multiple_step_web_test: bool
    :ivar api_access_level: Reserved, not used now.
    :vartype api_access_level: str
    :ivar tracking_type: The application insights component used tracking type.
    :vartype tracking_type: str
    :ivar daily_cap: Daily data volume cap in GB.
    :vartype daily_cap: float
    :ivar daily_cap_reset_time: Daily data volume cap UTC reset hour.
    :vartype daily_cap_reset_time: float
    :ivar throttle_rate: Reserved, not used now.
    :vartype throttle_rate: float
    """

    _validation = {
        'support_export_data': {'readonly': True},
        'burst_throttle_policy': {'readonly': True},
        'metadata_class': {'readonly': True},
        'live_stream_metrics': {'readonly': True},
        'application_map': {'readonly': True},
        'work_item_integration': {'readonly': True},
        'power_bi_integration': {'readonly': True},
        'open_schema': {'readonly': True},
        'proactive_detection': {'readonly': True},
        'analytics_integration': {'readonly': True},
        'multiple_step_web_test': {'readonly': True},
        'api_access_level': {'readonly': True},
        'tracking_type': {'readonly': True},
        'daily_cap': {'readonly': True},
        'daily_cap_reset_time': {'readonly': True},
        'throttle_rate': {'readonly': True},
    }

    _attribute_map = {
        'support_export_data': {'key': 'SupportExportData', 'type': 'bool'},
        'burst_throttle_policy': {'key': 'BurstThrottlePolicy', 'type': 'str'},
        'metadata_class': {'key': 'MetadataClass', 'type': 'str'},
        'live_stream_metrics': {'key': 'LiveStreamMetrics', 'type': 'bool'},
        'application_map': {'key': 'ApplicationMap', 'type': 'bool'},
        'work_item_integration': {'key': 'WorkItemIntegration', 'type': 'bool'},
        'power_bi_integration': {'key': 'PowerBIIntegration', 'type': 'bool'},
        'open_schema': {'key': 'OpenSchema', 'type': 'bool'},
        'proactive_detection': {'key': 'ProactiveDetection', 'type': 'bool'},
        'analytics_integration': {'key': 'AnalyticsIntegration', 'type': 'bool'},
        'multiple_step_web_test': {'key': 'MultipleStepWebTest', 'type': 'bool'},
        'api_access_level': {'key': 'ApiAccessLevel', 'type': 'str'},
        'tracking_type': {'key': 'TrackingType', 'type': 'str'},
        'daily_cap': {'key': 'DailyCap', 'type': 'float'},
        'daily_cap_reset_time': {'key': 'DailyCapResetTime', 'type': 'float'},
        'throttle_rate': {'key': 'ThrottleRate', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentFeatureCapabilities, self).__init__(**kwargs)
        self.support_export_data = None
        self.burst_throttle_policy = None
        self.metadata_class = None
        self.live_stream_metrics = None
        self.application_map = None
        self.work_item_integration = None
        self.power_bi_integration = None
        self.open_schema = None
        self.proactive_detection = None
        self.analytics_integration = None
        self.multiple_step_web_test = None
        self.api_access_level = None
        self.tracking_type = None
        self.daily_cap = None
        self.daily_cap_reset_time = None
        self.throttle_rate = None


class ApplicationInsightsComponentFeatureCapability(msrest.serialization.Model):
    """An Application Insights component feature capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the capability.
    :vartype name: str
    :ivar description: The description of the capability.
    :vartype description: str
    :ivar value: The value of the capability.
    :vartype value: str
    :ivar unit: The unit of the capability.
    :vartype unit: str
    :ivar meter_id: The meter used for the capability.
    :vartype meter_id: str
    :ivar meter_rate_frequency: The meter rate of the meter.
    :vartype meter_rate_frequency: str
    """

    _validation = {
        'name': {'readonly': True},
        'description': {'readonly': True},
        'value': {'readonly': True},
        'unit': {'readonly': True},
        'meter_id': {'readonly': True},
        'meter_rate_frequency': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
        'unit': {'key': 'Unit', 'type': 'str'},
        'meter_id': {'key': 'MeterId', 'type': 'str'},
        'meter_rate_frequency': {'key': 'MeterRateFrequency', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentFeatureCapability, self).__init__(**kwargs)
        self.name = None
        self.description = None
        self.value = None
        self.unit = None
        self.meter_id = None
        self.meter_rate_frequency = None


class ApplicationInsightsComponentListResult(msrest.serialization.Model):
    """Describes the list of Application Insights Resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of Application Insights component definitions.
    :type value:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponent]
    :param next_link: The URI to get the next set of Application Insights component definitions if
     too many components where returned in the result set.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationInsightsComponent]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class ApplicationInsightsComponentProactiveDetectionConfiguration(msrest.serialization.Model):
    """Properties that define a ProactiveDetection configuration.

    :param name: The rule name.
    :type name: str
    :param enabled: A flag that indicates whether this rule is enabled by the user.
    :type enabled: bool
    :param send_emails_to_subscription_owners: A flag that indicated whether notifications on this
     rule should be sent to subscription owners.
    :type send_emails_to_subscription_owners: bool
    :param custom_emails: Custom email addresses for this rule notifications.
    :type custom_emails: list[str]
    :param last_updated_time: The last time this rule was updated.
    :type last_updated_time: str
    :param rule_definitions: Static definitions of the ProactiveDetection configuration rule (same
     values for all components).
    :type rule_definitions:
     ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'enabled': {'key': 'Enabled', 'type': 'bool'},
        'send_emails_to_subscription_owners': {'key': 'SendEmailsToSubscriptionOwners', 'type': 'bool'},
        'custom_emails': {'key': 'CustomEmails', 'type': '[str]'},
        'last_updated_time': {'key': 'LastUpdatedTime', 'type': 'str'},
        'rule_definitions': {'key': 'RuleDefinitions', 'type': 'ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentProactiveDetectionConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.enabled = kwargs.get('enabled', None)
        self.send_emails_to_subscription_owners = kwargs.get('send_emails_to_subscription_owners', None)
        self.custom_emails = kwargs.get('custom_emails', None)
        self.last_updated_time = kwargs.get('last_updated_time', None)
        self.rule_definitions = kwargs.get('rule_definitions', None)


class ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions(msrest.serialization.Model):
    """Static definitions of the ProactiveDetection configuration rule (same values for all components).

    :param name: The rule name.
    :type name: str
    :param display_name: The rule name as it is displayed in UI.
    :type display_name: str
    :param description: The rule description.
    :type description: str
    :param help_url: URL which displays additional info about the proactive detection rule.
    :type help_url: str
    :param is_hidden: A flag indicating whether the rule is hidden (from the UI).
    :type is_hidden: bool
    :param is_enabled_by_default: A flag indicating whether the rule is enabled by default.
    :type is_enabled_by_default: bool
    :param is_in_preview: A flag indicating whether the rule is in preview.
    :type is_in_preview: bool
    :param supports_email_notifications: A flag indicating whether email notifications are
     supported for detections for this rule.
    :type supports_email_notifications: bool
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'help_url': {'key': 'HelpUrl', 'type': 'str'},
        'is_hidden': {'key': 'IsHidden', 'type': 'bool'},
        'is_enabled_by_default': {'key': 'IsEnabledByDefault', 'type': 'bool'},
        'is_in_preview': {'key': 'IsInPreview', 'type': 'bool'},
        'supports_email_notifications': {'key': 'SupportsEmailNotifications', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.help_url = kwargs.get('help_url', None)
        self.is_hidden = kwargs.get('is_hidden', None)
        self.is_enabled_by_default = kwargs.get('is_enabled_by_default', None)
        self.is_in_preview = kwargs.get('is_in_preview', None)
        self.supports_email_notifications = kwargs.get('supports_email_notifications', None)


class ApplicationInsightsComponentQuotaStatus(msrest.serialization.Model):
    """An Application Insights component daily data volume cap status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar app_id: The Application ID for the Application Insights component.
    :vartype app_id: str
    :ivar should_be_throttled: The daily data volume cap is met, and data ingestion will be
     stopped.
    :vartype should_be_throttled: bool
    :ivar expiration_time: Date and time when the daily data volume cap will be reset, and data
     ingestion will resume.
    :vartype expiration_time: str
    """

    _validation = {
        'app_id': {'readonly': True},
        'should_be_throttled': {'readonly': True},
        'expiration_time': {'readonly': True},
    }

    _attribute_map = {
        'app_id': {'key': 'AppId', 'type': 'str'},
        'should_be_throttled': {'key': 'ShouldBeThrottled', 'type': 'bool'},
        'expiration_time': {'key': 'ExpirationTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentQuotaStatus, self).__init__(**kwargs)
        self.app_id = None
        self.should_be_throttled = None
        self.expiration_time = None


class ApplicationInsightsComponentWebTestLocation(msrest.serialization.Model):
    """Properties that define a web test location available to an Application Insights Component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: The display name of the web test location.
    :vartype display_name: str
    :ivar tag: Internally defined geographic location tag.
    :vartype tag: str
    """

    _validation = {
        'display_name': {'readonly': True},
        'tag': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'tag': {'key': 'Tag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsComponentWebTestLocation, self).__init__(**kwargs)
        self.display_name = None
        self.tag = None


class ApplicationInsightsWebTestLocationsListResult(msrest.serialization.Model):
    """Describes the list of web test locations available to an Application Insights Component.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of web test locations.
    :type value:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentWebTestLocation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationInsightsComponentWebTestLocation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationInsightsWebTestLocationsListResult, self).__init__(**kwargs)
        self.value = kwargs['value']


class ComponentPurgeBody(msrest.serialization.Model):
    """Describes the body of a purge request for an App Insights component.

    All required parameters must be populated in order to send to Azure.

    :param table: Required. Table from which to purge data.
    :type table: str
    :param filters: Required. The set of columns and filters (queries) to run over them to purge
     the resulting data.
    :type filters:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ComponentPurgeBodyFilters]
    """

    _validation = {
        'table': {'required': True},
        'filters': {'required': True},
    }

    _attribute_map = {
        'table': {'key': 'table', 'type': 'str'},
        'filters': {'key': 'filters', 'type': '[ComponentPurgeBodyFilters]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentPurgeBody, self).__init__(**kwargs)
        self.table = kwargs['table']
        self.filters = kwargs['filters']


class ComponentPurgeBodyFilters(msrest.serialization.Model):
    """User-defined filters to return data which will be purged from the table.

    :param column: The column of the table over which the given query should run.
    :type column: str
    :param operator: A query operator to evaluate over the provided column and value(s). Supported
     operators are ==, =~, in, in~, >, >=, <, <=, between, and have the same behavior as they would
     in a KQL query.
    :type operator: str
    :param value: the value for the operator to function over. This can be a number (e.g., > 100),
     a string (timestamp >= '2017-09-01') or array of values.
    :type value: object
    :param key: When filtering over custom dimensions, this key will be used as the name of the
     custom dimension.
    :type key: str
    """

    _attribute_map = {
        'column': {'key': 'column', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentPurgeBodyFilters, self).__init__(**kwargs)
        self.column = kwargs.get('column', None)
        self.operator = kwargs.get('operator', None)
        self.value = kwargs.get('value', None)
        self.key = kwargs.get('key', None)


class ComponentPurgeResponse(msrest.serialization.Model):
    """Response containing operationId for a specific purge action.

    All required parameters must be populated in order to send to Azure.

    :param operation_id: Required. Id to use when querying for status for a particular purge
     operation.
    :type operation_id: str
    """

    _validation = {
        'operation_id': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentPurgeResponse, self).__init__(**kwargs)
        self.operation_id = kwargs['operation_id']


class ComponentPurgeStatusResponse(msrest.serialization.Model):
    """Response containing status for a specific purge operation.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Status of the operation represented by the requested Id. Possible
     values include: "pending", "completed".
    :type status: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.PurgeState
    """

    _validation = {
        'status': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentPurgeStatusResponse, self).__init__(**kwargs)
        self.status = kwargs['status']


class ErrorFieldContract(msrest.serialization.Model):
    """Error Field contract.

    :param code: Property level error code.
    :type code: str
    :param message: Human-readable representation of property-level error.
    :type message: str
    :param target: Property name.
    :type target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorFieldContract, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates Insights service is not able to process the incoming request. The reason is provided in the error message.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class InnerError(msrest.serialization.Model):
    """Inner error.

    :param diagnosticcontext: Provides correlation for request.
    :type diagnosticcontext: str
    :param time: Request time.
    :type time: ~datetime.datetime
    """

    _attribute_map = {
        'diagnosticcontext': {'key': 'diagnosticcontext', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.diagnosticcontext = kwargs.get('diagnosticcontext', None)
        self.time = kwargs.get('time', None)


class LinkProperties(msrest.serialization.Model):
    """Contains a sourceId and workbook resource id to link two resources.

    :param source_id: The source Azure resource id.
    :type source_id: str
    :param target_id: The workbook Azure resource id.
    :type target_id: str
    :param category: The category of workbook.
    :type category: str
    """

    _attribute_map = {
        'source_id': {'key': 'sourceId', 'type': 'str'},
        'target_id': {'key': 'targetId', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkProperties, self).__init__(**kwargs)
        self.source_id = kwargs.get('source_id', None)
        self.target_id = kwargs.get('target_id', None)
        self.category = kwargs.get('category', None)


class MyWorkbookResource(msrest.serialization.Model):
    """An azure resource object.

    :param id: Azure resource Id.
    :type id: str
    :param name: Azure resource name.
    :type name: str
    :param type: Azure resource type.
    :type type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MyWorkbookResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class MyWorkbook(MyWorkbookResource):
    """An Application Insights private workbook definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Azure resource Id.
    :type id: str
    :param name: Azure resource name.
    :type name: str
    :param type: Azure resource type.
    :type type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: The kind of workbook. Choices are user and shared. Possible values include:
     "user", "shared".
    :type kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.SharedTypeKind
    :param display_name: The user-defined name of the private workbook.
    :type display_name: str
    :param serialized_data: Configuration of this particular private workbook. Configuration data
     is a string containing valid JSON.
    :type serialized_data: str
    :param version: This instance's version of the data model. This can change as new features are
     added that can be marked private workbook.
    :type version: str
    :ivar time_modified: Date and time in UTC of the last modification that was made to this
     private workbook definition.
    :vartype time_modified: str
    :param category: Workbook category, as defined by the user at creation time.
    :type category: str
    :param tags_properties_tags: A list of 0 or more tags that are associated with this private
     workbook definition.
    :type tags_properties_tags: list[str]
    :ivar user_id: Unique user id of the specific user that owns this private workbook.
    :vartype user_id: str
    :param source_id: Optional resourceId for a source resource.
    :type source_id: str
    """

    _validation = {
        'time_modified': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'serialized_data': {'key': 'properties.serializedData', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'time_modified': {'key': 'properties.timeModified', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'tags_properties_tags': {'key': 'properties.tags', 'type': '[str]'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
        'source_id': {'key': 'properties.sourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MyWorkbook, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.display_name = kwargs.get('display_name', None)
        self.serialized_data = kwargs.get('serialized_data', None)
        self.version = kwargs.get('version', None)
        self.time_modified = None
        self.category = kwargs.get('category', None)
        self.tags_properties_tags = kwargs.get('tags_properties_tags', None)
        self.user_id = None
        self.source_id = kwargs.get('source_id', None)


class MyWorkbookError(msrest.serialization.Model):
    """Error message body that will indicate why the operation failed.

    :param code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :type code: str
    :param message: Human-readable representation of the error.
    :type message: str
    :param details: The list of invalid fields send in request, in case of validation error.
    :type details: list[~azure.mgmt.applicationinsights.v2015_05_01.models.ErrorFieldContract]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorFieldContract]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MyWorkbookError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class MyWorkbooksListResult(msrest.serialization.Model):
    """Workbook list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of private workbooks.
    :vartype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.MyWorkbook]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MyWorkbook]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MyWorkbooksListResult, self).__init__(**kwargs)
        self.value = None


class Operation(msrest.serialization.Model):
    """CDN REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.applicationinsights.v2015_05_01.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    :param provider: Service provider: Microsoft.Cdn.
    :type provider: str
    :param resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list CDN operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of CDN operations supported by the CDN resource provider.
    :type value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PrivateLinkScopedResource(msrest.serialization.Model):
    """The private link scope resource reference.

    :param resource_id: The full resource Id of the private link scope resource.
    :type resource_id: str
    :param scope_id: The private link scope unique Identifier.
    :type scope_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'ResourceId', 'type': 'str'},
        'scope_id': {'key': 'ScopeId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkScopedResource, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.scope_id = kwargs.get('scope_id', None)


class TagsResource(msrest.serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a WebTest instance.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagsResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class WebtestsResource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebtestsResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class WebTest(WebtestsResource):
    """An Application Insights web test definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: The kind of web test that this web test watches. Choices are ping and multistep.
     Possible values include: "ping", "multistep".
    :type kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestKind
    :param synthetic_monitor_id: Unique ID of this WebTest. This is typically the same value as the
     Name field.
    :type synthetic_monitor_id: str
    :param web_test_name: User defined name if this WebTest.
    :type web_test_name: str
    :param description: Purpose/user defined descriptive test for this WebTest.
    :type description: str
    :param enabled: Is the test actively being monitored.
    :type enabled: bool
    :param frequency: Interval in seconds between test runs for this WebTest. Default value is 300.
    :type frequency: int
    :param timeout: Seconds until this WebTest will timeout and fail. Default value is 30.
    :type timeout: int
    :param web_test_kind: The kind of web test this is, valid choices are ping and multistep.
     Possible values include: "ping", "multistep".
    :type web_test_kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestKind
    :param retry_enabled: Allow for retries should this WebTest fail.
    :type retry_enabled: bool
    :param locations: A list of where to physically run the tests from to give global coverage for
     accessibility of your application.
    :type locations: list[~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestGeolocation]
    :param configuration: An XML configuration specification for a WebTest.
    :type configuration:
     ~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestPropertiesConfiguration
    :ivar provisioning_state: Current state of this component, whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'synthetic_monitor_id': {'key': 'properties.SyntheticMonitorId', 'type': 'str'},
        'web_test_name': {'key': 'properties.Name', 'type': 'str'},
        'description': {'key': 'properties.Description', 'type': 'str'},
        'enabled': {'key': 'properties.Enabled', 'type': 'bool'},
        'frequency': {'key': 'properties.Frequency', 'type': 'int'},
        'timeout': {'key': 'properties.Timeout', 'type': 'int'},
        'web_test_kind': {'key': 'properties.Kind', 'type': 'str'},
        'retry_enabled': {'key': 'properties.RetryEnabled', 'type': 'bool'},
        'locations': {'key': 'properties.Locations', 'type': '[WebTestGeolocation]'},
        'configuration': {'key': 'properties.Configuration', 'type': 'WebTestPropertiesConfiguration'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebTest, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.synthetic_monitor_id = kwargs.get('synthetic_monitor_id', None)
        self.web_test_name = kwargs.get('web_test_name', None)
        self.description = kwargs.get('description', None)
        self.enabled = kwargs.get('enabled', None)
        self.frequency = kwargs.get('frequency', 300)
        self.timeout = kwargs.get('timeout', 30)
        self.web_test_kind = kwargs.get('web_test_kind', None)
        self.retry_enabled = kwargs.get('retry_enabled', None)
        self.locations = kwargs.get('locations', None)
        self.configuration = kwargs.get('configuration', None)
        self.provisioning_state = None


class WebTestGeolocation(msrest.serialization.Model):
    """Geo-physical location to run a web test from. You must specify one or more locations for the test to run from.

    :param location: Location ID for the webtest to run from.
    :type location: str
    """

    _attribute_map = {
        'location': {'key': 'Id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebTestGeolocation, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)


class WebTestListResult(msrest.serialization.Model):
    """A list of 0 or more Application Insights web test definitions.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Set of Application Insights web test definitions.
    :type value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.WebTest]
    :param next_link: The link to get the next part of the returned list of web tests, should the
     return set be too large for a single request. May be null.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WebTest]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebTestListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class WebTestPropertiesConfiguration(msrest.serialization.Model):
    """An XML configuration specification for a WebTest.

    :param web_test: The XML specification of a WebTest to run against an application.
    :type web_test: str
    """

    _attribute_map = {
        'web_test': {'key': 'WebTest', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebTestPropertiesConfiguration, self).__init__(**kwargs)
        self.web_test = kwargs.get('web_test', None)


class WorkbookResource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkbookResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class Workbook(WorkbookResource):
    """An Application Insights workbook definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: The kind of workbook. Choices are user and shared. Possible values include:
     "user", "shared".
    :type kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.SharedTypeKind
    :param name_properties_name: The user-defined name of the workbook.
    :type name_properties_name: str
    :param serialized_data: Configuration of this particular workbook. Configuration data is a
     string containing valid JSON.
    :type serialized_data: str
    :param version: This instance's version of the data model. This can change as new features are
     added that can be marked workbook.
    :type version: str
    :param workbook_id: Internally assigned unique id of the workbook definition.
    :type workbook_id: str
    :param shared_type_kind: Enum indicating if this workbook definition is owned by a specific
     user or is shared between all users with access to the Application Insights component. Possible
     values include: "user", "shared".
    :type shared_type_kind: str or
     ~azure.mgmt.applicationinsights.v2015_05_01.models.SharedTypeKind
    :ivar time_modified: Date and time in UTC of the last modification that was made to this
     workbook definition.
    :vartype time_modified: str
    :param category: Workbook category, as defined by the user at creation time.
    :type category: str
    :param tags_properties_tags: A list of 0 or more tags that are associated with this workbook
     definition.
    :type tags_properties_tags: list[str]
    :param user_id: Unique user id of the specific user that owns this workbook.
    :type user_id: str
    :param source_resource_id: Optional resourceId for a source resource.
    :type source_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time_modified': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'serialized_data': {'key': 'properties.serializedData', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'workbook_id': {'key': 'properties.workbookId', 'type': 'str'},
        'shared_type_kind': {'key': 'properties.kind', 'type': 'str'},
        'time_modified': {'key': 'properties.timeModified', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'tags_properties_tags': {'key': 'properties.tags', 'type': '[str]'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
        'source_resource_id': {'key': 'properties.sourceResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Workbook, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.name_properties_name = kwargs.get('name_properties_name', None)
        self.serialized_data = kwargs.get('serialized_data', None)
        self.version = kwargs.get('version', None)
        self.workbook_id = kwargs.get('workbook_id', None)
        self.shared_type_kind = kwargs.get('shared_type_kind', None)
        self.time_modified = None
        self.category = kwargs.get('category', None)
        self.tags_properties_tags = kwargs.get('tags_properties_tags', None)
        self.user_id = kwargs.get('user_id', None)
        self.source_resource_id = kwargs.get('source_resource_id', None)


class WorkbookError(msrest.serialization.Model):
    """Error message body that will indicate why the operation failed.

    :param code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :type code: str
    :param message: Human-readable representation of the error.
    :type message: str
    :param details: The list of invalid fields send in request, in case of validation error.
    :type details: list[~azure.mgmt.applicationinsights.v2015_05_01.models.ErrorFieldContract]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorFieldContract]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkbookError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class WorkbooksListResult(msrest.serialization.Model):
    """Workbook list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of workbooks.
    :vartype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.Workbook]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workbook]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkbooksListResult, self).__init__(**kwargs)
        self.value = None


class WorkItemConfiguration(msrest.serialization.Model):
    """Work item configuration associated with an application insights resource.

    :param connector_id: Connector identifier where work item is created.
    :type connector_id: str
    :param config_display_name: Configuration friendly name.
    :type config_display_name: str
    :param is_default: Boolean value indicating whether configuration is default.
    :type is_default: bool
    :param id: Unique Id for work item.
    :type id: str
    :param config_properties: Serialized JSON object for detailed properties.
    :type config_properties: str
    """

    _attribute_map = {
        'connector_id': {'key': 'ConnectorId', 'type': 'str'},
        'config_display_name': {'key': 'ConfigDisplayName', 'type': 'str'},
        'is_default': {'key': 'IsDefault', 'type': 'bool'},
        'id': {'key': 'Id', 'type': 'str'},
        'config_properties': {'key': 'ConfigProperties', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkItemConfiguration, self).__init__(**kwargs)
        self.connector_id = kwargs.get('connector_id', None)
        self.config_display_name = kwargs.get('config_display_name', None)
        self.is_default = kwargs.get('is_default', None)
        self.id = kwargs.get('id', None)
        self.config_properties = kwargs.get('config_properties', None)


class WorkItemConfigurationError(msrest.serialization.Model):
    """Error associated with trying to get work item configuration or configurations.

    :param code: Error detail code and explanation.
    :type code: str
    :param message: Error message.
    :type message: str
    :param innererror: Inner error.
    :type innererror: ~azure.mgmt.applicationinsights.v2015_05_01.models.InnerError
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkItemConfigurationError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.innererror = kwargs.get('innererror', None)


class WorkItemConfigurationsListResult(msrest.serialization.Model):
    """Work item configuration list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of work item configurations.
    :vartype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.WorkItemConfiguration]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkItemConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkItemConfigurationsListResult, self).__init__(**kwargs)
        self.value = None


class WorkItemCreateConfiguration(msrest.serialization.Model):
    """Work item configuration creation payload.

    :param connector_id: Unique connector id.
    :type connector_id: str
    :param connector_data_configuration: Serialized JSON object for detailed properties.
    :type connector_data_configuration: str
    :param validate_only: Boolean indicating validate only.
    :type validate_only: bool
    :param work_item_properties: Custom work item properties.
    :type work_item_properties: dict[str, str]
    """

    _attribute_map = {
        'connector_id': {'key': 'ConnectorId', 'type': 'str'},
        'connector_data_configuration': {'key': 'ConnectorDataConfiguration', 'type': 'str'},
        'validate_only': {'key': 'ValidateOnly', 'type': 'bool'},
        'work_item_properties': {'key': 'WorkItemProperties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkItemCreateConfiguration, self).__init__(**kwargs)
        self.connector_id = kwargs.get('connector_id', None)
        self.connector_data_configuration = kwargs.get('connector_data_configuration', None)
        self.validate_only = kwargs.get('validate_only', None)
        self.work_item_properties = kwargs.get('work_item_properties', None)
