/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.ArrayList;
import java.util.List;
import proguard.ClassSpecification;
import proguard.ClassSpecificationVisitorFactory;
import proguard.KeepClassSpecification;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberDescriptorReferencedClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassPoolVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;

public class KeepClassSpecificationVisitorFactory
extends ClassSpecificationVisitorFactory {
    private final boolean shrinking;
    private final boolean optimizing;
    private final boolean obfuscating;

    public KeepClassSpecificationVisitorFactory(boolean shrinking, boolean optimizing, boolean obfuscating) {
        this.shrinking = shrinking;
        this.optimizing = optimizing;
        this.obfuscating = obfuscating;
    }

    @Override
    public ClassPoolVisitor createClassPoolVisitor(List keepClassSpecifications, ClassVisitor classVisitor, MemberVisitor fieldVisitor, MemberVisitor methodVisitor, AttributeVisitor attributeVisitor) {
        MultiClassPoolVisitor multiClassPoolVisitor = new MultiClassPoolVisitor();
        if (keepClassSpecifications != null) {
            for (int index = 0; index < keepClassSpecifications.size(); ++index) {
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)keepClassSpecifications.get(index);
                if (!(this.shrinking && !keepClassSpecification.allowShrinking || this.optimizing && !keepClassSpecification.allowOptimization) && (!this.obfuscating || keepClassSpecification.allowObfuscation)) continue;
                multiClassPoolVisitor.addClassPoolVisitor(this.createClassPoolVisitor(keepClassSpecification, classVisitor, fieldVisitor, methodVisitor, attributeVisitor));
            }
        }
        return multiClassPoolVisitor;
    }

    public ClassPoolVisitor createClassPoolVisitor(KeepClassSpecification keepClassSpecification, ClassVisitor classVisitor, MemberVisitor fieldVisitor, MemberVisitor methodVisitor, AttributeVisitor attributeVisitor) {
        ClassSpecification condition;
        ArrayList variableStringMatchers = new ArrayList();
        if (keepClassSpecification.markDescriptorClasses && classVisitor != null) {
            fieldVisitor = fieldVisitor == null ? new MemberDescriptorReferencedClassVisitor(classVisitor) : new MultiMemberVisitor(fieldVisitor, new MemberDescriptorReferencedClassVisitor(classVisitor));
            MemberVisitor memberVisitor = methodVisitor = methodVisitor == null ? new MemberDescriptorReferencedClassVisitor(classVisitor) : new MultiMemberVisitor(methodVisitor, new MemberDescriptorReferencedClassVisitor(classVisitor));
        }
        if (!keepClassSpecification.markClasses && !keepClassSpecification.markConditionally) {
            classVisitor = null;
        }
        if (attributeVisitor != null) {
            AttributeVisitor attributeVisitor2 = attributeVisitor = keepClassSpecification.markCodeAttributes ? new AttributeNameFilter("Code", attributeVisitor) : null;
        }
        if ((condition = keepClassSpecification.condition) != null) {
            MultiClassPoolVisitor keepClassPoolVisitor = new MultiClassPoolVisitor();
            ClassPoolVisitor conditionalKeepClassPoolVisitor = this.createClassTester(condition, keepClassPoolVisitor, variableStringMatchers);
            keepClassPoolVisitor.addClassPoolVisitor(this.createClassPoolVisitor(keepClassSpecification, classVisitor, fieldVisitor, methodVisitor, attributeVisitor, variableStringMatchers));
            return conditionalKeepClassPoolVisitor;
        }
        return this.createClassPoolVisitor(keepClassSpecification, classVisitor, fieldVisitor, methodVisitor, attributeVisitor, variableStringMatchers);
    }

    private ClassPoolVisitor createClassPoolVisitor(KeepClassSpecification keepClassSpecification, ClassVisitor classVisitor, MemberVisitor fieldVisitor, MemberVisitor methodVisitor, AttributeVisitor attributeVisitor, List variableStringMatchers) {
        if (keepClassSpecification.markConditionally) {
            MultiClassVisitor keepClassVisitor = new MultiClassVisitor();
            ClassPoolVisitor conditionalKeepClassPoolVisitor = this.createClassTester((ClassSpecification)keepClassSpecification, keepClassVisitor, new ArrayList(variableStringMatchers));
            keepClassVisitor.addClassVisitor(this.createCombinedClassVisitor(keepClassSpecification.attributeNames, keepClassSpecification.fieldSpecifications, keepClassSpecification.methodSpecifications, classVisitor, fieldVisitor, methodVisitor, attributeVisitor, variableStringMatchers));
            return conditionalKeepClassPoolVisitor;
        }
        return super.createClassPoolVisitor(keepClassSpecification, classVisitor, fieldVisitor, methodVisitor, attributeVisitor, variableStringMatchers);
    }
}

