/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ImplementedClassFilter
implements ClassVisitor {
    private final Clazz implementedClass;
    private final boolean includeImplementedClass;
    private final ClassVisitor acceptedClassVisitor;
    private final ClassVisitor rejectedClassVisitor;

    public ImplementedClassFilter(Clazz implementedClass, boolean includeImplementedClass, ClassVisitor acceptedClassVisitor, ClassVisitor rejectedClassVisistor) {
        this.implementedClass = implementedClass;
        this.includeImplementedClass = includeImplementedClass;
        this.acceptedClassVisitor = acceptedClassVisitor;
        this.rejectedClassVisitor = rejectedClassVisistor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor visitor = this.delegateVisitor(programClass);
        if (visitor != null) {
            visitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        ClassVisitor visitor = this.delegateVisitor(libraryClass);
        if (visitor != null) {
            visitor.visitLibraryClass(libraryClass);
        }
    }

    private ClassVisitor delegateVisitor(Clazz clazz) {
        return clazz.extendsOrImplements(this.implementedClass) && (clazz != this.implementedClass || this.includeImplementedClass) ? this.acceptedClassVisitor : this.rejectedClassVisitor;
    }
}

