/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.building;

import org.apache.maven.building.Problem;

class DefaultProblem
implements Problem {
    private final String source;
    private final int lineNumber;
    private final int columnNumber;
    private final String message;
    private final Exception exception;
    private final Problem.Severity severity;

    DefaultProblem(String message, Problem.Severity severity, String source2, int lineNumber, int columnNumber, Exception exception) {
        this.message = message;
        this.severity = severity != null ? severity : Problem.Severity.ERROR;
        this.source = source2 != null ? source2 : "";
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.exception = exception;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public String getLocation() {
        StringBuilder buffer2 = new StringBuilder(256);
        if (this.getSource().length() > 0) {
            if (buffer2.length() > 0) {
                buffer2.append(", ");
            }
            buffer2.append(this.getSource());
        }
        if (this.getLineNumber() > 0) {
            if (buffer2.length() > 0) {
                buffer2.append(", ");
            }
            buffer2.append("line ").append(this.getLineNumber());
        }
        if (this.getColumnNumber() > 0) {
            if (buffer2.length() > 0) {
                buffer2.append(", ");
            }
            buffer2.append("column ").append(this.getColumnNumber());
        }
        return buffer2.toString();
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public String getMessage() {
        String msg;
        if (this.message != null && this.message.length() > 0) {
            msg = this.message;
        } else {
            msg = this.exception.getMessage();
            if (msg == null) {
                msg = "";
            }
        }
        return msg;
    }

    @Override
    public Problem.Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        StringBuilder buffer2 = new StringBuilder(128);
        buffer2.append('[').append((Object)this.getSeverity()).append("] ");
        buffer2.append(this.getMessage());
        buffer2.append(" @ ").append(this.getLocation());
        return buffer2.toString();
    }
}

