/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;

public class LifecycleExecutionException
extends Exception {
    private MavenProject project;

    public LifecycleExecutionException(String message) {
        super(message);
    }

    public LifecycleExecutionException(Throwable cause) {
        super(cause);
    }

    public LifecycleExecutionException(String message, Throwable cause) {
        super(message, cause);
    }

    public LifecycleExecutionException(String message, MavenProject project2) {
        super(message);
        this.project = project2;
    }

    public LifecycleExecutionException(String message, MojoExecution execution, MavenProject project2) {
        super(message);
        this.project = project2;
    }

    public LifecycleExecutionException(String message, MojoExecution execution, MavenProject project2, Throwable cause) {
        super(message, cause);
        this.project = project2;
    }

    public LifecycleExecutionException(MojoExecution execution, MavenProject project2, Throwable cause) {
        this(LifecycleExecutionException.createMessage(execution, project2, cause), execution, project2, cause);
    }

    public MavenProject getProject() {
        return this.project;
    }

    private static String createMessage(MojoExecution execution, MavenProject project2, Throwable cause) {
        MessageBuilder buffer2 = MessageUtils.buffer(256);
        buffer2.a("Failed to execute goal");
        if (execution != null) {
            buffer2.a(Character.valueOf(' '));
            buffer2.mojo(execution.getGroupId() + ':' + execution.getArtifactId() + ':' + execution.getVersion() + ':' + execution.getGoal());
            buffer2.a(Character.valueOf(' ')).strong('(' + execution.getExecutionId() + ')');
        }
        if (project2 != null) {
            buffer2.a(" on project ");
            buffer2.project(project2.getArtifactId());
        }
        if (cause != null) {
            buffer2.a(": ").failure(cause.getMessage());
        }
        return buffer2.toString();
    }
}

