/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.commands;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.osgi.container.Module;
import org.osgi.framework.BundleContext;

public class ExportStateCommand {
    private final BundleContext context;

    public ExportStateCommand(BundleContext context) {
        this.context = context;
    }

    public void startService() {
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("osgi.command.scope", "export");
        ((Dictionary)dict).put("osgi.command.function", new String[]{"exportFrameworkState"});
        this.context.registerService(ExportStateCommand.class, (Object)this, dict);
    }

    @Descriptor(value="Exports the current framework state including the wiring information")
    public void exportFrameworkState(CommandSession session, String path) throws IOException {
        this.exportFrameworkState(session, path, true);
    }

    @Descriptor(value="Exports the current framework state, with or without the wiring information")
    public void exportFrameworkState(CommandSession session, String path, boolean persistWirings) throws IOException {
        block10: {
            Module module = (Module)this.context.getBundle(0L).adapt(Module.class);
            PrintStream console = session.getConsole();
            if (module != null) {
                File file = new File(path);
                console.println("Exporting ModuleDatabase to " + file.getAbsolutePath() + "...");
                Throwable throwable = null;
                Object var8_9 = null;
                try (DataOutputStream stream = new DataOutputStream(new FileOutputStream(file));){
                    module.getContainer().store(stream, persistWirings);
                    break block10;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            console.println("Can't determine ModuleDatabase!");
        }
    }
}

