/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;
import org.jkiss.dbeaver.ui.preferences.PrefPageProjectNetworkProfiles;
import org.jkiss.utils.CommonUtils;

public class ConnectionPageNetworkHandler
extends ConnectionWizardPage {
    private static final Log log = Log.getLog(ConnectionPageNetworkHandler.class);
    private final IDataSourceConnectionEditorSite site;
    private final NetworkHandlerDescriptor handlerDescriptor;
    private IObjectPropertyConfigurator<Object, DBWHandlerConfiguration> configurator;
    private Composite configuratorPlaceholder;
    private ControlEnableState configuratorEnableState;
    private DBWHandlerConfiguration handlerConfiguration;
    private Link profileProvidedHint;

    public ConnectionPageNetworkHandler(IDataSourceConnectionEditorSite site, NetworkHandlerDescriptor descriptor) {
        super(ConnectionPageNetworkHandler.class.getSimpleName() + "." + descriptor.getId());
        this.site = site;
        this.handlerDescriptor = descriptor;
        this.setTitle(descriptor.getCodeName());
        this.setDescription(descriptor.getDescription());
    }

    public void createControl(Composite parent) {
        try {
            String implName = this.handlerDescriptor.getHandlerType().getImplName();
            UIPropertyConfiguratorDescriptor configDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(implName);
            if (configDescriptor == null) {
                return;
            }
            this.configurator = configDescriptor.createConfigurator();
        }
        catch (DBException e) {
            log.error((Object)("Can't create network configurator '" + this.handlerDescriptor.getId() + "'"), (Throwable)e);
            return;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.profileProvidedHint = UIUtils.createInfoLink((Composite)composite, (String)"N/A", () -> {
            boolean bl = PrefPageProjectNetworkProfiles.open((Shell)this.getShell(), (RCPProject)this.site.getProject(), (DBWNetworkProfile)this.getActiveProfile());
        });
        this.configuratorPlaceholder = UIUtils.createComposite((Composite)composite, (int)1);
        this.configuratorPlaceholder.setLayoutData((Object)new GridData(1808));
        this.configurator.createControl(this.configuratorPlaceholder, (Object)this.handlerDescriptor, this::updatePageCompletion);
        this.setControl((Control)composite);
        this.refreshConfiguration(this.getActiveProfile());
    }

    protected void updatePageCompletion() {
        if (this.isPageComplete()) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
        } else {
            this.setPageComplete(false);
            this.setErrorMessage(this.configurator.getErrorMessage());
        }
    }

    public boolean isPageComplete() {
        return this.handlerConfiguration == null || !this.handlerConfiguration.isEnabled() || this.configurator.isComplete();
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        if (this.handlerConfiguration == null) {
            return;
        }
        configuration.setConfigProfile(this.getActiveProfile());
        if (this.handlerConfiguration.isEnabled()) {
            this.configurator.saveSettings((Object)this.handlerConfiguration);
            configuration.updateHandler(this.handlerConfiguration);
        } else {
            configuration.removeHandler(this.handlerConfiguration.getId());
        }
    }

    public void refreshConfiguration(@Nullable DBWNetworkProfile profile) {
        DBWHandlerConfiguration profileConfiguration;
        this.loadConfiguration(profile);
        if (this.handlerConfiguration != null) {
            this.configurator.loadSettings((Object)this.handlerConfiguration);
        }
        this.configuratorPlaceholder.setRedraw(false);
        if (this.configuratorEnableState != null) {
            this.configuratorEnableState.restore();
            this.configuratorEnableState = null;
        }
        DBWHandlerConfiguration dBWHandlerConfiguration = profileConfiguration = profile != null ? profile.getConfiguration((DBWHandlerDescriptor)this.handlerDescriptor) : null;
        if (profileConfiguration != null && profileConfiguration.isEnabled()) {
            if (this.configuratorEnableState == null) {
                this.configuratorEnableState = ControlEnableState.disable((Control)this.configuratorPlaceholder);
            }
            this.profileProvidedHint.setText(NLS.bind((String)"Using configuration from profile ''<a href=\"#\">{0}</a>''", (Object)profile.getProfileName()));
            UIUtils.setControlVisible((Control)this.profileProvidedHint.getParent(), (boolean)true);
        } else {
            UIUtils.setControlVisible((Control)this.profileProvidedHint.getParent(), (boolean)false);
        }
        this.configuratorPlaceholder.getParent().layout(true, true);
        this.configuratorPlaceholder.setRedraw(true);
        this.updatePageCompletion();
    }

    public void loadConfiguration(@Nullable DBWNetworkProfile profile) {
        DBWHandlerConfiguration profileConfiguration;
        DBWHandlerConfiguration dBWHandlerConfiguration = profileConfiguration = profile != null ? profile.getConfiguration((DBWHandlerDescriptor)this.handlerDescriptor) : null;
        if (profile != null) {
            if (profileConfiguration != null && profileConfiguration.isEnabled()) {
                this.handlerConfiguration = new DBWHandlerConfiguration(profileConfiguration);
            } else {
                log.warn((Object)("Attempt to configure " + this.handlerDescriptor.getId() + " with profile " + profile.getProfileName() + " set that doesn't provide it"));
            }
        } else {
            DBPDataSourceContainer dataSource = this.site.getActiveDataSource();
            DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
            this.handlerConfiguration = configuration.getHandler(this.handlerDescriptor.getId());
            if (this.handlerConfiguration == null) {
                this.handlerConfiguration = new DBWHandlerConfiguration((DBWHandlerDescriptor)this.handlerDescriptor, dataSource);
                configuration.updateHandler(this.handlerConfiguration);
            }
        }
    }

    @Nullable
    public DBWHandlerConfiguration getHandlerConfiguration() {
        return this.handlerConfiguration;
    }

    @NotNull
    public NetworkHandlerDescriptor getHandlerDescriptor() {
        return this.handlerDescriptor;
    }

    @Nullable
    private DBWNetworkProfile getActiveProfile() {
        DBPDataSourceContainer dataSource = this.site.getActiveDataSource();
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        if (CommonUtils.isEmpty((String)configuration.getConfigProfileName())) {
            return null;
        }
        return dataSource.getRegistry().getNetworkProfile(configuration.getConfigProfileSource(), configuration.getConfigProfileName());
    }
}

