/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.e4.ui.css.core.dom.IStreamingNodeList;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.ControlElement;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Node;

public class CompositeElement
extends ControlElement
implements IStreamingNodeList {
    private static final String BACKGROUND_OVERRIDDEN_BY_CSS_MARKER = "bgOverriddenByCSS";

    public CompositeElement(Composite composite, CSSEngine engine) {
        super((Control)composite, engine);
    }

    @Override
    public int getLength() {
        return this.getComposite().getChildren().length;
    }

    @Override
    public Node item(int index) {
        Control w = this.getComposite().getChildren()[index];
        return this.getElement(w);
    }

    protected Composite getComposite() {
        return (Composite)this.getNativeWidget();
    }

    @Override
    public void reset() {
        Composite composite = this.getComposite();
        if (composite.getData(BACKGROUND_OVERRIDDEN_BY_CSS_MARKER) != null) {
            composite.setData(BACKGROUND_OVERRIDDEN_BY_CSS_MARKER, null);
        }
        super.reset();
    }

    public static boolean hasBackgroundOverriddenByCSS(Control control) {
        return control.getData(BACKGROUND_OVERRIDDEN_BY_CSS_MARKER) != null;
    }

    public static void setBackgroundOverriddenByCSSMarker(Widget widget) {
        if (widget instanceof Composite && !(widget instanceof CTabFolder)) {
            widget.setData(BACKGROUND_OVERRIDDEN_BY_CSS_MARKER, (Object)true);
        }
    }

    public Stream<Node> stream() {
        return Arrays.stream(this.getComposite().getChildren()).map(arg_0 -> ((CompositeElement)this).getElement(arg_0));
    }
}

