/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.Collections;
import java.util.Random;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.GraphUtilities;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;

class RankSorter {
    Random flipflop = new Random(3L);
    Node node;
    double rankSize;
    double prevRankSize;
    double nextRankSize;
    int currentRow;
    Rank rank;
    double progress;
    DirectedGraph g;

    RankSorter() {
    }

    protected void assignIncomingSortValues() {
        this.rankSize = this.rank.total;
        this.prevRankSize = this.g.ranks.getRank((int)(this.currentRow - 1)).total;
        if (this.currentRow < this.g.ranks.size() - 1) {
            this.nextRankSize = this.g.ranks.getRank((int)(this.currentRow + 1)).total;
        }
        int n = 0;
        while (n < this.rank.count()) {
            this.node = (Node)this.rank.get(n);
            this.sortValueIncoming();
            ++n;
        }
    }

    protected void assignOutgoingSortValues() {
        this.rankSize = this.rank.total;
        this.prevRankSize = this.g.ranks.getRank((int)(this.currentRow + 1)).total;
        if (this.currentRow > 1) {
            this.nextRankSize = this.g.ranks.getRank((int)(this.currentRow - 1)).total;
        }
        int n = 0;
        while (n < this.rank.count()) {
            this.node = (Node)this.rank.get(n);
            this.sortValueOutgoing();
            ++n;
        }
    }

    double evaluateNodeIncoming() {
        boolean change = false;
        EdgeList incoming = this.node.incoming;
        do {
            change = false;
            int i = 0;
            while (i < incoming.size() - 1) {
                if (incoming.getSourceIndex(i) > incoming.getSourceIndex(i + 1)) {
                    Edge e = (Edge)incoming.get(i);
                    incoming.set(i, (Edge)incoming.get(i + 1));
                    incoming.set(i + 1, e);
                    change = true;
                }
                ++i;
            }
        } while (change);
        int n = incoming.size();
        if (n == 0) {
            return (double)this.node.index * this.prevRankSize / this.rankSize;
        }
        if (n % 2 == 1) {
            return incoming.getSourceIndex(n / 2);
        }
        int l = incoming.getSourceIndex(n / 2 - 1);
        int r = incoming.getSourceIndex(n / 2);
        if (this.progress >= 0.8 && n > 2) {
            int dr;
            int dl = l - incoming.getSourceIndex(0);
            if (dl < (dr = incoming.getSourceIndex(n - 1) - r)) {
                return l;
            }
            if (dl > dr) {
                return r;
            }
        }
        if (this.progress > 0.25 && this.progress < 0.75) {
            if (this.flipflop.nextBoolean()) {
                return (double)(l + l + r) / 3.0;
            }
            return (double)(r + r + l) / 3.0;
        }
        return (double)(l + r) / 2.0;
    }

    double evaluateNodeOutgoing() {
        boolean change = false;
        EdgeList outgoing = this.node.outgoing;
        do {
            change = false;
            int i = 0;
            while (i < outgoing.size() - 1) {
                if (outgoing.getTargetIndex(i) > outgoing.getTargetIndex(i + 1)) {
                    Edge e = (Edge)outgoing.get(i);
                    outgoing.set(i, (Edge)outgoing.get(i + 1));
                    outgoing.set(i + 1, e);
                    change = true;
                }
                ++i;
            }
        } while (change);
        int n = outgoing.size();
        if (n == 0) {
            return (double)this.node.index * this.prevRankSize / this.rankSize;
        }
        if (n % 2 == 1) {
            return outgoing.getTargetIndex(n / 2);
        }
        int l = outgoing.getTargetIndex(n / 2 - 1);
        int r = outgoing.getTargetIndex(n / 2);
        if (this.progress >= 0.8 && n > 2) {
            int dr;
            int dl = l - outgoing.getTargetIndex(0);
            if (dl < (dr = outgoing.getTargetIndex(n - 1) - r)) {
                return l;
            }
            if (dl > dr) {
                return r;
            }
        }
        if (this.progress > 0.25 && this.progress < 0.75) {
            if (this.flipflop.nextBoolean()) {
                return (double)(l + l + r) / 3.0;
            }
            return (double)(r + r + l) / 3.0;
        }
        return (double)(l + r) / 2.0;
    }

    public void sortRankIncoming(DirectedGraph g, Rank rank, int row, double progress) {
        this.currentRow = row;
        this.rank = rank;
        this.progress = progress;
        this.assignIncomingSortValues();
        this.sort();
        this.postSort();
    }

    public void init(DirectedGraph g) {
        this.g = g;
        int i = 0;
        while (i < g.ranks.size()) {
            this.rank = g.ranks.getRank(i);
            Collections.sort(this.rank, (left, right) -> left.getRowConstraint() - right.getRowConstraint());
            this.postSort();
            ++i;
        }
    }

    void optimize(DirectedGraph g) {
    }

    protected void postSort() {
        this.rank.assignIndices();
    }

    void sort() {
        boolean change;
        do {
            change = false;
            int i = 0;
            while (i < this.rank.size() - 1) {
                change |= this.swap(i);
                ++i;
            }
            if (!change) break;
            change = false;
            i = this.rank.size() - 2;
            while (i >= 0) {
                change |= this.swap(i);
                --i;
            }
        } while (change);
    }

    boolean swap(int i) {
        Node right;
        Node left = (Node)this.rank.get(i);
        if (GraphUtilities.isConstrained(left, right = (Node)this.rank.get(i + 1))) {
            return false;
        }
        if (left.sortValue <= right.sortValue) {
            return false;
        }
        this.rank.set(i, right);
        this.rank.set(i + 1, left);
        return true;
    }

    public void sortRankOutgoing(DirectedGraph g, Rank rank, int row, double progress) {
        this.currentRow = row;
        this.rank = rank;
        this.progress = progress;
        this.assignOutgoingSortValues();
        this.sort();
        this.postSort();
    }

    void sortValueIncoming() {
        this.node.sortValue = this.evaluateNodeIncoming();
        double value = this.evaluateNodeOutgoing();
        if (value < 0.0) {
            value = (double)this.node.index * this.nextRankSize / this.rankSize;
        }
        this.node.sortValue += value * this.progress;
    }

    void sortValueOutgoing() {
        this.node.sortValue = this.evaluateNodeOutgoing();
        double value = this.evaluateNodeIncoming();
        if (value < 0.0) {
            value = (double)this.node.index * this.nextRankSize / this.rankSize;
        }
        this.node.sortValue += value * this.progress;
    }
}

