/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.expressions.Expression;
import org.eclipse.ui.internal.util.Util;

public final class ActivityDefinition
implements Comparable<ActivityDefinition> {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = ActivityDefinition.class.getName().hashCode();
    private transient int hashCode = HASH_INITIAL;
    private String id;
    private String name;
    private String sourceId;
    private String description;
    private transient String string;
    private Expression enabledWhen;

    static Map<String, ActivityDefinition> activityDefinitionsById(Collection<ActivityDefinition> activityDefinitions, boolean allowNullIds) {
        if (activityDefinitions == null) {
            throw new NullPointerException();
        }
        HashMap<String, ActivityDefinition> map = new HashMap<String, ActivityDefinition>();
        for (ActivityDefinition activityDefinition : activityDefinitions) {
            String id = activityDefinition.getId();
            if (!allowNullIds && id == null) continue;
            map.put(id, activityDefinition);
        }
        return map;
    }

    static Map<String, Collection<ActivityDefinition>> activityDefinitionsByName(Collection<ActivityDefinition> activityDefinitions, boolean allowNullNames) {
        if (activityDefinitions == null) {
            throw new NullPointerException();
        }
        HashMap<String, Collection<ActivityDefinition>> map = new HashMap<String, Collection<ActivityDefinition>>();
        for (ActivityDefinition activityDefinition : activityDefinitions) {
            String name = activityDefinition.getName();
            if (!allowNullNames && name == null) continue;
            HashSet<ActivityDefinition> activityDefinitions2 = (HashSet<ActivityDefinition>)map.get(name);
            if (activityDefinitions2 == null) {
                activityDefinitions2 = new HashSet<ActivityDefinition>();
                map.put(name, activityDefinitions2);
            }
            activityDefinitions2.add(activityDefinition);
        }
        return map;
    }

    public ActivityDefinition(String id, String name, String sourceId, String description) {
        this.id = id;
        this.name = name;
        this.sourceId = sourceId;
        this.description = description;
    }

    @Override
    public int compareTo(ActivityDefinition object) {
        int compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)object.id));
        if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)object.name))) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.sourceId), (Comparable)((Object)object.sourceId));
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ActivityDefinition)) {
            return false;
        }
        ActivityDefinition castedObject = (ActivityDefinition)object;
        return Objects.equals(this.id, castedObject.id) && Objects.equals(this.name, castedObject.name) && Objects.equals(this.sourceId, castedObject.sourceId);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.name);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.sourceId);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append('[');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.sourceId);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public String getDescription() {
        return this.description;
    }

    void setEnabledWhen(Expression expression) {
        this.enabledWhen = expression;
    }

    public Expression getEnabledWhen() {
        return this.enabledWhen;
    }
}

