/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.datum.Ellipsoid;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.Geographic2Geocentric;

public class Geocentric2Geographic
extends AbstractCoordinateOperation {
    private static final Identifier opId = new Identifier("EPSG", "9602", "Geocentric to geographic conversion", "Geocentric to geographic");
    private final Ellipsoid ellipsoid;
    private final double epsilon;

    public Geocentric2Geographic(Ellipsoid ellipsoid) {
        super(opId);
        this.ellipsoid = ellipsoid;
        this.precision = 1.0E-4;
        this.epsilon = 1.0E-11;
    }

    public Geocentric2Geographic(Ellipsoid ellipsoid, double epsilon) {
        super(opId);
        this.ellipsoid = ellipsoid;
        this.precision = 1.0E-4;
        this.epsilon = epsilon;
    }

    @Override
    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord.length < 3) {
            throw new CoordinateDimensionException(coord, 3);
        }
        double X = coord[0];
        double Y = coord[1];
        double Z = coord[2];
        double a = this.ellipsoid.getSemiMajorAxis();
        double e2 = this.ellipsoid.getSquareEccentricity();
        double lon = Math.atan2(Y, X);
        double XY2 = Math.sqrt(X * X + Y * Y);
        double lati = Math.atan(Z / (XY2 * (1.0 - a * e2 / Math.sqrt(X * X + Y * Y + Z * Z))));
        double lati1 = 0.0;
        while (Math.abs(lati1 - lati) > this.epsilon) {
            lati = lati1;
            double exp1 = a * e2 * Math.cos(lati);
            double exp2 = Math.sqrt(1.0 - e2 * Math.sin(lati) * Math.sin(lati));
            lati1 = Math.atan(Z / XY2 / (1.0 - exp1 / (XY2 * exp2)));
        }
        double lat = lati1;
        double height = XY2 / Math.cos(lat) - a / Math.sqrt(1.0 - e2 * Math.sin(lat) * Math.sin(lat));
        coord[0] = lat;
        coord[1] = lon;
        coord[2] = height;
        return coord;
    }

    @Override
    public CoordinateOperation inverse() {
        return new Geographic2Geocentric(this.ellipsoid);
    }

    @Override
    public String toString() {
        return this.getName() + " (" + this.ellipsoid.getName() + ")";
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Geocentric2Geographic) {
            Geocentric2Geographic gc2gg = (Geocentric2Geographic)o;
            return this.getEllipsoid().equals(gc2gg.getEllipsoid());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.ellipsoid != null ? this.ellipsoid.hashCode() : 0);
        return hash;
    }
}

