/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model.plan;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.hana.model.HANADataSource;
import org.jkiss.dbeaver.ext.hana.model.plan.HANAPlanNode;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;

public class HANAPlanAnalyser
extends AbstractExecutionPlan {
    private static final Log LOG = Log.getLog(HANAPlanAnalyser.class);
    private HANADataSource dataSource;
    private String query;
    private List<HANAPlanNode> rootNodes;

    public HANAPlanAnalyser(HANADataSource dataSource, String query) {
        this.dataSource = dataSource;
        this.query = query;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return "SELECT * FROM SYS.EXPLAIN_PLAN_TABLE";
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.rootNodes;
    }

    public void explain(DBCSession session) throws DBCException {
        this.rootNodes = new ArrayList<HANAPlanNode>();
        ArrayList<HANAPlanNode> allNodes = new ArrayList<HANAPlanNode>();
        JDBCSession connection = (JDBCSession)session;
        boolean oldAutoCommit = false;
        try {
            oldAutoCommit = connection.getAutoCommit();
            if (oldAutoCommit) {
                connection.setAutoCommit(false);
            }
            JDBCUtils.executeSQL((Connection)connection, (String)"DELETE FROM SYS.EXPLAIN_PLAN_TABLE", (Object[])new Object[0]);
            JDBCUtils.executeSQL((Connection)connection, (String)("EXPLAIN PLAN FOR " + this.query), (Object[])new Object[0]);
            try (JDBCPreparedStatement stmt = connection.prepareStatement(this.getPlanQueryString());
                 JDBCResultSet dbResult = stmt.executeQuery();){
                while (dbResult.next()) {
                    HANAPlanNode node = new HANAPlanNode((ResultSet)dbResult);
                    for (HANAPlanNode parent : allNodes) {
                        if (node.getParentOperatorId() != parent.getOperatorId()) continue;
                        node.setParent(parent);
                        parent.addNested(node);
                    }
                    allNodes.add(node);
                }
            }
            connection.rollback();
            for (HANAPlanNode node : allNodes) {
                if (node.getParent() != null) continue;
                this.rootNodes.add(node);
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
        finally {
            try {
                connection.rollback();
                if (oldAutoCommit) {
                    connection.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                LOG.error((Object)"Error closing plan analyser", (Throwable)e);
            }
        }
    }

    public HANADataSource getDataSource() {
        return this.dataSource;
    }
}

