# Screen Capture|deepin-screen-recorder|

## Overview

Screen Capture is a tool which integrates the screen capture and recorder functions into one. You are free to select windows or areas automatically or manually during screen capturing or recording. 

![partarea](fig/partarea.jpg)

## Guide

You can run, close, and create a desktop shortcut for Screen Capture in the following operations.

### Run Screen Capture

1. Click the Launcher icon ![deepin_launcher](../common/deepin_launcher.svg) in the Dock to enter the launcher interface.

2. Locate Screen Capture ![deepin_screenshot](../common/deepin_screenshot.svg) by scrolling the mouse wheel or searching "screen capture" in the Launcher interface and click it to run. 

3. Right-click ![deepin_screenshot](../common/deepin_screenshot.svg) and you can:

    - Click **Send to desktop** to create a desktop shortcut.
    - Click **Send to dock** to fix it in the Dock.
    - Click **Add to startup** to add it to startup and it will automatically run when the system starts up.
    
    > ![tips](../common/tips.svg) Tips: You can also run Screen Capture by clicking the ![1](../common/capture.svg) icon in the system plug-in area in the Dock or right-clicking it to select **Screenshot** or **Record**.

### Close Screen Capture

- Screen Capture will exit automatically after screen capturing or screen recording completes.
- On the Screen Capture interface, click ![close](../common/close.svg) to exit Screen Capture.
- On the Screen Capture interface, right-click and select **Save** or **Exit**.

### Shortcuts

In the Screenshot mode on the Screen Capture interface, press **Ctrl + Shift + ?** to view shortcuts. Proficiency in shortcuts will greatly improve your efficiency.

![1|hotkey](fig/hotkey.jpg)

## Select and Adjust Screen Capture Area

### Select Screen Capture Area

There are three kinds of common screen capture areas, namely the full screen, program window, and customized area. When a screen capture area is captured, the selected area will be bordered with dashed white line and looks brighter than the other area.

> ![notes](../common/notes.svg) Notes: When the computer is connected to multiple monitors, you can also use Screen Capture to capture areas on different monitors.

#### Select Full Screen

Full screen selection is used to identify the entire screen of the current monitor.

![1|fullscreen](fig/fullscreen.jpg)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

You can select the full screen in the following ways:

1. Press **Ctrl + Alt + A** or **Ctrl + Alt + R** on the keyboard to enter the screen capture mode.
2. Move the pointer to the desktop and the full screen will be selected automatically. The screen capture dimension will be displayed in the upper left corner. 
3. Click the desktop and a toolbar will pop up.

You can also take a full screen screenshot directly in the following ways:

- If Screen Capture has been fixed in the Dock, right-click ![deepin_screenshot](../common/deepin_screenshot.svg) in the Dock to select **Full creenshot**. 
- Press ![print](../common/Print.svg) on the keyboard to take a full screen screenshot.

#### Select Program Window

Program window selection is used to identify the current application window automatically.

![1|window](fig/window.jpg)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

1. Press **Ctrl + Alt + A**  or  **Ctrl + Alt + R** on the keyboard to enter the screen capture mode.
2. Move the pointer to the application window and the window will be selected automatically. The screen capture dimension will be displayed in the upper left corner. 
3. Click the window and a toolbar will pop up.

#### Select Customized Area

Customized area selection is used to select the screen capture area freely by dragging the mouse.

![1|partarea](fig/partarea.jpg)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

1. Press **Ctrl + Alt + A** or **Ctrl + Alt + R** on the keyboard to enter the screen capture mode.
2. Hold down and drag the left mouse button to select the screen capture area. The screen capture dimension will be displayed in the upper left corner. 
3. Release the left mouse button to complete area selection, and a toolbar will pop up.

### Adjust the Screen Capture Area

You can fine-tune the screen capture area. For example, you can enlarge or reduce the screenshot area, and move the screenshot position, among other functions. 

#### Enlarge/Reduce the Screen Capture Area

- Place the pointer over the white boarder of the screenshot area and the pointer will be changed to ![mouse_arrow](../common/Mouse_Arrow.svg). Hold down the left mouse button and drag the mouse to enlarge or reduce the screenshot area. 

- Press **Ctrl** + ![up](../common/Up.svg) , ![down](../common/Down.svg) , ![left](../common/Left.svg) or ![right](../common/Right.svg) and drag the mouse to enlarge or reduce the screenshot area vertically or horizontally.

#### Move the Screen Capture Area Position

Place the pointer over the screen capture area and it will be changed to ![finger](fig/fingers2.png). You can:

- Hold down the left mouse button and drag the mouse to move the position of the screenshot area.
- Press ![up](../common/Up.svg) , ![down](../common/Down.svg) , ![left](../common/Left.svg) or ![right](../common/Right.svg) on the keyboard to move the screenshot area vertically or horizontally.

## Take Screenshots

Under the screenshot mode, click the corresponding icons on the toolbar and you can perform operations such as drawing and editing graphics, adding text annotations, etc. in the screenshot  area.

![0|caputure_bar](fig/capture_bar.jpg)

<table class="block1">
    <caption>Icon Description</caption>
    <tbody>
        <tr>
            <td><img src="../common/pin.svg" alt="Pin Screenshot" class="inline" /></td>
            <td>Pin Screenshot</td>
            <td><img src="../common/scrollshot.svg" alt="Scrollshot" class="inline" /></td>
            <td>Scrollshot</td>
            <td><img src="../common/ocr.svg" alt="Extract Text" class="inline" /></td>
            <td>Extract Text</td>
            </tr>
        <tr>            
            <td><img src="../common/rectangle_normal.svg" alt="Rectangle" class="inline" /></td>
            <td>Rectangle</td>
            <td><img src="../common/oval_normal.svg" alt="Elipse" class="inline" /></td>
            <td>Elipse</td>               
            <td><img src="../common/line_normal.svg" alt="Arrow" class="inline" /></td>
            <td>Line</td>
            </tr>
        <tr>
            <td><img src="../common/Combined_Shape.svg" alt="Pencil" class="inline" /></td>
            <td>Pencil</td>
            <td><img src="../common/text_normal.svg" alt="text" class="inline" /></td>
            <td>Text</td>
            <td><img src="../common/close.svg" alt="exit" class="inline" /></td>
            <td>Exit</td>
        </tr>
    </tbody>
</table>




> ![notes](../common/notes.svg) Notes: Your settings in the toolbar and attribute column, such as the line weight and font size, are remembered and applied by default and will be resumed the next time when you launch Screen Capture. You are able to reset it as well. 

### Draw

You can draw some simple graphics in the screenshots. Click the icon on the toolbar, hold down the **Shift** key and drag the mouse to draw a square, circle and line or line with arrows horizontally and vertically.&nbsp;&nbsp;&nbsp;

#### Rectangle

![1|rectool](fig/rectool.jpg)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

1. Click ![rectangle](../common/rectangle_normal.svg) on the toolbar which appears beside the screenshot area.
2. In the toolbar extension panel, select the weight and color of outline for the rectangle shape. 
3. Place the pointer on the screenshot area, and the pointer will be changed to ![rect_mouse](../common/rect_mouse.svg).
4. Hold down the left mouse button, and drag the mouse to complete drawing.
5. Click ![vague](../common/vague_normal.svg) or ![mosaic](../common/Mosaic_normal.svg) in the toolbar extension panel to mosaic the private information in the screenshot (if any).

![2|blurtool](fig/blurtool.jpg)

![2|mosaictool](fig/mosaictool.jpg)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

#### Ellipse

![1|ellipse](fig/ellipse.jpg)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

1. Click ![oval](../common/oval_normal.svg) on the toolbar which appears beside the screenshot area.
2. In the toolbar extension panel, select the weight and color of outline for the ellipse shape. 
3. Place the pointer on the screenshot area, and the pointer will be changed to ![ellipse](../common/ellipse_mouse.svg).
4. Hold down the left mouse button, and drag the mouse to complete drawing.
5. Click ![vague](../common/vague_normal.svg) or ![mosaic](../common/Mosaic_normal.svg)in the toolbar extension panel to mosaic the private information in the screenshot (if any).

#### Straight Line and Arrow

![1|line](fig/line.jpg)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

1. Click ![line_normal](../common/line_normal.svg) on the toolbar which appears beside the screenshot area.
2. In the toolbar extension panel, select the weight and color of line. 
3. Click ![line](../common/line_normal.svg) or ![Arrow](../common/Arrow_normal.svg) to toggle between straight line and arrow.
4. Place the pointer on the screenshot area, and the pointer will be changed to ![line_mouse](../common/line_mouse.svg) or ![arrow_mouse](../common/arrow_mouse.svg).
5. Hold down the left mouse button, and drag the mouse to complete drawing.

#### Pencil

![1|pencil](fig/pencil.jpg)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

1. Click ![combineshape](../common/Combined_Shape.svg) on the toolbar which appears beside the screenshot area.
2. In the toolbar extension panel, select the weight and color of pencil. 
3. Place the pointer on the screenshot area, and the pointer will be changed to ![brush_red](../common/brush_red.svg).
4. Hold down the left mouse button, and drag the mouse to complete drawing.

### Modify Graphics

You can modify and move the drawn graphics in the screenshot.

![1|changetool](fig/changetool.jpg)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

#### Move Graphics

1. Place the pointer over the graphics outline, and the mouse will be changed to ![finger](fig/fingers.png).
2. Hold down the left mouse button, and drag the graphics to any place in the screenshot area.
3. Press ![up](../common/Up.svg) , ![down](../common/Down.svg) , ![left](../common/Left.svg) or ![Right](../common/Right.svg) on the keyboard to move the graphics vertically or horizontally.

#### Edit Graphics

1. Place the pointer over the outline of graphics and the mouse will be changed to ![finger](fig/fingers.png).
2. Left-click to enter the editing mode, and you can:
   - Press the **Delete** key on the keyboard to delete the graphics.
   - Place the pointer over the edit box, and the mouse will be changed to![mouse_arrow](../common/Mouse_Arrow.svg). Enlarge or reduce the graphic area by dragging the pointer.
   - Press **Ctrl** + ![Up](../common/Up.svg) , ![down](../common/Down.svg) , ![left](../common/Left.svg) or ![right](../common/Right.svg) to extend the graphics area vertically or horizontally.
   - Place the pointer over ![rotate](../common/icon_rotate.svg) in the edit box, and the pointer will be changed to ![rotate](../common/rotate_mouse.svg). Rotate the graphics by dragging the pointer.
3. Left-click outside the edit box to exit the editing mode.

### Add Text Annotations

Add text annotations to the screenshot in order to help others better understand.

![0|text](fig/text.jpg)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

1. Click ![text_normal](../common/text_normal.svg) on the toolbar which appears beside the screenshot area.
2. In the toolbar extension panel, select the font color and font size via the scroll bar. 
3. Place the pointer over the screenshot, and the mouse will be changed to ![text_mouse](../common/text_mouse.svg).
4. Click where you want to add an annotation, and a text box will appear.
5. Enter texts in the text box.

### Modify Text Annotations

You can modify and move the text annotations after they're entered.

#### Move Text Annotations

1. Place the pointer over the text, and the pointer will be changed to ![fingers](fig/fingers.png).
2. Hold down the left mouse button, and drag to move the text anywhere in the screenshot area.

#### Edit Text Annotations

1. Place the pointer over the text, and the pointer will be changed to ![fingers](fig/fingers.png).
2. Double-click to enter the text editing mode, and you can:
   - Press **Delete** on the keyboard to delete text annotations.
   - Modify the text in the text box.
3. Click outside the text box to exit editing mode.

### Pin Screenshots|pinscreenshots

With this feature, you are able to pin multiple screenshots on the system desktop for later comparison, integration, etc. conveniently.

Select the screenshot area and click the  ![icon](../common/pin.svg) icon on the toolbar to pin the screenshot on your desktop. You can perform the following operations:

- Move the screenshot by clicking and dragging it or pressing the ![icon](../common/Up.svg), ![icon](../common/Down.svg), ![icon](../common/Left.svg) or ![icon](../common/Right.svg) key on the keyboard.
- Scale up or down the screenshot by placing the mouse pointer on the screenshot and scrolling up or down the mouse wheel.    
- Click the ![icon](../common/screenshot_button.svg) icon on the toolbar to save it.



![0|option](fig/pin_pic.jpg)

### Take Screen Scrollshots|scrollshot

You are able to take long screen scrollshots both in and out of the screen with the **Scrollshot** feature.

Please enable the **Window Effect** feature in **Control Center > Personalization > General** before taking screen scrollshots.

1. Select the screenshot area and click the ![scrollshot](../common/scrollshot.svg) icon on the toolbar.
2. Place the cursor in the scrollshot area and you can start taking your scrollshots automatically, manually or alternatively.

   - Automatic scrolling: Click in the screenshot area and the cursor will scroll upwards automatically. The captured screenshots will be spliced into a complete long picture.  During the automatic scrolling process, click in the screenshot area or move the cursor out of the screenshot area to suspend the screenshot. Click in the screenshot area once again to resume.
   - Manual scrolling: Place the cursor in the screenshot area and scroll the mouse wheel upwards or downwards to take screenshot manually. Stop scrolling the mouse wheel to suspend the screenshot. Scroll it again to resume. 
3.   Click the  ![icon](../common/screenshot_button.svg) icon on the toolbar to save the screenshot.

**Attention**: Please pay attention to the the following conditions in the process of taking screen scrollshots:

- Make sure the screenshot area is not out of the scrolling area and try to avoid selecting the whole window, fullscreen, etc. 
- Make sure the screenshot area is not too small. The height suggested is no less than 50px. 
- Try to avoid multiple scrolling areas contained in the scrolling area.
- Try to avoid a great number of repetitive contents, such as blank areas, same colors or same sections of texts contained in the scrolling area.
- Try to avoid animations, video, watermarks, etc. or contents with non-solid background contained in the screenshot area.
- Try to avoid a horizontal offset in the scrolling process, such as sliding the scrollbar.
- Make sure the rolling speed is not too fast.
- Try to avoid switching windows during the scrolling process.

![scrollshot](fig/scrollshot.jpg)

### Extract Texts

You are able to recognize the texts in the screenshot area with the **Extract Text** feature.

1. Select the screenshot area and click the ![ocr](../common/ocr.svg) icon on the toolbar to enter the text extraction area.
2. You are able to edit the recognized texts by clicking the text area in the right column. Click the ![copy](../common/copy.svg) icon on the lower right corner to copy the texts recognized to the clipboard and click the ![copy](../common/download.svg) icon to save the texts recognized in TXT .

![ocr](fig/ocr.png)

### Delay Screenshots

You are able to capture the screenshot in a specific state or at specific time with the delay screenshot feature.

- Right-click the Screen Capture icon fixed in the Dock and select **Delay Screenshot**.
- Press  **Ctrl** + ![icon](../common/Print.svg) to start delay screenshot.
- Execute  “deepin-screen-recorder -d n”  in Terminal, among which n represents the delayed time in seconds.

### Save Screenshots

Save the screenshot for future use.

When the screenshot is saved successfully, you can see a prompt message in the upper area of the desktop. Click **View** to open the folder where the screenshot is located.

You can save the screenshot in the following ways after launching Screen Capture, and selecting the screenshot area:

- Double-click to save the screen capture.
- Click ![notes](../common/screenshot_button.svg) on the toolbar.
- Press **Ctrl + S** on the keyboard to save the screenshot.
- Right-click the screenshot, and select **Save** to save it.

   > ![notes](../common/notes.svg) Notes: The screenshot is saved to **Pictures > Screenshots** by default.

Click **Options** on the toolbar of the Screen Capture interface, and expand the drop-down list:

![0|option](fig/option.png)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

- Select **Clipboard** to save the screenshot to the clipboard.
- Click **Desktop** and the screenshot will be saved to the desktop.
- Click **Pictures**, and the screenshot will be saved to the pictures folder.
- Click **Folder**. Select the destination folder of the screenshot, and the screenshot will be saved to your specific folder directory. 
- Select **Show pointer**, and the pointer will be displayed in the screenshot area. Its position and pattern will also be saved in the picture.
- Select **PNG/JPG/BMP** to set the screenshot format.

## Record Screen

Under the recording mode, click the icons on the toolbar and you can perform recording with audio, video, keystroke, mouse clicks, etc. 
> ![notes](../common/notes.svg) Notes: The actual functions supported may differ according to the decoding method adopted.  Please refer to the interface.

![0|recorder_bar](fig/recorder_bar.png)

<table class="block1">
    <caption>Icon Description</caption>
    <tbody>
        <tr>
            <td><img src="../common/microphone_normal.svg" alt="microphone_normal" class="inline" /></td>
            <td>Microphone</td>
            <td><img src="../common/audio_frequency_normal.svg" alt="audio_frequency_normal" class="inline" /></td>
            <td>System Audio</td>
            <td><img src="../common/key_normal.svg" alt="key_normal" class="inline" /></td>
            <td>Show Keystroke</td>
            <td><img src="../common/webcam_normal.svg" alt="webcam_normal" class="inline" /></td>
            <td>Webcam On</td>
        </tr>
          <tr>
            <td><img src="../common/cursor.svg" alt="Show Pointer" class="inline" /></td>
            <td>Show Pointer</td>
            <td><img src="../common/touch.svg" alt="Show Click" class="inline" /></td>
            <td>Show Click</td>
            <td><img src="../common/close.svg" alt="close" class="inline" /></td>
            <td>Exit</td>
            <td></td>
            <td></td>
        </tr>
    </tbody>
</table>



### Set Recording Settings

On the toolbar of Screen Capture, you can set sound, keystroke, camera, etc. to get ready for video recording.

- Sound: Include microphone and built-in audio. You can select one of them or both.
- Keystroke: Click ![icon](../common/key_normal.svg)and the operation keystroke will be displayed during screen recording. Up to five recent operation keystrokes can be displayed at the same time. Click the icon again to enable **Hide Keystroke** and cancel keystroke display.
- Camera: Click![icon](../common/webcam_normal.svg) to start camera. Both the camera picture and window picture are recorded during screen recording. Drag the camera window outline to adjust the window size and position. Click the icon again to disable the camera. 

   >![attention](../common/attention.svg) Attention: First, check whether the device connected supports sound recording and camera functions. Otherwise you cannot perform relevant operations.

- Mouse:  Include **Show Pointer**, **Show Click** or both.
- Options: Select the **GIF**, **MP4** or **MKV** format and FPS in the Options dropdown list.

   > ![notes](../common/notes.svg) Notes: GIF is not supported on the MIPS architecture devices.

### Record a Screen

You can capture the screen activities in the following ways:

1. Launch screen recorder by **Ctrl + Alt + R**.
2. Select the recording area and make relevant settings as needed.
3. Click  ![icon](../common/recorder_button.svg) and recording will be started in 3 seconds with a flickering **Record** icon in the system tray.
4.  Press the **Ctrl + Alt + R** shortcuts on the keyboard, click the **Screen Capture** icon in the Dock or click the **Record** icon in the system tray to complete recording. 

The recorded video will be saved to the desktop automatically.

> ![notes](../common/notes.svg) Notes: 
> - Recording time will be displayed together with the **Record** icon when the Dock is at top or bottom of the desktop.
> - During video recording, if multiple monitors are connected, whether the multi-monitor display is set in copy mode or extended mode, only the current operation screen is recorded.

## View Help

Press ![F1](../common/F1.svg) on the keyboard to view the help manual after launching Screen Capture.

