/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SubstringAfter
extends CollatingFunctionFixed {
    @Override
    public boolean isSubstringMatchingFunction() {
        return true;
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        UnicodeString s0 = this.getUniStringArg(arguments[0]);
        UnicodeString s1 = this.getUniStringArg(arguments[1]);
        return new StringValue(SubstringAfter.substringAfter(s0, s1, (SubstringMatcher)this.getStringCollator()));
    }

    private static UnicodeString substringAfter(UnicodeString arg1, UnicodeString arg2, SubstringMatcher collator) {
        if (arg1 == null) {
            arg1 = EmptyUnicodeString.getInstance();
        }
        if (arg2 == null) {
            arg2 = EmptyUnicodeString.getInstance();
        }
        if (arg2.isEmpty()) {
            return arg1;
        }
        if (arg1.isEmpty()) {
            return EmptyUnicodeString.getInstance();
        }
        return collator.substringAfter(arg1, arg2);
    }

    @Override
    public String getCompilerName() {
        return "SubstringAfterCompiler";
    }
}

