/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.UnicodeNormalizer;
import net.sf.saxon.serialize.charcode.CharacterSet;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class CDATAFilter
extends ProxyReceiver {
    private UnicodeBuilder buffer = new UnicodeBuilder();
    private final Stack<NodeName> stack = new Stack();
    private Set<NodeName> nameList;
    private CharacterSet characterSet;

    public CDATAFilter(Receiver next) {
        super(next);
    }

    public void setOutputProperties(Properties details) throws XPathException {
        this.getCdataElements(details);
        this.characterSet = this.getConfiguration().getCharacterSetFactory().getCharacterSet(details);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.flush();
        this.stack.push(elemName);
        this.nextReceiver.startElement(elemName, type, attributes, namespaces, location, properties);
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        this.stack.pop();
        this.nextReceiver.endElement();
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        this.flush();
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (!ReceiverOption.contains(properties, 1)) {
            this.buffer.append(chars.toString());
        } else {
            this.flush();
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.flush();
        this.nextReceiver.comment(chars, locationId, properties);
    }

    private void flush() throws XPathException {
        boolean cdata;
        int end = (int)this.buffer.length();
        if (end == 0) {
            return;
        }
        if (this.stack.isEmpty()) {
            cdata = false;
        } else {
            NodeName top = this.stack.peek();
            cdata = this.isCDATA(top);
        }
        if (cdata) {
            if (this.getNextReceiver() instanceof UnicodeNormalizer) {
                UnicodeString normal = ((UnicodeNormalizer)this.getNextReceiver()).normalize(this.buffer.toUnicodeString(), true);
                this.buffer = new UnicodeBuilder();
                this.buffer.accept(normal);
                end = (int)this.buffer.length();
            }
            UnicodeString bufferContent = this.buffer.toUnicodeString();
            int start = 0;
            int k = 0;
            while (k < end) {
                int next = bufferContent.codePointAt(k);
                if (next != 0 && this.characterSet.inCharset(next)) {
                    ++k;
                    continue;
                }
                this.flushCDATA(bufferContent.substring(start, k));
                do {
                    this.nextReceiver.characters(bufferContent.substring(k, k + 1), Loc.NONE, 2);
                } while (++k < end && !this.characterSet.inCharset(next = bufferContent.codePointAt(k)));
                start = k;
            }
            this.flushCDATA(bufferContent.substring(start, end));
        } else {
            this.nextReceiver.characters(this.buffer.toUnicodeString(), Loc.NONE, 0);
        }
        this.buffer.clear();
    }

    private void flushCDATA(UnicodeString data) throws XPathException {
        if ((data = data.tidy()).isEmpty()) {
            return;
        }
        long len = data.length();
        int chprop = 3;
        Loc loc = Loc.NONE;
        this.nextReceiver.characters(BMPString.of("<![CDATA["), loc, 3);
        long doneto = 0L;
        for (long i = 0L; i < len - 2L; ++i) {
            if (data.codePointAt(i) == 93 && data.codePointAt(i + 1L) == 93 && data.codePointAt(i + 2L) == 62) {
                this.nextReceiver.characters(data.substring(doneto, i + 2L), loc, 3);
                this.nextReceiver.characters(BMPString.of("]]><![CDATA["), loc, 3);
                doneto = i + 2L;
                continue;
            }
            if (data.codePointAt(i) != 0) continue;
            this.nextReceiver.characters(data.substring(doneto, i), loc, 3);
            doneto = i + 1L;
        }
        this.nextReceiver.characters(data.substring(doneto, len), loc, 3);
        this.nextReceiver.characters(BMPString.of("]]>"), loc, 3);
    }

    protected boolean isCDATA(NodeName elementName) {
        return this.nameList.contains(elementName);
    }

    private void getCdataElements(Properties details) {
        boolean isHTML = "html".equals(details.getProperty("method"));
        boolean isHTML5 = isHTML && "5.0".equals(details.getProperty("version"));
        boolean isHTML4 = isHTML && !isHTML5;
        String cdata = details.getProperty("cdata-section-elements");
        if (cdata == null) {
            this.nameList = new HashSet<NodeName>(0);
            return;
        }
        this.nameList = new HashSet<NodeName>(10);
        StringTokenizer st2 = new StringTokenizer(cdata, " \t\n\r", false);
        while (st2.hasMoreTokens()) {
            String expandedName = st2.nextToken();
            StructuredQName sq = StructuredQName.fromClarkName(expandedName);
            String uri = sq.getURI();
            if (isHTML && (!isHTML4 || uri.equals("")) && (!isHTML5 || uri.equals("") || uri.equals("http://www.w3.org/1999/xhtml"))) continue;
            this.nameList.add(new FingerprintedQName("", sq.getURI(), sq.getLocalPart()));
        }
    }
}

