/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.Jackson;
import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestStepFinished;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class UsageFormatter
implements Plugin,
ConcurrentEventListener {
    final Map<String, List<StepContainer>> usageMap = new LinkedHashMap<String, List<StepContainer>>();
    private final UTF8OutputStreamWriter out;

    public UsageFormatter(OutputStream out) {
        this.out = new UTF8OutputStreamWriter(out);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
        publisher.registerHandlerFor(TestRunFinished.class, event -> this.finishReport());
    }

    void handleTestStepFinished(TestStepFinished event) {
        if (event.getTestStep() instanceof PickleStepTestStep && event.getResult().getStatus().is(Status.PASSED)) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.getTestStep();
            this.addUsageEntry(event.getResult(), testStep);
        }
    }

    void finishReport() {
        ArrayList<StepDefContainer> stepDefContainers = new ArrayList<StepDefContainer>();
        for (Map.Entry<String, List<StepContainer>> usageEntry : this.usageMap.entrySet()) {
            StepDefContainer stepDefContainer = new StepDefContainer(usageEntry.getKey(), this.createStepContainers(usageEntry.getValue()));
            stepDefContainers.add(stepDefContainer);
        }
        try {
            Jackson.OBJECT_MAPPER.writeValue(this.out, stepDefContainers);
            this.out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addUsageEntry(Result result, PickleStepTestStep testStep) {
        List stepContainers = this.usageMap.computeIfAbsent(testStep.getPattern(), k -> new ArrayList());
        StepContainer stepContainer = this.findOrCreateStepContainer(testStep.getStepText(), stepContainers);
        StepDuration stepDuration = new StepDuration(result.getDuration(), testStep.getUri() + ":" + testStep.getStepLine());
        stepContainer.getDurations().add(stepDuration);
    }

    private List<StepContainer> createStepContainers(List<StepContainer> stepContainers) {
        for (StepContainer stepContainer : stepContainers) {
            stepContainer.putAllAggregatedDurations(this.createAggregatedDurations(stepContainer));
        }
        return stepContainers;
    }

    private StepContainer findOrCreateStepContainer(String stepNameWithArgs, List<StepContainer> stepContainers) {
        for (StepContainer container : stepContainers) {
            if (!stepNameWithArgs.equals(container.getName())) continue;
            return container;
        }
        StepContainer stepContainer = new StepContainer(stepNameWithArgs);
        stepContainers.add(stepContainer);
        return stepContainer;
    }

    private Map<String, Double> createAggregatedDurations(StepContainer stepContainer) {
        LinkedHashMap<String, Double> aggregatedResults = new LinkedHashMap<String, Double>();
        List<Double> rawDurations = this.getRawDurations(stepContainer.getDurations());
        Double average = this.calculateAverage(rawDurations);
        aggregatedResults.put("average", average);
        Double median = this.calculateMedian(rawDurations);
        aggregatedResults.put("median", median);
        return aggregatedResults;
    }

    private List<Double> getRawDurations(List<StepDuration> stepDurations) {
        ArrayList<Double> rawDurations = new ArrayList<Double>();
        for (StepDuration stepDuration : stepDurations) {
            rawDurations.add(stepDuration.duration);
        }
        return rawDurations;
    }

    Double calculateAverage(List<Double> durationEntries) {
        double sum = 0.0;
        for (Double duration : durationEntries) {
            sum += duration.doubleValue();
        }
        if (sum == 0.0) {
            return 0.0;
        }
        return sum / (double)durationEntries.size();
    }

    Double calculateMedian(List<Double> durationEntries) {
        if (durationEntries.isEmpty()) {
            return 0.0;
        }
        Collections.sort(durationEntries);
        int middle = durationEntries.size() / 2;
        if (durationEntries.size() % 2 == 1) {
            return durationEntries.get(middle);
        }
        double total = durationEntries.get(middle - 1) + durationEntries.get(middle);
        return total / 2.0;
    }

    private static double durationToSeconds(Duration duration) {
        return (double)duration.toNanos() / (double)TimeUnit.SECONDS.toNanos(1L);
    }

    static class StepDuration {
        private final double duration;
        private final String location;

        StepDuration(Duration duration, String location) {
            this.duration = UsageFormatter.durationToSeconds(duration);
            this.location = location;
        }

        public double getDuration() {
            return this.duration;
        }

        public String getLocation() {
            return this.location;
        }
    }

    static class StepContainer {
        private final String name;
        private final Map<String, Double> aggregatedDurations = new HashMap<String, Double>();
        private final List<StepDuration> durations = new ArrayList<StepDuration>();

        StepContainer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void putAllAggregatedDurations(Map<String, Double> aggregatedDurations) {
            this.aggregatedDurations.putAll(aggregatedDurations);
        }

        public Map<String, Double> getAggregatedDurations() {
            return this.aggregatedDurations;
        }

        List<StepDuration> getDurations() {
            return this.durations;
        }
    }

    static class StepDefContainer {
        private final String source;
        private final List<StepContainer> steps;

        StepDefContainer(String source, List<StepContainer> steps) {
            this.source = source;
            this.steps = steps;
        }

        public String getSource() {
            return this.source;
        }

        public List<StepContainer> getSteps() {
            return this.steps;
        }
    }
}

