/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ClassLoaders;
import com.tngtech.archunit.base.Suppliers;
import com.tngtech.archunit.core.importer.resolvers.ClassResolver;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Splitter;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class ArchConfiguration {
    @Internal
    public static final String ARCHUNIT_PROPERTIES_RESOURCE_NAME = "archunit.properties";
    @Internal
    public static final String RESOLVE_MISSING_DEPENDENCIES_FROM_CLASS_PATH = "resolveMissingDependenciesFromClassPath";
    static final String CLASS_RESOLVER = "classResolver";
    static final String CLASS_RESOLVER_ARGS = "classResolver.args";
    @Internal
    public static final String ENABLE_MD5_IN_CLASS_SOURCES = "enableMd5InClassSources";
    private static final String EXTENSION_PREFIX = "extension";
    private static final Logger LOG = LoggerFactory.getLogger(ArchConfiguration.class);
    private static final Supplier<ArchConfiguration> INSTANCE = Suppliers.memoize(ArchConfiguration::new);
    private static final ThreadLocal<ArchConfiguration> threadLocalConfiguration = new ThreadLocal();
    private final String propertiesResourceName;
    private PropertiesOverwritableBySystemProperties properties;

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchConfiguration get() {
        return threadLocalConfiguration.get() != null ? threadLocalConfiguration.get() : INSTANCE.get();
    }

    private ArchConfiguration() {
        this(ARCHUNIT_PROPERTIES_RESOURCE_NAME);
    }

    private ArchConfiguration(String propertiesResourceName) {
        this(propertiesResourceName, ArchConfiguration.readProperties(propertiesResourceName));
    }

    private ArchConfiguration(String propertiesResourceName, PropertiesOverwritableBySystemProperties properties) {
        this.propertiesResourceName = propertiesResourceName;
        this.properties = properties;
    }

    private static PropertiesOverwritableBySystemProperties readProperties(String propertiesResourceName) {
        PropertiesOverwritableBySystemProperties properties = new PropertiesOverwritableBySystemProperties();
        URL archUnitPropertiesUrl = ClassLoaders.getCurrentClassLoader(ArchConfiguration.class).getResource(propertiesResourceName);
        if (archUnitPropertiesUrl == null) {
            LOG.debug("No configuration found in classpath at {} => Using default configuration", (Object)propertiesResourceName);
            return properties;
        }
        try (InputStream inputStream = archUnitPropertiesUrl.openStream();){
            LOG.info("Reading ArchUnit properties from {}", (Object)archUnitPropertiesUrl);
            properties.load(inputStream);
        }
        catch (IOException e) {
            LOG.warn("Error reading ArchUnit properties from " + archUnitPropertiesUrl, (Throwable)e);
        }
        return properties;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void reset() {
        this.properties = ArchConfiguration.readProperties(this.propertiesResourceName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean resolveMissingDependenciesFromClassPath() {
        return Boolean.parseBoolean(this.properties.getProperty(RESOLVE_MISSING_DEPENDENCIES_FROM_CLASS_PATH));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setResolveMissingDependenciesFromClassPath(boolean newValue) {
        this.properties.setProperty(RESOLVE_MISSING_DEPENDENCIES_FROM_CLASS_PATH, String.valueOf(newValue));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean md5InClassSourcesEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(ENABLE_MD5_IN_CLASS_SOURCES));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setMd5InClassSourcesEnabled(boolean enabled) {
        this.properties.setProperty(ENABLE_MD5_IN_CLASS_SOURCES, String.valueOf(enabled));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<String> getClassResolver() {
        return Optional.ofNullable(this.properties.getProperty(CLASS_RESOLVER));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setClassResolver(Class<? extends ClassResolver> classResolver) {
        this.properties.setProperty(CLASS_RESOLVER, classResolver.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void unsetClassResolver() {
        this.properties.remove(CLASS_RESOLVER);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<String> getClassResolverArguments() {
        return Splitter.on(",").trimResults().omitEmptyStrings().splitToList(this.properties.getProperty(CLASS_RESOLVER_ARGS, ""));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setClassResolverArguments(String ... args) {
        this.properties.setProperty(CLASS_RESOLVER_ARGS, Joiner.on(",").join(args));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setExtensionProperties(String extensionIdentifier, Properties properties) {
        String propertyPrefix = this.getFullExtensionPropertyPrefix(extensionIdentifier);
        this.clearPropertiesWithPrefix(propertyPrefix);
        for (String propertyName : properties.stringPropertyNames()) {
            String fullPropertyName = propertyPrefix + "." + propertyName;
            this.properties.setProperty(fullPropertyName, properties.getProperty(propertyName));
        }
    }

    private void clearPropertiesWithPrefix(String propertyPrefix) {
        for (String propertyToRemove : ArchConfiguration.filterNamesWithPrefix(this.properties.stringPropertyNames(), propertyPrefix)) {
            this.properties.remove(propertyToRemove);
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Properties getExtensionProperties(String extensionIdentifier) {
        String propertyPrefix = this.getFullExtensionPropertyPrefix(extensionIdentifier);
        return this.getSubProperties(propertyPrefix);
    }

    private String getFullExtensionPropertyPrefix(String extensionIdentifier) {
        return "extension." + extensionIdentifier;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ExtensionProperties configureExtension(String extensionIdentifier) {
        return new ExtensionProperties(extensionIdentifier);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Properties getSubProperties(String propertyPrefix) {
        return ArchConfiguration.getSubProperties(propertyPrefix, this.properties.getMergedProperties());
    }

    private static Properties getSubProperties(String propertyPrefix, Properties properties) {
        Properties result = new Properties();
        for (String key : ArchConfiguration.filterNamesWithPrefix(properties.stringPropertyNames(), propertyPrefix)) {
            String extensionPropertyKey = ArchConfiguration.removePrefix(key, propertyPrefix);
            result.put(extensionPropertyKey, properties.getProperty(key));
        }
        return result;
    }

    private static Iterable<String> filterNamesWithPrefix(Iterable<String> propertyNames, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        String fullPrefix = prefix + ".";
        for (String propertyName : propertyNames) {
            if (!propertyName.startsWith(fullPrefix)) continue;
            result.add(propertyName);
        }
        return result;
    }

    private static String removePrefix(String string, String prefix) {
        return string.substring(prefix.length() + 1);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getProperty(String propertyName) {
        return Preconditions.checkNotNull(this.properties.getProperty(propertyName), "Property '%s' is not configured", (Object)propertyName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getPropertyOrDefault(String propertyName, String defaultValue) {
        return this.properties.getProperty(propertyName, defaultValue);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static void withThreadLocalScope(Consumer<ArchConfiguration> doWithThreadLocalConfiguration) {
        ArchConfiguration.withThreadLocalScope((ArchConfiguration configuration) -> {
            doWithThreadLocalConfiguration.accept((ArchConfiguration)configuration);
            return null;
        });
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> T withThreadLocalScope(Function<ArchConfiguration, T> doWithThreadLocalConfiguration) {
        ArchConfiguration configuration = INSTANCE.get().copy();
        threadLocalConfiguration.set(configuration);
        try {
            T t = doWithThreadLocalConfiguration.apply(configuration);
            return t;
        }
        finally {
            threadLocalConfiguration.set(null);
        }
    }

    private ArchConfiguration copy() {
        return new ArchConfiguration(this.propertiesResourceName, this.properties.copy());
    }

    private static class PropertiesOverwritableBySystemProperties {
        private static final Properties PROPERTY_DEFAULTS = PropertiesOverwritableBySystemProperties.createProperties(ImmutableMap.of("resolveMissingDependenciesFromClassPath", Boolean.TRUE.toString(), "enableMd5InClassSources", Boolean.FALSE.toString()));
        private final Properties baseProperties;
        private final Properties overwrittenProperties;

        PropertiesOverwritableBySystemProperties() {
            this(PropertiesOverwritableBySystemProperties.createProperties(PROPERTY_DEFAULTS), new Properties());
        }

        PropertiesOverwritableBySystemProperties(Properties baseProperties, Properties overwrittenProperties) {
            this.baseProperties = baseProperties;
            this.overwrittenProperties = overwrittenProperties;
        }

        void load(InputStream inputStream) throws IOException {
            this.baseProperties.load(inputStream);
        }

        Set<String> stringPropertyNames() {
            return this.getMergedProperties().stringPropertyNames();
        }

        boolean containsKey(String propertyName) {
            return this.getMergedProperties().containsKey(propertyName);
        }

        String getProperty(String propertyName) {
            return this.getMergedProperties().getProperty(propertyName);
        }

        String getProperty(String propertyName, String defaultValue) {
            return this.getMergedProperties().getProperty(propertyName, defaultValue);
        }

        void setProperty(String propertyName, String value) {
            this.baseProperties.setProperty(propertyName, value);
        }

        void remove(String propertyName) {
            this.baseProperties.remove(propertyName);
        }

        Properties getMergedProperties() {
            Properties result = PropertiesOverwritableBySystemProperties.createProperties(this.baseProperties);
            Properties currentlyOverwritten = ArchConfiguration.getSubProperties("archunit", System.getProperties());
            result.putAll((Map<?, ?>)currentlyOverwritten);
            if (!this.overwrittenProperties.equals(currentlyOverwritten)) {
                PropertiesOverwritableBySystemProperties.replaceProperties(this.overwrittenProperties, currentlyOverwritten);
                if (!currentlyOverwritten.isEmpty()) {
                    LOG.info("Merging properties: The following properties have been overwritten by system properties: {}", (Object)currentlyOverwritten);
                }
            }
            return result;
        }

        private static void replaceProperties(Properties properties, Properties newProperties) {
            properties.clear();
            properties.putAll((Map<?, ?>)newProperties);
        }

        private static Properties createProperties(Map<?, ?> entries) {
            Properties result = new Properties();
            result.putAll(entries);
            return result;
        }

        PropertiesOverwritableBySystemProperties copy() {
            return new PropertiesOverwritableBySystemProperties(this.copy(this.baseProperties), this.copy(this.overwrittenProperties));
        }

        private Properties copy(Properties properties) {
            return (Properties)properties.clone();
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public final class ExtensionProperties {
        private final String extensionIdentifier;

        private ExtensionProperties(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ExtensionProperties setProperty(String key, Object value) {
            String fullKey = Joiner.on(".").join(ArchConfiguration.EXTENSION_PREFIX, this.extensionIdentifier, key);
            ArchConfiguration.this.properties.setProperty(fullKey, String.valueOf(value));
            return this;
        }
    }
}

