/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.util.ArrayList;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.presentations.mindmapmode.CollectionChangedEvent;
import org.freeplane.features.presentations.mindmapmode.NamedElementCollection;
import org.freeplane.features.presentations.mindmapmode.Presentation;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeEvent;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeListener;
import org.freeplane.features.presentations.mindmapmode.Slide;

public class PresentationState {
    private static final String USES_PRESENTATION_ZOOM_PROPERTY = "presentation.zoom";
    private static final Slide ALL_NODES = new Slide("All nodes");
    private NamedElementCollection<Presentation> presentations;
    private Presentation currentPresentation = null;
    private final ArrayList<PresentationStateChangeListener> presentationStateChangeListeners = new ArrayList();
    private Slide currentSlide;
    private boolean highlightsNodes;
    private boolean combinesAllPresentations = false;
    private float zoomFactor = 1.0f;

    protected void setCombinesAllPresentations(boolean combinesAllPresentations) {
        if (this.combinesAllPresentations != combinesAllPresentations) {
            this.combinesAllPresentations = combinesAllPresentations;
            if (this.presentations != null) {
                this.firePresentationStateChangedEvent(PresentationStateChangeEvent.EventType.COLLECTION_SIZE_CHANGED);
            }
        }
    }

    public void changePresentation(CollectionChangedEvent<Presentation> event) {
        Presentation presentation;
        this.presentations = event.collection;
        Presentation presentation2 = presentation = this.presentations != null ? this.presentations.getCurrentElement() : null;
        if (this.currentPresentation != presentation) {
            this.currentPresentation = presentation;
            if (presentation == null) {
                this.stopPresentation();
            }
            this.firePresentationStateChangedEvent(PresentationStateChangeEvent.EventType.SLIDE_CHANGED);
            if (this.isPresentationRunning()) {
                this.showPresentation();
            }
        }
    }

    public void showPresentation() {
        boolean isPresentationAlreadyRunning = this.isPresentationRunning();
        Slide newSlide = this.currentPresentation.slides.getCurrentElement();
        if (this.currentSlide != newSlide) {
            this.currentSlide = newSlide;
            this.firePresentationStateChangedEvent(isPresentationAlreadyRunning ? PresentationStateChangeEvent.EventType.SLIDE_CHANGED : PresentationStateChangeEvent.EventType.PLAYING_STATE_CHANGED);
        }
        if (this.currentSlide != null) {
            if (!isPresentationAlreadyRunning) {
                Controller controller = Controller.getCurrentController();
                this.zoomFactor = controller.getMapViewManager().getZoom();
                ALL_NODES.setRootNodeId(controller.getSelection().getSelectionRoot().getID());
                ALL_NODES.setZoom(this.zoomFactor);
            }
            this.currentSlide.apply(this.getPresentationZoomFactor());
        }
    }

    float getPresentationZoomFactor() {
        return this.usesMapZoom() ? this.zoomFactor : 1.0f;
    }

    boolean usesMapZoom() {
        return ResourceController.getResourceController().getBooleanProperty(USES_PRESENTATION_ZOOM_PROPERTY);
    }

    public void stopPresentation() {
        if (this.currentSlide != null) {
            this.currentSlide = null;
            this.firePresentationStateChangedEvent(PresentationStateChangeEvent.EventType.PLAYING_STATE_CHANGED);
            ALL_NODES.apply(1.0f);
            ALL_NODES.setRootNodeId(null);
            if (this.usesMapZoom()) {
                Controller.getCurrentController().getMapViewManager().setZoom(this.zoomFactor);
            }
            this.zoomFactor = 1.0f;
        }
    }

    public void addPresentationStateListener(PresentationStateChangeListener presentationStateChangeListener) {
        this.presentationStateChangeListeners.add(presentationStateChangeListener);
    }

    public void removePresentationStateListener(PresentationStateChangeListener presentationStateChangeListener) {
        this.presentationStateChangeListeners.remove(presentationStateChangeListener);
    }

    private void firePresentationStateChangedEvent(PresentationStateChangeEvent.EventType eventType) {
        for (PresentationStateChangeListener presentationStateChangeListener : this.presentationStateChangeListeners) {
            presentationStateChangeListener.onPresentationStateChange(eventType.of(this));
        }
    }

    public boolean isPresentationRunning() {
        return this.currentSlide != null;
    }

    public void showNextSlide() {
        int followingNotEmptyPresentationIndex;
        if (this.currentPresentationHasNextSlide()) {
            NamedElementCollection<Slide> slides = this.currentPresentation.slides;
            int currentElementIndex = slides.getCurrentElementIndex();
            slides.selectCurrentElement(currentElementIndex + 1);
        } else if (this.combinesAllPresentations() && (followingNotEmptyPresentationIndex = this.findFollowingNotEmptyPresentationIndex()) != -1) {
            this.presentations.selectCurrentElement(followingNotEmptyPresentationIndex);
            this.showFirstSlide();
        }
    }

    public void showLastSlide() {
        if (this.canShowNextSlide()) {
            NamedElementCollection<Slide> slides = this.currentPresentation.slides;
            slides.selectCurrentElement(slides.getSize() - 1);
        }
    }

    public void showPreviousSlide() {
        int previousNotEmptyPresentationIndex;
        if (this.currentPresentationHasPreviousSlide()) {
            NamedElementCollection<Slide> slides = this.currentPresentation.slides;
            int currentElementIndex = slides.getCurrentElementIndex();
            slides.selectCurrentElement(currentElementIndex - 1);
        } else if (this.combinesAllPresentations() && (previousNotEmptyPresentationIndex = this.findPreviousNotEmptyPresentationIndex()) != -1) {
            this.presentations.selectCurrentElement(previousNotEmptyPresentationIndex);
            this.showLastSlide();
        }
    }

    public void showFirstSlide() {
        if (this.canShowPreviousSlide()) {
            NamedElementCollection<Slide> slides = this.currentPresentation.slides;
            slides.selectCurrentElement(0);
        }
    }

    public boolean currentPresentationHasNextSlide() {
        if (this.currentPresentation == null) {
            return false;
        }
        NamedElementCollection<Slide> slides = this.currentPresentation.slides;
        return slides.getSize() != 0 && slides.getCurrentElementIndex() < slides.getSize() - 1;
    }

    public boolean canShowCurrentSlide() {
        if (this.currentPresentation == null) {
            return false;
        }
        NamedElementCollection<Slide> slides = this.currentPresentation.slides;
        return slides.getCurrentElement() != null;
    }

    public boolean currentPresentationHasPreviousSlide() {
        if (this.currentPresentation == null) {
            return false;
        }
        NamedElementCollection<Slide> slides = this.currentPresentation.slides;
        return slides.getCurrentElementIndex() > 0;
    }

    public boolean canShowPreviousSlide() {
        return this.currentPresentationHasPreviousSlide() || this.combinesAllPresentations() && this.anyPreviousPresentationIsNotEmpty();
    }

    private boolean anyPreviousPresentationIsNotEmpty() {
        return this.findPreviousNotEmptyPresentationIndex() != -1;
    }

    private boolean anyFollowingPresentationIsNotEmpty() {
        return this.findFollowingNotEmptyPresentationIndex() != -1;
    }

    private int findPreviousNotEmptyPresentationIndex() {
        if (this.currentPresentation == null) {
            return -1;
        }
        int currentPresentationIndex = this.presentations.getCurrentElementIndex();
        for (int i = currentPresentationIndex - 1; i >= 0; --i) {
            if (this.presentations.getElement((int)i).slides.getSize() <= 0) continue;
            return i;
        }
        return -1;
    }

    private int findFollowingNotEmptyPresentationIndex() {
        if (this.currentPresentation == null) {
            return -1;
        }
        int currentPresentationIndex = this.presentations.getCurrentElementIndex();
        for (int i = currentPresentationIndex + 1; i < this.presentations.getSize(); ++i) {
            if (this.presentations.getElement((int)i).slides.getSize() <= 0) continue;
            return i;
        }
        return -1;
    }

    private boolean combinesAllPresentations() {
        return this.combinesAllPresentations;
    }

    public boolean canShowFirstSlide() {
        return this.currentPresentationHasPreviousSlide();
    }

    public boolean canShowNextSlide() {
        return this.currentPresentationHasNextSlide() || this.combinesAllPresentations() && this.anyFollowingPresentationIsNotEmpty();
    }

    public boolean canShowLastSlide() {
        return this.currentPresentationHasNextSlide();
    }

    void changeSlide() {
        if (this.isPresentationRunning()) {
            this.showPresentation();
        } else {
            this.firePresentationStateChangedEvent(PresentationStateChangeEvent.EventType.SLIDE_CHANGED);
        }
    }

    public boolean shouldHighlightNodeContainedOnSlide(NodeModel node) {
        return !this.isPresentationRunning() && this.highlightsNodes && this.canShowCurrentSlide() && this.currentPresentation.slides.getCurrentElement().isNodeVisible(node);
    }

    public boolean isSlideRoot(NodeModel node) {
        NodeModel slideRootNode = this.currentPresentation.slides.getCurrentElement().getSlideRootNode();
        return slideRootNode == node;
    }

    public boolean shouldHighlightNodeFoldedOnSlide(NodeModel node) {
        return !this.isPresentationRunning() && this.highlightsNodes && this.canShowCurrentSlide() && this.currentPresentation.slides.getCurrentElement().isNodeFolded(node);
    }

    public boolean highlightsNodes() {
        return this.highlightsNodes;
    }

    public void setHighlightsNodes(boolean highlightsNodes) {
        if (this.highlightsNodes != highlightsNodes) {
            this.highlightsNodes = highlightsNodes;
            this.firePresentationStateChangedEvent(PresentationStateChangeEvent.EventType.SLIDE_CHANGED);
        }
    }

    public void restore() {
        if (this.isPresentationRunning()) {
            this.currentSlide.apply(this.zoomFactor);
        } else {
            ALL_NODES.apply(1.0f);
        }
    }

    NamedElementCollection<Presentation> getPresentations() {
        return this.presentations;
    }
}

