/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.Listeners;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;

class ServiceListenerState {
    protected static final String[] hashedKeys = new String[]{"objectClass".toLowerCase(), "service.id".toLowerCase(), "service.pid".toLowerCase()};
    private static final int OBJECTCLASS_IX = 0;
    private static final int SERVICE_ID_IX = 1;
    private static final int SERVICE_PID_IX = 2;
    protected static List<String> hashedKeysV;
    List<ServiceListenerEntry> complicatedListeners = new ArrayList<ServiceListenerEntry>();
    Map<Object, List<ServiceListenerEntry>>[] cache = new HashMap[hashedKeys.length];
    Set<ServiceListenerEntry> serviceSet = new HashSet<ServiceListenerEntry>();
    Listeners listeners;

    ServiceListenerState(Listeners listeners) {
        this.listeners = listeners;
        hashedKeysV = new ArrayList<String>();
        for (int i = 0; i < hashedKeys.length; ++i) {
            hashedKeysV.add(hashedKeys[i]);
            this.cache[i] = new HashMap<Object, List<ServiceListenerEntry>>();
        }
    }

    void clear() {
        hashedKeysV.clear();
        this.complicatedListeners.clear();
        for (int i = 0; i < hashedKeys.length; ++i) {
            this.cache[i].clear();
        }
        this.serviceSet.clear();
        this.listeners = null;
    }

    synchronized void add(BundleContextImpl bc, ServiceListener listener, String filter) throws InvalidSyntaxException {
        ServiceListenerEntry sle = new ServiceListenerEntry(bc, listener, filter);
        if (this.serviceSet.contains(sle)) {
            this.remove(bc, listener);
        }
        this.serviceSet.add(sle);
        this.listeners.fwCtx.serviceHooks.handleServiceListenerReg(sle);
        this.checkSimple(sle);
    }

    synchronized void remove(BundleContextImpl bc, ServiceListener listener) {
        Iterator<ServiceListenerEntry> it = this.serviceSet.iterator();
        while (it.hasNext()) {
            ServiceListenerEntry sle = it.next();
            if (sle.bc != bc || sle.listener != listener) continue;
            sle.setRemoved(true);
            this.listeners.fwCtx.serviceHooks.handleServiceListenerUnreg(sle);
            this.removeFromCache(sle);
            it.remove();
            break;
        }
    }

    private void removeFromCache(ServiceListenerEntry sle) {
        if (sle.local_cache != null) {
            for (int i = 0; i < hashedKeys.length; ++i) {
                Map<Object, List<ServiceListenerEntry>> keymap = this.cache[i];
                List<Object> l = sle.local_cache[i];
                if (l == null) continue;
                for (Object value : l) {
                    List<ServiceListenerEntry> sles = keymap.get(value);
                    if (sles == null) continue;
                    sles.remove(sles.indexOf(sle));
                    if (!sles.isEmpty()) continue;
                    keymap.remove(value);
                }
            }
        } else {
            this.complicatedListeners.remove(sle);
        }
    }

    synchronized void removeAll(BundleContextImpl bc) {
        Iterator<ServiceListenerEntry> it = this.serviceSet.iterator();
        while (it.hasNext()) {
            ServiceListenerEntry sle = it.next();
            if (sle.bc != bc) continue;
            this.removeFromCache(sle);
            it.remove();
        }
    }

    synchronized void hooksBundleStopped(BundleContextImpl bc) {
        ArrayList<ServiceListenerEntry> entries = new ArrayList<ServiceListenerEntry>();
        for (ServiceListenerEntry sle : this.serviceSet) {
            if (sle.bc != bc) continue;
            entries.add(sle);
        }
        this.listeners.fwCtx.serviceHooks.handleServiceListenerUnreg(Collections.unmodifiableList(entries));
    }

    public void checkSimple(ServiceListenerEntry sle) {
        if (sle.noFiltering || this.listeners.nocacheldap) {
            this.complicatedListeners.add(sle);
        } else {
            List[] local_cache = new List[hashedKeys.length];
            if (sle.ldap.isSimple(hashedKeysV, local_cache, false)) {
                sle.local_cache = local_cache;
                for (int i = 0; i < hashedKeys.length; ++i) {
                    if (local_cache[i] == null) continue;
                    for (Object value : local_cache[i]) {
                        List<ServiceListenerEntry> sles = this.cache[i].get(value);
                        if (sles == null) {
                            sles = new ArrayList<ServiceListenerEntry>();
                            this.cache[i].put(value, sles);
                        }
                        sles.add(sle);
                    }
                }
            } else {
                if (this.listeners.fwCtx.debug.ldap) {
                    this.listeners.fwCtx.debug.println("Too complicated filter: " + sle.ldap);
                }
                this.complicatedListeners.add(sle);
            }
        }
    }

    synchronized Set<ServiceListenerEntry> getMatchingListeners(ServiceReferenceImpl<?> sr) {
        HashSet<ServiceListenerEntry> set;
        block7: {
            Object service_pid;
            block9: {
                String[] sa;
                block8: {
                    String[] c;
                    set = new HashSet<ServiceListenerEntry>();
                    int n = 0;
                    for (ServiceListenerEntry sle : this.complicatedListeners) {
                        if (sle.noFiltering || sle.ldap.evaluate(sr.getProperties(), false)) {
                            set.add(sle);
                        }
                        ++n;
                    }
                    if (this.listeners.fwCtx.debug.ldap) {
                        this.listeners.fwCtx.debug.println("Added " + set.size() + " out of " + n + " listeners with complicated filters");
                    }
                    for (String element : c = (String[])sr.getProperty("objectClass")) {
                        this.addToSet(set, 0, element);
                    }
                    Long service_id = (Long)sr.getProperty("service.id");
                    if (service_id != null) {
                        this.addToSet(set, 1, service_id.toString());
                    }
                    if ((service_pid = sr.getProperty("service.pid")) == null) break block7;
                    if (!(service_pid instanceof String)) break block8;
                    this.addToSet(set, 2, service_pid);
                    break block7;
                }
                if (!(service_pid instanceof String[])) break block9;
                for (String element : sa = (String[])service_pid) {
                    this.addToSet(set, 2, element);
                }
                break block7;
            }
            if (!(service_pid instanceof Collection)) break block7;
            Collection pids = (Collection)service_pid;
            for (String pid : pids) {
                this.addToSet(set, 2, pid);
            }
        }
        return set;
    }

    private void addToSet(Set<ServiceListenerEntry> set, int cache_ix, Object val) {
        List<ServiceListenerEntry> l = this.cache[cache_ix].get(val);
        if (l != null) {
            if (this.listeners.fwCtx.debug.ldap) {
                this.listeners.fwCtx.debug.println(hashedKeys[cache_ix] + " matches " + l.size());
            }
            set.addAll(l);
        } else if (this.listeners.fwCtx.debug.ldap) {
            this.listeners.fwCtx.debug.println(hashedKeys[cache_ix] + " matches none");
        }
    }
}

