/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.configurator;

import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.View;
import org.freeplane.core.util.HtmlUtils;

class WrappingTableCellRenderer
extends DefaultTableCellRenderer {
    WrappingTableCellRenderer() {
    }

    @Override
    public WrappingTableCellRenderer getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String html = HtmlUtils.plainToHTML((String)String.valueOf(value));
        super.getTableCellRendererComponent(table, html, isSelected, hasFocus, row, column);
        View view = (View)this.getClientProperty("html");
        Insets insets = this.getInsets();
        int columnWidth = table.getTableHeader().getColumnModel().getColumn(column).getWidth();
        view.setSize(columnWidth - insets.left - insets.right, 0.0f);
        int height = (int)view.getPreferredSpan(1) + insets.bottom + insets.top;
        if (table.getRowHeight(row) != height) {
            table.setRowHeight(row, height);
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        View view = (View)this.getClientProperty("html");
        Insets insets = this.getInsets();
        view.setSize(this.getWidth() - insets.left - insets.right, this.getHeight() - insets.bottom - insets.top);
        super.paint(g);
    }
}

