/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FocusManager;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.WindowDecoder;
import net.infonode.docking.drop.ChildDropInfo;
import net.infonode.docking.drop.InteriorDropInfo;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WindowAncestors;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.model.FloatingWindowItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.properties.DockingWindowProperties;
import net.infonode.docking.properties.FloatingWindowProperties;
import net.infonode.docking.properties.SplitWindowProperties;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.layout.StretchLayout;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.util.Direction;

public class FloatingWindow
extends DockingWindow {
    private DockingWindow window;
    private Window dialog;
    private JPanel dragPanel = new SimplePanel();
    private ShapedPanel shapedPanel;
    private DockingWindow maximizedWindow;
    private Runnable titleUpdater;
    private AWTEventListener awtMouseEventListener;
    private PropertyMapTreeListener propertiesListener = new PropertyMapTreeListener(){

        @Override
        public void propertyValuesChanged(Map changes) {
            FloatingWindow.this.updateFloatingWindow(changes);
        }
    };

    FloatingWindow(RootWindow rootWindow) {
        super(new FloatingWindowItem());
        this.getFloatingWindowProperties().addSuperObject(rootWindow.getRootWindowProperties().getFloatingWindowProperties());
        this.setLayout(new StretchLayout(true, true));
        this.shapedPanel = new ShapedPanel();
        this.setComponent(this.shapedPanel);
        Component c = rootWindow.getTopLevelComponent();
        this.dialog = this.getFloatingWindowProperties().getUseFrame() ? new JFrame() : (c instanceof Frame ? new JDialog((Frame)c) : new JDialog((Dialog)c));
        ((RootPaneContainer)((Object)this.dialog)).getContentPane().add((Component)this, "Center");
        if (this.dialog instanceof JDialog) {
            ((JDialog)this.dialog).setDefaultCloseOperation(0);
        } else {
            ((JFrame)this.dialog).setDefaultCloseOperation(0);
        }
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    if (FloatingWindow.this.getWindowProperties().getCloseEnabled()) {
                        FloatingWindow.this.closeWithAbort();
                    }
                }
                catch (OperationAbortedException operationAbortedException) {
                    // empty catch block
                }
            }
        });
        JRootPane rp = ((RootPaneContainer)((Object)this.dialog)).getRootPane();
        rp.getLayeredPane().add(this.dragPanel);
        rp.getLayeredPane().setLayer(this.dragPanel, JLayeredPane.DRAG_LAYER);
        this.dragPanel.setVisible(false);
        this.dragPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FloatingWindow.this.getRootWindow().setCurrentDragRootPane(FloatingWindow.this.getRootPane());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!FloatingWindow.this.dragPanel.contains(e.getPoint()) && FloatingWindow.this.getRootWindow().getCurrentDragRootPane() == FloatingWindow.this.getRootPane()) {
                    FloatingWindow.this.getRootWindow().setCurrentDragRootPane(null);
                }
            }
        });
        if (rootWindow.isHeavyweightSupported()) {
            try {
                this.awtMouseEventListener = new AWTEventListener(){

                    @Override
                    public void eventDispatched(AWTEvent event) {
                        Component c;
                        if (event.getID() == 504 && ComponentUtil.getTopLevelAncestor(c = (Component)event.getSource()) == FloatingWindow.this.dialog) {
                            FloatingWindow.this.getRootWindow().setCurrentDragRootPane(FloatingWindow.this.getRootPane());
                        }
                    }
                };
                Toolkit.getDefaultToolkit().addAWTEventListener(this.awtMouseEventListener, 16L);
            }
            catch (SecurityException e) {
                this.awtMouseEventListener = null;
            }
        }
        PropertyMapWeakListenerManager.addWeakTreeListener(this.getFloatingWindowProperties().getMap(), this.propertiesListener);
        this.updateFloatingWindow(null);
    }

    FloatingWindow(RootWindow rootWindow, DockingWindow window, Point p, Dimension internalSize) {
        this(rootWindow);
        this.setWindow(window);
        this.setInternalSize(internalSize);
        this.dialog.setLocation(p.x, p.y);
    }

    public void setWindow(DockingWindow newWindow) {
        if (this.window == newWindow) {
            return;
        }
        if (this.window == null) {
            WindowAncestors ancestors = newWindow.storeAncestors();
            DockingWindow actualWindow = this.addWindow(newWindow);
            this.doReplace(null, actualWindow);
            newWindow.notifyListeners(ancestors);
        } else if (newWindow == null) {
            this.removeChildWindow(this.window);
            this.window = null;
        } else {
            this.replaceChildWindow(this.window, newWindow);
        }
    }

    public DockingWindow getWindow() {
        return this.window;
    }

    public void setMaximizedWindow(DockingWindow window) {
        if (window == this.maximizedWindow) {
            return;
        }
        if (window instanceof FloatingWindow || window != null && DockingUtil.getFloatingWindowFor(window) != this) {
            return;
        }
        this.internalSetMaximizedWindow(window);
    }

    public DockingWindow getMaximizedWindow() {
        return this.maximizedWindow;
    }

    public FloatingWindowProperties getFloatingWindowProperties() {
        return ((FloatingWindowItem)this.getWindowItem()).getFloatingWindowProperties();
    }

    @Override
    public DockingWindowProperties getWindowProperties() {
        return super.getWindowProperties();
    }

    @Override
    public void minimize() {
    }

    @Override
    public void minimize(Direction direction) {
    }

    @Override
    public boolean isDockable() {
        return false;
    }

    @Override
    public boolean isMaximizable() {
        return false;
    }

    @Override
    public boolean isMinimizable() {
        return false;
    }

    @Override
    public boolean isRestorable() {
        return false;
    }

    @Override
    public boolean isUndockable() {
        return false;
    }

    @Override
    public void close() {
        PropertyMapWeakListenerManager.removeWeakTreeListener(this.getFloatingWindowProperties().getMap(), this.propertiesListener);
        RootWindow rw = this.getRootWindow();
        super.close();
        this.dialog.dispose();
        if (rw != null) {
            rw.removeFloatingWindow(this);
        }
        try {
            if (this.awtMouseEventListener != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtMouseEventListener);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public Icon getIcon() {
        return this.window == null ? null : this.window.getIcon();
    }

    @Override
    public DockingWindow getChildWindow(int index) {
        return this.window;
    }

    @Override
    public int getChildWindowCount() {
        return this.window == null ? 0 : 1;
    }

    @Override
    public boolean isUndocked() {
        return true;
    }

    void startDrag() {
        JRootPane rp = ((RootPaneContainer)((Object)this.dialog)).getRootPane();
        this.dragPanel.setBounds(0, 0, rp.getWidth(), rp.getHeight());
        this.dragPanel.setVisible(true);
    }

    void stopDrag() {
        this.dragPanel.setVisible(false);
    }

    JPanel getDragPanel() {
        return this.dragPanel;
    }

    boolean windowContainsPoint(Point p) {
        return this.getTopLevelAncestor().contains(SwingUtilities.convertPoint(this, p, this.getTopLevelAncestor()));
    }

    private void internalSetMaximizedWindow(DockingWindow window) {
        if (window == this.maximizedWindow) {
            return;
        }
        DockingWindow focusWindow = null;
        if (this.maximizedWindow != null) {
            DockingWindow oldMaximized = this.maximizedWindow;
            this.maximizedWindow = null;
            if (oldMaximized.getWindowParent() != null) {
                oldMaximized.getWindowParent().restoreWindowComponent(oldMaximized);
            }
            if (oldMaximized != this.window) {
                this.shapedPanel.remove(oldMaximized);
            }
            focusWindow = oldMaximized;
            this.fireWindowRestored(oldMaximized);
        }
        this.maximizedWindow = window;
        if (this.maximizedWindow != null) {
            if (this.maximizedWindow.getWindowParent() != null) {
                this.maximizedWindow.getWindowParent().removeWindowComponent(this.maximizedWindow);
            }
            if (this.maximizedWindow != this.window) {
                this.shapedPanel.add(this.maximizedWindow);
                if (this.window != null) {
                    this.window.setVisible(false);
                }
            }
            this.maximizedWindow.setVisible(true);
            focusWindow = this.maximizedWindow;
            this.fireWindowMaximized(this.maximizedWindow);
        } else if (this.window != null) {
            this.window.setVisible(true);
        }
        if (focusWindow != null) {
            FocusManager.focusWindow(focusWindow);
        }
    }

    @Override
    protected void doReplace(DockingWindow oldWindow, DockingWindow newWindow) {
        if (oldWindow == this.window) {
            if (this.window != null) {
                this.shapedPanel.remove(this.window);
                this.window.setVisible(true);
            }
            this.window = newWindow;
            if (this.window != null) {
                if (this.maximizedWindow != null) {
                    this.window.setVisible(false);
                }
                this.shapedPanel.add(this.window);
                this.doUpdateTitle();
                this.shapedPanel.revalidate();
            }
        }
        this.updateButtonVisibility();
    }

    @Override
    protected void doRemoveWindow(DockingWindow window) {
        if (window != null) {
            this.shapedPanel.remove(window);
            this.window.setVisible(true);
            this.window = null;
            this.shapedPanel.repaint();
        }
    }

    @Override
    protected void afterWindowRemoved(DockingWindow window) {
        if (this.getFloatingWindowProperties().getAutoCloseEnabled()) {
            this.close();
        }
    }

    private void doUpdateTitle() {
        if (this.titleUpdater == null) {
            this.titleUpdater = new Runnable(){

                @Override
                public void run() {
                    if (FloatingWindow.this.dialog != null) {
                        if (FloatingWindow.this.dialog instanceof Dialog) {
                            ((Dialog)FloatingWindow.this.dialog).setTitle(FloatingWindow.this.window == null ? "" : FloatingWindow.this.window.getTitle());
                        } else {
                            ((Frame)FloatingWindow.this.dialog).setTitle(FloatingWindow.this.window == null ? "" : FloatingWindow.this.window.getTitle());
                        }
                    }
                    FloatingWindow.this.titleUpdater = null;
                }
            };
            SwingUtilities.invokeLater(this.titleUpdater);
        }
    }

    @Override
    protected boolean acceptsSplitWith(DockingWindow window) {
        return false;
    }

    @Override
    protected DropAction doAcceptDrop(Point p, DockingWindow window) {
        Point p2;
        DockingWindow dropWindow;
        DockingWindow dockingWindow = dropWindow = this.maximizedWindow != null ? this.maximizedWindow : this.window;
        if (dropWindow != null && dropWindow.contains(p2 = SwingUtilities.convertPoint(this, p, dropWindow))) {
            return this.getChildDropFilter().acceptDrop(new ChildDropInfo(window, this, p, dropWindow)) ? dropWindow.acceptDrop(p2, window) : null;
        }
        return super.doAcceptDrop(p, window);
    }

    @Override
    protected DropAction acceptInteriorDrop(Point p, DockingWindow window) {
        if (this.window != null) {
            return null;
        }
        this.getRootWindow().setDragRectangle(null);
        if (this.getInteriorDropFilter().acceptDrop(new InteriorDropInfo(window, this, p))) {
            return new DropAction(){

                @Override
                public void execute(DockingWindow window, MouseEvent mouseEvent) {
                    FloatingWindow.this.setWindow(window);
                }
            };
        }
        return null;
    }

    @Override
    protected void update() {
    }

    @Override
    void removeWindowComponent(DockingWindow window) {
    }

    @Override
    void restoreWindowComponent(DockingWindow window) {
    }

    @Override
    protected void showChildWindow(DockingWindow window) {
        if (this.maximizedWindow != null && window == this.window) {
            this.setMaximizedWindow(null);
        }
        super.showChildWindow(window);
    }

    @Override
    protected PropertyMap getPropertyObject() {
        return new SplitWindowProperties().getMap();
    }

    @Override
    protected PropertyMap createPropertyObject() {
        return new SplitWindowProperties().getMap();
    }

    private void updateFloatingWindow(Map map) {
        ShapedPanelProperties shapedProperties;
        FloatingWindowProperties properties = this.getFloatingWindowProperties();
        ComponentProperties componentProperties = map == null || map.get(properties.getComponentProperties().getMap()) != null ? properties.getComponentProperties() : null;
        ShapedPanelProperties shapedPanelProperties = shapedProperties = map == null || map.get(properties.getShapedPanelProperties().getMap()) != null ? properties.getShapedPanelProperties() : null;
        if (componentProperties != null) {
            componentProperties.applyTo(this.shapedPanel);
        }
        if (shapedProperties != null) {
            InternalPropertiesUtil.applyTo(shapedProperties, this.shapedPanel);
        }
    }

    @Override
    protected void fireTitleChanged() {
        super.fireTitleChanged();
        this.doUpdateTitle();
    }

    private void setInternalSize(Dimension size) {
        ((RootPaneContainer)((Object)this.dialog)).getRootPane().setPreferredSize(size);
        this.dialog.pack();
        ((RootPaneContainer)((Object)this.dialog)).getRootPane().setPreferredSize(null);
    }

    protected DockingWindow read(ObjectInputStream in, ReadContext context, ViewReader viewReader) throws IOException {
        this.dialog.setSize(new Dimension(in.readInt(), in.readInt()));
        this.dialog.setLocation(in.readInt(), in.readInt());
        this.dialog.setVisible(in.readBoolean());
        this.getWindowItem().readSettings(in, context);
        if (in.readBoolean()) {
            this.setWindow(WindowDecoder.decodeWindow(in, context, viewReader));
        }
        return this;
    }

    @Override
    protected void write(ObjectOutputStream out, WriteContext context, ViewWriter viewWriter) throws IOException {
        out.writeInt(this.dialog.getWidth());
        out.writeInt(this.dialog.getHeight());
        out.writeInt(this.dialog.getX());
        out.writeInt(this.dialog.getY());
        out.writeBoolean(this.dialog.isVisible());
        this.getWindowItem().writeSettings(out, context);
        out.writeBoolean(this.window != null);
        if (this.window != null) {
            this.window.write(out, context, viewWriter);
        }
    }
}

