/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class HeavyWeightContainer
extends Panel {
    private Image bufferImage;
    private boolean doubleBuffer = false;

    public HeavyWeightContainer(Component c) {
        this(c, false);
    }

    public HeavyWeightContainer(Component c, boolean doubleBuffer) {
        super(new BorderLayout());
        this.doubleBuffer = doubleBuffer;
        this.add(c, "Center");
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.bufferImage = null;
    }

    @Override
    public void update(Graphics g) {
        if (this.doubleBuffer) {
            this.paint(g);
        } else {
            super.update(g);
        }
    }

    @Override
    public boolean isDoubleBuffered() {
        return this.doubleBuffer;
    }

    @Override
    public void paint(Graphics g) {
        if (this.doubleBuffer) {
            if (this.bufferImage == null) {
                this.bufferImage = this.createImage(this.getWidth(), this.getHeight());
            }
            Graphics g2 = this.bufferImage.getGraphics();
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paint(g2);
            g.drawImage(this.bufferImage, 0, 0, null);
            g2.dispose();
        } else {
            super.paint(g);
        }
    }
}

