/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.draggable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.EventUtil;
import net.infonode.gui.draggable.DraggableComponentEvent;
import net.infonode.gui.draggable.DraggableComponentListener;

public class DraggableComponent {
    private final JComponent component;
    private JComponent[] eventComponents;
    private boolean reorderEnabled = true;
    private boolean enabled = true;
    private boolean reorderRestoreOnDrag;
    private boolean detectOuterAreaAsLine = true;
    private boolean enableInsideDrag;
    private boolean selectOnMousePress;
    private boolean mousePressed;
    private boolean dragEventFired;
    private boolean dragStarted;
    private boolean ignoreAddNotify = false;
    private int dragIndex;
    private int dragFromIndex;
    private int abortDragKeyCode = 27;
    private ArrayList layoutOrderList;
    private ArrayList listeners;
    private JComponent outerParentArea;
    private final KeyEventDispatcher abortDragKeyDispatcher = new KeyEventDispatcher(){

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (DraggableComponent.this.mousePressed && e.getKeyCode() == DraggableComponent.this.abortDragKeyCode) {
                if (e.getID() == 401) {
                    DraggableComponent.this.dragCompleted(null);
                }
                return true;
            }
            return false;
        }
    };
    private final MouseInputListener mouseInputListener = new MouseInputAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            DraggableComponent.this.pressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DraggableComponent.this.released(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            DraggableComponent.this.dragged(e);
        }
    };

    public DraggableComponent(JComponent component) {
        this(component, component);
    }

    public DraggableComponent(JComponent component, JComponent eventComponent) {
        this(component, new JComponent[]{eventComponent});
    }

    public DraggableComponent(JComponent component, JComponent[] eventComponents) {
        this.component = component;
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DraggableComponent.this.fireChangedEvent(-1);
            }
        });
        this.setEventComponents(eventComponents);
    }

    public void addListener(DraggableComponentListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(l);
    }

    public void removeListener(DraggableComponentListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    public JComponent[] getEventComponents() {
        return this.eventComponents;
    }

    public void setEventComponents(JComponent[] eventComponents) {
        int i;
        if (this.eventComponents != null) {
            i = 0;
            while (i < this.eventComponents.length) {
                this.eventComponents[i].removeMouseListener(this.mouseInputListener);
                this.eventComponents[i].removeMouseMotionListener(this.mouseInputListener);
                ++i;
            }
        }
        this.eventComponents = eventComponents;
        if (this.eventComponents != null) {
            i = 0;
            while (i < this.eventComponents.length) {
                this.eventComponents[i].addMouseListener(this.mouseInputListener);
                this.eventComponents[i].addMouseMotionListener(this.mouseInputListener);
                ++i;
            }
        }
    }

    public int getAbortDragKeyCode() {
        return this.abortDragKeyCode;
    }

    public void setAbortDragKeyCode(int abortDragKeyCode) {
        this.abortDragKeyCode = abortDragKeyCode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.fireChangedEvent(enabled ? 3 : 4);
        }
    }

    public boolean isReorderEnabled() {
        return this.reorderEnabled;
    }

    public void setReorderEnabled(boolean reorderEnabled) {
        this.reorderEnabled = reorderEnabled;
    }

    public boolean isReorderRestoreOnDrag() {
        return this.reorderRestoreOnDrag;
    }

    public void setReorderRestoreOnDrag(boolean reorderRestoreOnDrag) {
        this.reorderRestoreOnDrag = reorderRestoreOnDrag;
    }

    public boolean isDetectOuterAreaAsLine() {
        return this.detectOuterAreaAsLine;
    }

    public void setDetectOuterAreaAsLine(boolean detectOuterAreaAsLine) {
        this.detectOuterAreaAsLine = detectOuterAreaAsLine;
    }

    public boolean isEnableInsideDrag() {
        return this.enableInsideDrag;
    }

    public void setEnableInsideDrag(boolean enableInsideDrag) {
        this.enableInsideDrag = enableInsideDrag;
    }

    public boolean isSelectOnMousePress() {
        return this.selectOnMousePress;
    }

    public void setSelectOnMousePress(boolean selectOnMousePress) {
        this.selectOnMousePress = selectOnMousePress;
    }

    public void drag(Point p) {
        if (this.enabled) {
            this.dragFromIndex = this.dragIndex = this.getComponentIndex(this.component);
            this.doDrag(p);
        }
    }

    public void abortDrag() {
        if (this.dragStarted) {
            this.dragCompleted(null);
        }
    }

    public void setLayoutOrderList(ArrayList layoutOrderList) {
        this.layoutOrderList = layoutOrderList;
    }

    public void select() {
        if (this.enabled) {
            this.fireSelectedEvent();
        }
    }

    public void setOuterParentArea(JComponent outerParentArea) {
        this.outerParentArea = outerParentArea;
    }

    public boolean isIgnoreAddNotify() {
        return this.ignoreAddNotify;
    }

    public void setIgnoreAddNotify(boolean ignoreAddNotify) {
        this.ignoreAddNotify = ignoreAddNotify;
    }

    private void pressed(MouseEvent e) {
        if (this.enabled && e.getButton() == 1) {
            if (this.selectOnMousePress && !e.isShiftDown()) {
                this.select();
            }
            this.dragStarted = false;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.abortDragKeyDispatcher);
            this.mousePressed = true;
            this.dragFromIndex = this.dragIndex = this.getComponentIndex(this.component);
            this.fireChangedEvent(1);
        }
    }

    private void released(MouseEvent e) {
        if (this.mousePressed) {
            if (e.getButton() == 1) {
                this.dragCompleted(e);
            } else {
                this.dragCompleted(null);
                e.consume();
            }
        }
    }

    private void dragged(MouseEvent e) {
        if (this.enabled && this.mousePressed) {
            Point p = SwingUtilities.convertPoint((JComponent)e.getSource(), e.getPoint(), this.component);
            if (this.dragStarted || this.enableInsideDrag || !this.component.contains(p)) {
                if (this.reorderEnabled) {
                    this.doDrag(p);
                } else {
                    this.dragStarted = true;
                }
                this.fireDraggedEvent(EventUtil.convert(e, this.component, p));
            }
        }
    }

    private void dragCompleted(MouseEvent e) {
        this.mousePressed = false;
        this.dragStarted = false;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.abortDragKeyDispatcher);
        if (e == null) {
            this.restoreComponentOrder();
            this.fireNotDroppedEvent();
        } else if (!this.checkParentContains(SwingUtilities.convertPoint((JComponent)e.getSource(), e.getPoint(), this.component.getParent()))) {
            this.restoreComponentOrder();
            this.fireDroppedEvent(EventUtil.convert(e, this.component));
        } else {
            this.fireDroppedEvent(EventUtil.convert(e, this.component));
            if (!this.selectOnMousePress && !e.isShiftDown()) {
                this.fireSelectedEvent();
            }
        }
        this.fireChangedEvent(2);
    }

    private void updateParent() {
        if (this.component.getParent() != null) {
            ComponentUtil.validate(this.component.getParent());
        }
    }

    private void doDrag(Point p) {
        this.dragStarted = true;
        JComponent parent = (JComponent)this.component.getParent();
        if (parent.getComponentCount() == 1) {
            return;
        }
        Point p2 = SwingUtilities.convertPoint(this.component, p, parent);
        int toIndex = this.getMoveComponentIndex(p2);
        if (toIndex != -1) {
            int toDimension;
            int toPos;
            int fromDimension;
            toIndex = Math.min(toIndex, parent.getComponentCount() - 1);
            JComponent fromComponent = this.getComponent(parent, this.dragIndex);
            if (this.isVerticalDrag()) {
                fromDimension = ((Component)fromComponent).getHeight();
                toPos = (int)SwingUtilities.convertPoint(parent, p2, this.getComponent(parent, toIndex)).getY();
                toDimension = this.getComponent(parent, toIndex).getHeight();
            } else {
                fromDimension = ((Component)fromComponent).getWidth();
                toPos = (int)SwingUtilities.convertPoint(parent, p2, this.getComponent(parent, toIndex)).getX();
                toDimension = this.getComponent(parent, toIndex).getWidth();
            }
            if (toIndex > this.dragIndex && toDimension - toPos > fromDimension || (this.dragIndex == -1 || toIndex < this.dragIndex) && toPos > fromDimension) {
                return;
            }
            if (this.dragIndex != -1 && this.dragIndex != toIndex) {
                this.removeComponent(parent, fromComponent, this.dragIndex);
                this.addComponent(parent, fromComponent, toIndex);
                this.fireChangedEvent(0);
            }
        }
        if (toIndex < 0) {
            this.restoreComponentOrder();
        } else {
            this.dragIndex = toIndex;
        }
    }

    private boolean isVerticalDrag() {
        JComponent parent = (JComponent)this.component.getParent();
        if (parent.getComponentCount() > 1) {
            return this.getComponent(parent, 0).getY() < this.getComponent(parent, 1).getY();
        }
        return false;
    }

    private boolean checkParentContains(Point p) {
        if (this.outerParentArea == null) {
            return this.component.getParent().contains(p);
        }
        Point p2 = SwingUtilities.convertPoint(this.component.getParent(), p, this.outerParentArea);
        if (this.detectOuterAreaAsLine) {
            Insets i = new Insets(0, 0, 0, 0);
            return this.component.getParent().contains(p) || this.outerParentArea.contains(p2) && !(this.isVerticalDrag() ? !(p2.getX() >= (double)i.left) || !(p2.getX() < (double)(this.outerParentArea.getWidth() - i.right)) : !(p2.getY() >= (double)i.top) || !(p2.getY() < (double)(this.outerParentArea.getHeight() - i.bottom)));
        }
        return this.component.getParent().contains(p) || this.outerParentArea.contains(p2);
    }

    private int getMoveComponentIndex(Point p) {
        JComponent parent = (JComponent)this.component.getParent();
        if (this.checkParentContains(p)) {
            boolean vertical = this.isVerticalDrag();
            int i = 0;
            while (i < parent.getComponentCount() - 1) {
                Point p2 = this.getComponent(parent, i + 1).getLocation();
                if (vertical ? p.getY() >= 0.0 && p.getY() < p2.getY() : p.getX() >= 0.0 && p.getX() < p2.getX()) {
                    return i;
                }
                ++i;
            }
            if (this.dragIndex == -1) {
                return parent.getComponentCount();
            }
            if (vertical) {
                return p.getY() < 0.0 ? 0 : parent.getComponentCount() - 1;
            }
            return p.getX() < 0.0 ? 0 : parent.getComponentCount() - 1;
        }
        return -1;
    }

    private JComponent getComponent(Container parent, int index) {
        if (this.layoutOrderList != null) {
            return (JComponent)this.layoutOrderList.get(index);
        }
        return (JComponent)parent.getComponent(index);
    }

    private int getComponentIndex(Component c) {
        if (this.layoutOrderList != null) {
            return this.layoutOrderList.indexOf(c);
        }
        return ComponentUtil.getComponentIndex(c);
    }

    private void addComponent(Container parent, Component c, int index) {
        if (this.layoutOrderList != null) {
            this.layoutOrderList.add(index, c);
            parent.add(c, index);
        } else {
            parent.add(c, index);
        }
        this.revalidateComponentTree((JComponent)c);
    }

    private void removeComponent(Container parent, Component c, int index) {
        this.revalidateComponentTree((JComponent)c);
        if (this.layoutOrderList != null) {
            if (index < 0) {
                this.layoutOrderList.remove(c);
                parent.remove(c);
            } else {
                Component tmp = (Component)this.layoutOrderList.get(index);
                this.layoutOrderList.remove(index);
                parent.remove(tmp);
            }
        } else if (index < 0) {
            parent.remove(c);
        } else {
            parent.remove(index);
        }
    }

    private void revalidateComponentTree(JComponent c) {
        Container parent = c.getParent();
        int index = ComponentUtil.getComponentIndex(c);
        if (index > 0) {
            this.doRevalidateComponentTree((JComponent)parent.getComponent(index - 1));
        }
        this.doRevalidateComponentTree(c);
        if (index < parent.getComponentCount() - 1) {
            this.doRevalidateComponentTree((JComponent)parent.getComponent(index + 1));
        }
    }

    private void doRevalidateComponentTree(JComponent c) {
        c.revalidate();
        int count = c.getComponentCount();
        int i = 0;
        while (i < count) {
            this.doRevalidateComponentTree((JComponent)c.getComponent(i));
            ++i;
        }
    }

    private void restoreComponentOrder() {
        if (this.reorderEnabled && this.dragIndex != -1 && this.dragFromIndex != -1 && this.dragIndex != this.dragFromIndex) {
            Container parent = this.component.getParent();
            JComponent comp = this.getComponent(parent, this.dragIndex);
            this.removeComponent(parent, comp, -1);
            this.dragIndex = this.dragFromIndex;
            this.addComponent(parent, comp, this.dragIndex);
            this.fireChangedEvent(0);
        }
    }

    private void fireChangedEvent(int type) {
        this.updateParent();
        if (this.listeners != null) {
            DraggableComponentEvent event = new DraggableComponentEvent(this, type);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((DraggableComponentListener)l[i]).changed(event);
                ++i;
            }
        }
    }

    private void fireSelectedEvent() {
        this.updateParent();
        if (this.listeners != null) {
            DraggableComponentEvent event = new DraggableComponentEvent(this);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((DraggableComponentListener)l[i]).selected(event);
                ++i;
            }
        }
    }

    private void fireDraggedEvent(MouseEvent mouseEvent) {
        this.dragEventFired = true;
        if (this.listeners != null) {
            DraggableComponentEvent event = new DraggableComponentEvent(this, mouseEvent);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((DraggableComponentListener)l[i]).dragged(event);
                ++i;
            }
        }
    }

    private void fireDroppedEvent(MouseEvent mouseEvent) {
        this.updateParent();
        if (this.dragEventFired) {
            this.dragEventFired = false;
            if (this.listeners != null) {
                DraggableComponentEvent event = new DraggableComponentEvent(this, mouseEvent);
                Object[] l = this.listeners.toArray();
                int i = 0;
                while (i < l.length) {
                    ((DraggableComponentListener)l[i]).dropped(event);
                    ++i;
                }
            }
        }
    }

    private void fireNotDroppedEvent() {
        this.updateParent();
        if (this.dragEventFired) {
            this.dragEventFired = false;
            if (this.listeners != null) {
                DraggableComponentEvent event = new DraggableComponentEvent(this);
                Object[] l = this.listeners.toArray();
                int i = 0;
                while (i < l.length) {
                    ((DraggableComponentListener)l[i]).dragAborted(event);
                    ++i;
                }
            }
        }
    }
}

