/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ConcurrentCache;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.FileScriptSpecification;
import org.freeplane.plugin.script.GenericScript;
import org.freeplane.plugin.script.GroovyScript;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptRunner;
import org.freeplane.plugin.script.ScriptSpecification;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.StringScriptSpecification;

public class ScriptingEngine {
    public static final String SCRIPT_PREFIX = "script";
    private static Map<File, IScript> fileScripts = new ConcurrentHashMap<File, IScript>();
    private static ConcurrentCache<ScriptSpecification, IScript> scripts = new ConcurrentCache(ScriptingEngine::getCompiledScriptCacheSize);

    private static int getCompiledScriptCacheSize() {
        return ResourceController.getResourceController().getIntProperty("compiled_script_cache_size");
    }

    public static Object executeScript(NodeModel node, String script, IFreeplaneScriptErrorHandler pErrorHandler, PrintStream pOutStream, ScriptContext scriptContext, ScriptingPermissions permissions) {
        return new ScriptRunner(ScriptingEngine.createGroovyScript(script, permissions)).setErrorHandler(pErrorHandler).setOutStream(pOutStream).setScriptContext(scriptContext).execute(node);
    }

    public static int findLineNumberInString(String resultString, int lineNumber) {
        Pattern pattern = Pattern.compile(".*@ line ([0-9]+).*", 32);
        Matcher matcher = pattern.matcher(resultString);
        if (matcher.matches()) {
            lineNumber = Integer.parseInt(matcher.group(1));
        }
        return lineNumber;
    }

    public static Object executeScript(NodeModel node, String script) {
        return new ScriptRunner(new GroovyScript(script)).execute(node);
    }

    public static IScript createScript(File scriptFile, ScriptingPermissions permissions, boolean saveForLaterUse) {
        IScript script = fileScripts.get(scriptFile);
        if (script == null || !script.hasPermissions(permissions)) {
            if (saveForLaterUse) {
                script = ScriptingEngine.compile(scriptFile, permissions);
                fileScripts.put(scriptFile, script);
            } else {
                script = scripts.computeIfAbsent(new FileScriptSpecification(scriptFile, permissions), () -> ScriptingEngine.compile(scriptFile, permissions));
            }
        }
        return script;
    }

    private static IScript compile(File scriptFile, ScriptingPermissions permissions) {
        boolean isGroovy = scriptFile.getName().endsWith(".groovy");
        IScript script = isGroovy ? new GroovyScript(scriptFile, permissions) : new GenericScript(scriptFile, permissions);
        return script;
    }

    public static IScript createScript(String source, String type, ScriptingPermissions permissions) {
        return scripts.computeIfAbsent(new StringScriptSpecification(source, type, permissions), () -> ScriptingEngine.compile(source, type, permissions));
    }

    private static IScript compile(String source, String type, ScriptingPermissions permissions) {
        boolean isGroovy = type.equals("groovy");
        IScript script = isGroovy ? new GroovyScript(source, permissions) : new GenericScript(source, type, permissions);
        return script;
    }

    public static IScript createGroovyScript(String script, ScriptingPermissions permissions) {
        return ScriptingEngine.createScript(script, "groovy", permissions);
    }

    public static Object executeScript(NodeModel node, File scriptFile, ScriptingPermissions permissions) {
        IScript script = ScriptingEngine.createScript(scriptFile, permissions, false);
        return new ScriptRunner(script).execute(node);
    }

    public static Object executeScript(NodeModel node, String script, ScriptingPermissions permissions) {
        return new ScriptRunner(ScriptingEngine.createGroovyScript(script, permissions)).execute(node);
    }

    public static Object executeScript(NodeModel node, String script, PrintStream printStream) {
        return new ScriptRunner(ScriptingEngine.createGroovyScript(script, null)).setOutStream(printStream).execute(node);
    }

    public static Object executeScript(NodeModel node, String script, ScriptContext scriptContext, ScriptingPermissions permissions) {
        return new ScriptRunner(ScriptingEngine.createGroovyScript(script, permissions)).setScriptContext(scriptContext).execute(node);
    }

    static void performScriptOperationRecursive(NodeModel node) {
        for (NodeModel child : node.getChildren()) {
            ScriptingEngine.performScriptOperationRecursive(child);
        }
        ScriptingEngine.performScriptOperation(node);
    }

    static void performScriptOperation(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel((NodeModel)node);
        if (attributes == null) {
            return;
        }
        for (int row = 0; row < attributes.getRowCount(); ++row) {
            String attrKey = (String)attributes.getName(row);
            Object value = attributes.getValue(row);
            if (!(value instanceof String)) continue;
            String script = (String)value;
            if (!attrKey.startsWith(SCRIPT_PREFIX)) continue;
            ScriptingEngine.executeScript(node, script);
        }
    }

    @Deprecated
    public static File getUserScriptDir() {
        return ScriptResources.getUserScriptDir();
    }

    static void showScriptExceptionErrorMessage(ExecuteScriptException ex) {
        if (ex.getCause() instanceof SecurityException) {
            String message = WordUtils.wrap((String)ex.getCause().getMessage(), (int)80, (String)"\n    ", (boolean)false);
            UITools.errorMessage((Object)TextUtils.format((String)"ExecuteScriptSecurityError.text", (Object[])new Object[]{message}));
        } else {
            String message = WordUtils.wrap((String)ex.getMessage(), (int)80, (String)"\n    ", (boolean)false);
            UITools.errorMessage((Object)TextUtils.format((String)"ExecuteScriptError.text", (Object[])new Object[]{message}));
        }
    }
}

