/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.menu;

import java.util.List;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.menubuilders.action.AcceleratebleActionProvider;
import org.freeplane.core.ui.menubuilders.action.AcceleratorBuilder;
import org.freeplane.core.ui.menubuilders.action.AcceleratorDestroyer;
import org.freeplane.core.ui.menubuilders.action.ActionFinder;
import org.freeplane.core.ui.menubuilders.action.ActionStatusUpdater;
import org.freeplane.core.ui.menubuilders.action.EntriesForAction;
import org.freeplane.core.ui.menubuilders.action.IAcceleratorMap;
import org.freeplane.core.ui.menubuilders.generic.BuildPhaseListener;
import org.freeplane.core.ui.menubuilders.generic.BuildProcessFactory;
import org.freeplane.core.ui.menubuilders.generic.ChildEntryFilter;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryPopupListenerCollection;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.ui.menubuilders.generic.RecursiveMenuStructureProcessor;
import org.freeplane.core.ui.menubuilders.generic.ResourceAccessor;
import org.freeplane.core.ui.menubuilders.generic.SubtreeProcessor;
import org.freeplane.core.ui.menubuilders.menu.ConditionalActionBuilder;
import org.freeplane.core.ui.menubuilders.menu.EmptyMenuItemBuilder;
import org.freeplane.core.ui.menubuilders.menu.JComponentRemover;
import org.freeplane.core.ui.menubuilders.menu.JMenuItemBuilder;
import org.freeplane.core.ui.menubuilders.menu.JMenuRadioGroupBuilder;
import org.freeplane.core.ui.menubuilders.menu.JMenubarBuilder;
import org.freeplane.core.ui.menubuilders.menu.JRadioButtonGroupComponentRemover;
import org.freeplane.core.ui.menubuilders.menu.JToolbarBuilder;
import org.freeplane.core.ui.menubuilders.menu.JToolbarComponentBuilder;
import org.freeplane.core.ui.menubuilders.menu.MenuAcceleratorChangeListener;
import org.freeplane.core.ui.menubuilders.menu.PopupBuilder;
import org.freeplane.core.util.Compat;
import org.freeplane.features.mode.FreeplaneActions;

public class MenuBuildProcessFactory
implements BuildProcessFactory {
    private PhaseProcessor buildProcessor;
    private SubtreeProcessor childProcessor;

    @Override
    public PhaseProcessor getBuildProcessor() {
        return this.buildProcessor;
    }

    @Override
    public SubtreeProcessor getChildProcessor() {
        return this.childProcessor;
    }

    public MenuBuildProcessFactory(IUserInputListenerFactory userInputListenerFactory, FreeplaneActions modeController, ResourceAccessor resourceAccessor, IAcceleratorMap acceleratorMap, EntriesForAction entries, List<BuildPhaseListener> buildPhaseListeners) {
        RecursiveMenuStructureProcessor actionBuilder = new RecursiveMenuStructureProcessor();
        actionBuilder.setDefaultBuilder(new ActionFinder(modeController));
        actionBuilder.addBuilder("conditionalActionBuilder", new ConditionalActionBuilder(modeController));
        RecursiveMenuStructureProcessor acceleratorBuilder = new RecursiveMenuStructureProcessor();
        acceleratorBuilder.setDefaultBuilderPair(new AcceleratorBuilder(acceleratorMap, entries), new AcceleratorDestroyer(modeController, acceleratorMap, entries));
        this.childProcessor = new SubtreeProcessor(RecursiveMenuStructureProcessor::shouldProcessOnEvent);
        ActionStatusUpdater actionSelectListener = new ActionStatusUpdater();
        EntryPopupListenerCollection entryPopupListenerCollection = new EntryPopupListenerCollection();
        entryPopupListenerCollection.addEntryPopupListener(this.childProcessor);
        acceleratorMap.addAcceleratorChangeListener(modeController, new MenuAcceleratorChangeListener(entries));
        final RecursiveMenuStructureProcessor uiBuilder = new RecursiveMenuStructureProcessor();
        uiBuilder.setDefaultBuilderPair(EntryVisitor.EMTPY, EntryVisitor.EMTPY);
        uiBuilder.addBuilderPair("skip", EntryVisitor.SKIP, EntryVisitor.SKIP);
        uiBuilder.addBuilder("toolbar", new JToolbarBuilder(userInputListenerFactory));
        uiBuilder.setSubtreeDefaultBuilderPair("toolbar", "toolbar.action");
        uiBuilder.addBuilder("toolbar.action", new JToolbarComponentBuilder(resourceAccessor));
        uiBuilder.addBuilder("main_menu", new JMenubarBuilder(userInputListenerFactory));
        uiBuilder.setSubtreeDefaultBuilderPair("main_menu", "menu");
        uiBuilder.addBuilder("map_popup", new PopupBuilder(userInputListenerFactory.getMapPopup(), entryPopupListenerCollection, resourceAccessor));
        uiBuilder.setSubtreeDefaultBuilderPair("map_popup", "menu");
        uiBuilder.addBuilder("node_popup", new PopupBuilder(userInputListenerFactory.getNodePopupMenu(), entryPopupListenerCollection, resourceAccessor));
        uiBuilder.setSubtreeDefaultBuilderPair("node_popup", "menu");
        AcceleratebleActionProvider acceleratebleActionProvider = new AcceleratebleActionProvider();
        JMenuItemBuilder menuBuilder = new JMenuItemBuilder(entryPopupListenerCollection, acceleratorMap, acceleratebleActionProvider, resourceAccessor);
        JComponentRemover destroyer = JComponentRemover.INSTANCE;
        uiBuilder.addBuilderPair("menu", menuBuilder, destroyer);
        uiBuilder.addBuilderPair("radio_button_group", new JMenuRadioGroupBuilder(entryPopupListenerCollection, acceleratorMap, new AcceleratebleActionProvider(), resourceAccessor), JRadioButtonGroupComponentRemover.INSTANCE);
        uiBuilder.addBuilderPair("noActions", new EmptyMenuItemBuilder(resourceAccessor), destroyer);
        RecursiveMenuStructureProcessor menuItemBuilder = new RecursiveMenuStructureProcessor();
        menuItemBuilder.setDefaultBuilderPair(menuBuilder, destroyer);
        menuItemBuilder.addBuilderPair("skip", EntryVisitor.SKIP, EntryVisitor.SKIP);
        menuItemBuilder.addBuilderPair("noActions", new EmptyMenuItemBuilder(resourceAccessor), destroyer);
        menuItemBuilder.addBuilderPair("radio_button_group", EntryVisitor.SKIP, EntryVisitor.SKIP);
        actionBuilder.addBuilderPair("ignore", new ChildEntryFilter(){

            @Override
            public boolean shouldRemove(Entry entry) {
                return !uiBuilder.containsOneOf(entry.builders());
            }
        }, EntryVisitor.EMTPY);
        if (Compat.isMacOsX()) {
            actionBuilder.addBuilderPair("removeOnMac", new ChildEntryFilter(){

                @Override
                public boolean shouldRemove(Entry entry) {
                    return true;
                }
            }, EntryVisitor.EMTPY);
        }
        this.buildProcessor = new PhaseProcessor(buildPhaseListeners).withPhase(PhaseProcessor.Phase.ACTIONS, actionBuilder).withPhase(PhaseProcessor.Phase.ACCELERATORS, acceleratorBuilder).withPhase(PhaseProcessor.Phase.UI, uiBuilder);
        this.childProcessor.setProcessor(this.buildProcessor);
        PhaseProcessor menuItemProcessor = new PhaseProcessor(buildPhaseListeners).withPhase(PhaseProcessor.Phase.UI, menuItemBuilder);
        SubtreeProcessor menuProcessor = new SubtreeProcessor(e -> "UI".equals(e.getAttribute("processOnPopup")));
        entryPopupListenerCollection.addEntryPopupListener(menuProcessor);
        entryPopupListenerCollection.addEntryPopupListener(actionSelectListener);
        menuProcessor.setProcessor(menuItemProcessor);
    }
}

