/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.commandsearch;

import java.awt.event.InputEvent;
import javax.swing.Icon;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.commandsearch.ItemChecker;
import org.freeplane.features.filter.condition.StringTransformer;

public abstract class SearchItem
implements Comparable<SearchItem> {
    static final String ITEM_PATH_SEPARATOR = "->";

    static String normalizeText(String text) {
        return StringTransformer.transform(text, true, true);
    }

    abstract int getItemTypeRank();

    public abstract String getComparedText();

    public abstract Icon getTypeIcon();

    public abstract String getDisplayedText();

    public abstract String getTooltip();

    abstract void execute(InputEvent var1);

    abstract void assignNewAccelerator();

    abstract boolean shouldUpdateResultList();

    protected void assignNewAccelerator(AFreeplaneAction action) {
        ResourceController.getResourceController().getAcceleratorManager().newAccelerator(action, null);
    }

    @Override
    public int compareTo(SearchItem o) {
        int rankCompare = Integer.compare(this.getItemTypeRank(), o.getItemTypeRank());
        return rankCompare != 0 ? rankCompare : this.getComparedText().compareToIgnoreCase(o.getComparedText());
    }

    boolean checkAndMatch(String[] searchTerms, ItemChecker textChecker) {
        for (int i = 0; i < searchTerms.length; ++i) {
            if (this.checkAndMatch(searchTerms[i], textChecker)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean checkAndMatch(String var1, ItemChecker var2);

    public abstract String getCopiedText();
}

