/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.FontMetrics;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.link.ConnectorChecker;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.NodeConnectorChecker;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.StyleString;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.n3.nanoxml.XMLElement;

public class ConnectorStyleCondition
extends ASelectableCondition
implements ConnectorChecker {
    static final String FILTER_STYLE = "filter_style";
    static final String NAME = "connector_style_equals";
    private final IStyle value;

    public ConnectorStyleCondition(IStyle value) {
        this.value = value;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        return NodeConnectorChecker.checkNodeConnectors(node, this);
    }

    @Override
    public boolean check(ConnectorModel connector) {
        return this.value.equals(connector.getStyle());
    }

    @Override
    public void fillXML(XMLElement child) {
        if (this.value instanceof StyleString) {
            child.setAttribute("TEXT", this.value.toString());
        } else if (this.value instanceof StyleTranslatedObject) {
            child.setAttribute("LOCALIZED_TEXT", ((StyleTranslatedObject)this.value).getObject().toString());
        }
    }

    public static ASelectableCondition load(XMLElement element) {
        String text = element.getAttribute("TEXT", null);
        if (text != null) {
            return new ConnectorStyleCondition(new StyleString(text));
        }
        String name = element.getAttribute("LOCALIZED_TEXT", null);
        if (name != null) {
            return new ConnectorStyleCondition(new StyleTranslatedObject(name));
        }
        return null;
    }

    @Override
    protected String createDescription() {
        String condition = TextUtils.getText("connector_label");
        String simpleCondition = TextUtils.getText(FILTER_STYLE);
        return this.createDescription(condition, simpleCondition, this.value.toString());
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        return this.createRenderedIconsFromDescription(fontMetrics);
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

