/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.icons;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.freeplane.features.link.icons.ContainsMatcher;
import org.freeplane.features.link.icons.DecorationRuleMatcher;
import org.freeplane.features.link.icons.PatternBasedMatcher;

class MatcherFactory {
    static final MatcherFactory INSTANCE = new MatcherFactory();
    private Map<String, DecorationRuleMatcher> matcherCache = new HashMap<String, DecorationRuleMatcher>();

    MatcherFactory() {
    }

    DecorationRuleMatcher matcherOf(String specification) {
        return this.matcherCache.computeIfAbsent(specification.trim(), this::createMatcher);
    }

    private DecorationRuleMatcher createMatcher(String specification) {
        if (specification.startsWith("{") && specification.endsWith("}")) {
            return new PatternBasedMatcher(Pattern.compile(specification.substring(1, specification.length() - 1)));
        }
        return new ContainsMatcher(specification);
    }
}

