/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.link;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.link.ArrowType;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.edge.EdgeViewFactory;
import org.freeplane.view.swing.map.link.AConnectorView;
import org.freeplane.view.swing.map.link.OutlineLinkView;

public class EdgeLinkView
extends AConnectorView {
    private final EdgeView edgeView;
    private LinkController linkController;

    public EdgeLinkView(ConnectorModel model, ModeController modeController, NodeView source, NodeView target) {
        super(model, source, target);
        Color color;
        MapView map = source.getMap();
        this.edgeView = map.getLayoutType() == MapViewLayout.OUTLINE ? new OutlineLinkView(source, target, map) : EdgeViewFactory.getInstance().getEdge(source, target, map, false);
        this.linkController = LinkController.getController(modeController);
        if (ConnectorShape.EDGE_LIKE.equals((Object)this.linkController.getShape(model))) {
            color = this.edgeView.getColor().darker();
        } else {
            color = this.linkController.getColor(this.viewedConnector);
            int alpha = this.linkController.getOpacity(this.viewedConnector);
            color = ColorUtils.alphaToColor(alpha, color);
            int width = this.linkController.getWidth(model);
            this.edgeView.setWidth(width);
            int[] dash = this.linkController.getDashArray(model);
            this.edgeView.setDash(dash);
        }
        this.edgeView.setColor(color);
    }

    @Override
    public boolean detectCollision(Point p, boolean selectedOnly) {
        NodeView target;
        NodeView source;
        if (!(!selectedOnly || (source = this.edgeView.getSource()) != null && source.isSelected() || (target = this.edgeView.getTarget()) != null && target.isSelected())) {
            return false;
        }
        return this.edgeView.detectCollision(p);
    }

    @Override
    public ConnectorModel getConnector() {
        return this.viewedConnector;
    }

    @Override
    public void increaseBounds(Rectangle innerBounds) {
    }

    @Override
    public void paint(Graphics graphics) {
        Point p2;
        Point p1;
        this.edgeView.paint((Graphics2D)graphics);
        if (ConnectorShape.EDGE_LIKE.equals((Object)this.linkController.getShape(this.viewedConnector))) {
            return;
        }
        if (this.isSourceVisible() && !this.linkController.getArrows((ConnectorModel)this.viewedConnector).start.equals((Object)ArrowType.NONE)) {
            p1 = this.edgeView.getShapeStart();
            p2 = new Point(p1);
            p2.translate(5, 0);
            this.paintArrow(graphics, p2, p1);
        }
        if (this.isTargetVisible() && !this.linkController.getArrows((ConnectorModel)this.viewedConnector).end.equals((Object)ArrowType.NONE)) {
            p1 = this.edgeView.getEnd();
            p2 = new Point(p1);
            p2.translate(5, 0);
            this.paintArrow(graphics, p2, p1);
        }
    }

    private void paintArrow(Graphics graphics, Point from, Point to) {
        this.paintArrow(from, to, (Graphics2D)graphics, this.getZoom() * 10.0, AConnectorView.ArrowDirection.INCOMING);
    }
}

