/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.overview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.ViewController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewScrollPane;
import org.freeplane.view.swing.map.overview.BookmarkToolbarPane;
import org.freeplane.view.swing.map.overview.MapOverviewAttachPoint;
import org.freeplane.view.swing.map.overview.MapOverviewImage;
import org.freeplane.view.swing.map.overview.resizable.ResizablePanelBorder;
import org.freeplane.view.swing.map.overview.resizable.ResizePanelMouseHandler;

public class MapViewPane
extends JPanel
implements IFreeplanePropertyListener,
IMapChangeListener {
    private static final long serialVersionUID = 8664710783654626093L;
    private static final String MAP_OVERVIEW_VISIBLE_PROPERTY = "mapOverviewVisible";
    private static final String MAP_OVERVIEW_VISIBLE_FS_PROPERTY = "mapOverviewVisible.fullscreen";
    private static final String BOOKMARKS_TOOLBAR_VISIBLE_PROPERTY = "bookmarksToolbarVisible";
    private static final String BOOKMARKS_TOOLBAR_VISIBLE_FS_PROPERTY = "bookmarksToolbarVisible.fullscreen";
    private static final String MAP_OVERVIEW_PROPERTY_PREFIX = "map_overview_";
    private static final String MAP_OVERVIEW_ATTACH_POINT_PROPERTY = "map_overview_attach_point";
    private static final String MAP_OVERVIEW_BOUNDS_PROPERTY = "map_overview_bounds";
    public static final int MAP_OVERVIEW_DEFAULT_SIZE = new Quantity(240.0, (Enum)LengthUnit.pt).toBaseUnitsRounded();
    public static final int MAP_OVERVIEW_MIN_SIZE = new Quantity(60.0, (Enum)LengthUnit.pt).toBaseUnitsRounded();
    public static final int MAP_OVERVIEW_MAX_SIZE = new Quantity(480.0, (Enum)LengthUnit.pt).toBaseUnitsRounded();
    public static final int MAP_OVERVIEW_BORDER_SIZE = new Quantity(3.0, (Enum)LengthUnit.pt).toBaseUnitsRounded();
    public static final int MAP_OVERVIEW_BORDER_EXTENDED_SIZE = MAP_OVERVIEW_BORDER_SIZE + new Quantity(24.0, (Enum)LengthUnit.pt).toBaseUnitsRounded();
    private final JScrollPane mapViewScrollPane;
    private final JPanel mapOverviewPanel;
    private boolean isMapOverviewVisible;
    private final MapOverviewImage mapOverviewImage;
    private final MapView mapView;

    public MapViewPane(final JScrollPane mapViewScrollPane) {
        this.mapViewScrollPane = mapViewScrollPane;
        this.mapView = (MapView)mapViewScrollPane.getViewport().getView();
        this.setLayout(new BorderLayout(0, 0){
            private static final long serialVersionUID = 3702408082745761647L;

            @Override
            public void addLayoutComponent(Component comp, Object constraints) {
                if (constraints != null) {
                    super.addLayoutComponent(comp, constraints);
                }
            }

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                mapViewScrollPane.validate();
                MapViewPane.this.mapOverviewPanel.setBounds(MapViewPane.this.calculateMapOverviewBounds());
            }
        });
        this.mapOverviewImage = new MapOverviewImage(this.mapView, mapViewScrollPane);
        this.mapOverviewPanel = new JPanel(new BorderLayout(0, 0)){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateUI() {
                super.updateUI();
                ResizePanelMouseHandler handler = new ResizePanelMouseHandler();
                this.addMouseListener(handler);
                this.addMouseMotionListener(handler);
                this.setBorder(new ResizablePanelBorder(MAP_OVERVIEW_BORDER_SIZE, MAP_OVERVIEW_BORDER_EXTENDED_SIZE));
            }
        };
        this.mapOverviewPanel.add(this.mapOverviewImage);
        ViewController viewController = Controller.getCurrentController().getViewController();
        this.isMapOverviewVisible = viewController.isMapOverviewVisible();
        this.mapOverviewPanel.setVisible(this.isMapOverviewVisible);
        this.add(this.mapOverviewPanel);
        this.add((Component)mapViewScrollPane, "Center");
        this.mapView.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MapViewPane.this.updateMapOverview();
            }
        });
        this.mapView.addPropertyChangeListener("bookmarkToolbarFocus", ev -> {
            if (ev.getNewValue() != null) {
                BookmarkToolbarPane bookmarkToolbarPane;
                this.mapView.putClientProperty("bookmarkToolbarFocus", null);
                ViewController controller = Controller.getCurrentController().getViewController();
                if (!controller.isBookmarksToolbarVisible()) {
                    controller.setBookmarksToolbarVisible(true);
                }
                if ((bookmarkToolbarPane = (BookmarkToolbarPane)SwingUtilities.getAncestorOfClass(BookmarkToolbarPane.class, this.mapView)) != null) {
                    bookmarkToolbarPane.requestFocusForBookmarkToolbar();
                }
            }
        });
    }

    @Override
    public void mapChanged(MapChangeEvent event) {
        Object property = event.getProperty();
        if (property.equals(MapView.class)) {
            if (event.getOldValue() == this.mapView) {
                event.getMap().removeMapChangeListener(this);
                MapModel map = this.mapView.getMap();
                map.addMapChangeListener(this);
            } else {
                return;
            }
        }
        this.updateMapOverview();
    }

    private void updateMapOverview() {
        if (this.mapOverviewPanel.isVisible()) {
            this.mapOverviewImage.resetImage();
            SwingUtilities.invokeLater(this.mapOverviewPanel::repaint);
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.mapView.getMap().addMapChangeListener(this);
        ResourceController.getResourceController().addPropertyChangeListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.mapView.getMap().removeMapChangeListener(this);
        ResourceController.getResourceController().removePropertyChangeListener(this);
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        ViewController viewController;
        if (("fullscreen_enabled".equals(propertyName) || MAP_OVERVIEW_VISIBLE_PROPERTY.equals(propertyName) || MAP_OVERVIEW_VISIBLE_FS_PROPERTY.equals(propertyName)) && this.isMapOverviewVisible != (viewController = Controller.getCurrentController().getViewController()).isMapOverviewVisible()) {
            this.isMapOverviewVisible = !this.isMapOverviewVisible;
            this.mapOverviewPanel.setVisible(this.isMapOverviewVisible);
            this.updateMapOverview();
        }
        if (propertyName.startsWith(MAP_OVERVIEW_PROPERTY_PREFIX)) {
            if (MAP_OVERVIEW_ATTACH_POINT_PROPERTY.equals(propertyName)) {
                Rectangle mapOverviewBounds = this.mapOverviewPanel.getBounds();
                this.convertOriginByAttachPoint(mapOverviewBounds);
                mapOverviewBounds.setLocation(0, 0);
                this.setMapOverviewBounds(mapOverviewBounds, true);
            }
            this.revalidate();
            this.updateMapOverview();
        }
    }

    public MapOverviewAttachPoint getMapOverviewAttachPoint() {
        ResourceController resourceController = ResourceController.getResourceController();
        String rawAttachPoint = resourceController.getProperty(MAP_OVERVIEW_ATTACH_POINT_PROPERTY);
        if (rawAttachPoint == null) {
            return MapOverviewAttachPoint.SOUTH_EAST;
        }
        try {
            return MapOverviewAttachPoint.valueOf(rawAttachPoint);
        }
        catch (IllegalArgumentException e) {
            return MapOverviewAttachPoint.SOUTH_EAST;
        }
    }

    public Color getMapViewBackground() {
        return this.mapView.getBackground();
    }

    public void updateMapOverviewAttachPoint(MapOverviewAttachPoint attachPoint) {
        Rectangle oldBounds = this.mapOverviewPanel.getBounds();
        Rectangle oldAttachBounds = new Rectangle(oldBounds);
        this.convertOriginByAttachPoint(oldAttachBounds);
        MapOverviewAttachPoint oldAttachPoint = this.getMapOverviewAttachPoint();
        if (attachPoint != oldAttachPoint) {
            ResourceController.getResourceController().setProperty(MAP_OVERVIEW_ATTACH_POINT_PROPERTY, attachPoint.name());
        } else if (oldAttachBounds.x == 0 && oldAttachBounds.y == 0) {
            oldAttachBounds.setSize(MAP_OVERVIEW_DEFAULT_SIZE, MAP_OVERVIEW_DEFAULT_SIZE);
        }
        oldAttachBounds.setLocation(0, 0);
        this.setMapOverviewBounds(oldAttachBounds, true);
    }

    private Rectangle calculateMapOverviewBounds() {
        String[] rawElements;
        ResourceController resourceController = ResourceController.getResourceController();
        String rawBoundsValue = resourceController.getProperty(MAP_OVERVIEW_BOUNDS_PROPERTY);
        int[] elements = null;
        if (rawBoundsValue != null && (rawElements = rawBoundsValue.split(",")).length == 4) {
            elements = new int[4];
            for (int i = 0; i < 4; ++i) {
                try {
                    elements[i] = Integer.parseInt(rawElements[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    elements = null;
                    break;
                }
            }
        }
        if (elements == null) {
            elements = new int[]{0, 0, MAP_OVERVIEW_DEFAULT_SIZE, MAP_OVERVIEW_DEFAULT_SIZE};
        }
        void x = elements[0];
        void y = elements[1];
        int width = this.getBoundedValue(elements[2], MAP_OVERVIEW_MIN_SIZE, MAP_OVERVIEW_MAX_SIZE);
        int height = this.getBoundedValue(elements[3], MAP_OVERVIEW_MIN_SIZE, MAP_OVERVIEW_MAX_SIZE);
        Rectangle bounds = new Rectangle((int)x, (int)y, width, height);
        this.convertOriginByAttachPoint(bounds);
        return bounds;
    }

    private int getBoundedValue(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public void setMapOverviewBounds(Rectangle bounds) {
        this.setMapOverviewBounds(bounds, false);
    }

    private void setMapOverviewBounds(Rectangle bounds, boolean isConverted) {
        if (!isConverted) {
            this.convertOriginByAttachPoint(bounds);
        }
        ResourceController.getResourceController().setProperty(MAP_OVERVIEW_BOUNDS_PROPERTY, String.format("%s,%s,%s,%s", bounds.x, bounds.y, bounds.width, bounds.height));
    }

    private void convertOriginByAttachPoint(Rectangle bounds) {
        Point location;
        JViewport viewPort = this.mapViewScrollPane.getViewport();
        int bottom = viewPort.getHeight();
        int right = viewPort.getWidth();
        switch (this.getMapOverviewAttachPoint()) {
            case SOUTH_EAST: {
                location = new Point(right - bounds.x - bounds.width, bottom - bounds.y - bounds.height);
                break;
            }
            case SOUTH_WEST: {
                location = new Point(bounds.x, bottom - bounds.y - bounds.height);
                break;
            }
            case NORTH_EAST: {
                location = new Point(right - bounds.x - bounds.width, bounds.y);
                break;
            }
            case NORTH_WEST: {
                location = new Point(0, 0);
                break;
            }
            default: {
                throw new RuntimeException("All cases handled above");
            }
        }
        UITools.convertPointToAncestor((Component)viewPort, location, JScrollPane.class);
        bounds.setLocation(location);
    }

    public Rectangle getMapOverviewReservedArea() {
        if (this.isMapOverviewVisible) {
            return this.mapOverviewPanel.getBounds();
        }
        return MapViewScrollPane.EMPTY_RECTANGLE;
    }

    public JScrollPane getMapViewScrollPane() {
        return this.mapViewScrollPane;
    }
}

