/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.DynamicResource;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

class SHTMLHelpBroker {
    public static final String APP_HELP_NAME = "help";
    public static final String JAVA_HELP_EXT = ".hs";
    private static HelpBroker helpBroker;

    private SHTMLHelpBroker() {
    }

    private static HelpBroker getHelpBroker() {
        if (helpBroker == null) {
            HelpSet hs;
            URL url = SHTMLPanelImpl.class.getResource("help/help.hs");
            try {
                hs = new HelpSet(null, url);
            }
            catch (HelpSetException e) {
                return null;
            }
            helpBroker = hs.createHelpBroker();
        }
        return helpBroker;
    }

    static AbstractButton createHelpButton(String helpTopicId) {
        JButton newButton = new JButton();
        CSH.setHelpIDString((Component)newButton, (String)helpTopicId);
        newButton.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(SHTMLHelpBroker.getHelpBroker()));
        return newButton;
    }

    static void initJavaHelpItem(JMenuItem mi, String helpTopicId) {
        CSH.setHelpIDString((Component)mi, (String)helpTopicId);
        mi.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(SHTMLHelpBroker.getHelpBroker()));
        mi.setIcon(DynamicResource.getIconForCommand(SHTMLPanelImpl.getUiResources(), "helpTopics"));
        mi.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        mi.setEnabled(true);
    }
}

