/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Constructable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.LambdaFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;

public class LambdaConstructor
extends LambdaFunction {
    private static final long serialVersionUID = 2691205302914111400L;
    public static final int CONSTRUCTOR_FUNCTION = 1;
    public static final int CONSTRUCTOR_NEW = 2;
    public static final int CONSTRUCTOR_DEFAULT = 3;
    private final transient Constructable targetConstructor;
    private final int flags;

    public LambdaConstructor(Scriptable scriptable, String string, int n, Constructable constructable) {
        super(scriptable, string, n, null);
        this.targetConstructor = constructable;
        this.flags = 3;
    }

    public LambdaConstructor(Scriptable scriptable, String string, int n, int n2, Constructable constructable) {
        super(scriptable, string, n, null);
        this.targetConstructor = constructable;
        this.flags = n2;
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if ((this.flags & 1) == 0) {
            throw ScriptRuntime.typeErrorById("msg.constructor.no.function", this.getFunctionName());
        }
        return this.targetConstructor.construct(context, scriptable, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        if ((this.flags & 2) == 0) {
            throw ScriptRuntime.typeErrorById("msg.no.new", this.getFunctionName());
        }
        Scriptable scriptable2 = this.targetConstructor.construct(context, scriptable, objectArray);
        scriptable2.setPrototype(this.getClassPrototype());
        scriptable2.setParentScope(scriptable);
        return scriptable2;
    }

    public void definePrototypeMethod(Scriptable scriptable, String string, int n, Callable callable) {
        LambdaFunction lambdaFunction = new LambdaFunction(scriptable, string, n, callable);
        ScriptableObject scriptableObject = this.getPrototypeScriptable();
        scriptableObject.defineProperty(string, (Object)lambdaFunction, 0);
    }

    public void definePrototypeMethod(Scriptable scriptable, String string, int n, Callable callable, int n2, int n3) {
        LambdaFunction lambdaFunction = new LambdaFunction(scriptable, string, n, callable);
        lambdaFunction.setStandardPropertyAttributes(n3);
        ScriptableObject scriptableObject = this.getPrototypeScriptable();
        scriptableObject.defineProperty(string, (Object)lambdaFunction, n2);
    }

    public void definePrototypeProperty(String string, Object object, int n) {
        ScriptableObject scriptableObject = this.getPrototypeScriptable();
        scriptableObject.defineProperty(string, object, n);
    }

    public void definePrototypeProperty(Symbol symbol, Object object, int n) {
        ScriptableObject scriptableObject = this.getPrototypeScriptable();
        scriptableObject.defineProperty(symbol, object, n);
    }

    public void defineConstructorMethod(Scriptable scriptable, String string, int n, Callable callable, int n2) {
        LambdaFunction lambdaFunction = new LambdaFunction(scriptable, string, n, callable);
        this.defineProperty(string, (Object)lambdaFunction, n2);
    }

    public void defineConstructorMethod(Scriptable scriptable, Symbol symbol, String string, int n, Callable callable, int n2) {
        LambdaFunction lambdaFunction = new LambdaFunction(scriptable, string, n, callable);
        this.defineProperty(symbol, (Object)lambdaFunction, n2);
    }

    public void defineConstructorMethod(Scriptable scriptable, String string, int n, Callable callable, int n2, int n3) {
        LambdaFunction lambdaFunction = new LambdaFunction(scriptable, string, n, callable);
        lambdaFunction.setStandardPropertyAttributes(n3);
        this.defineProperty(string, (Object)lambdaFunction, n2);
    }

    public static <T> T convertThisObject(Scriptable scriptable, Class<T> clazz) {
        if (!clazz.isInstance(scriptable)) {
            throw ScriptRuntime.typeErrorById("msg.this.not.instance", new Object[0]);
        }
        return (T)scriptable;
    }

    private ScriptableObject getPrototypeScriptable() {
        Object object = this.getPrototypeProperty();
        if (!(object instanceof ScriptableObject)) {
            throw ScriptRuntime.typeError("Not properly a lambda constructor");
        }
        return (ScriptableObject)object;
    }
}

