/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSCountersValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.AbstractCounterValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

class CountersValue
extends AbstractCounterValue
implements CSSCountersValue {
    private static final long serialVersionUID = 1L;
    private String separator = "";

    public CountersValue() {
        super(CSSValue.Type.COUNTERS);
    }

    protected CountersValue(CountersValue countersValue) {
        super(countersValue);
        this.separator = countersValue.separator;
    }

    @Override
    public CountersValue clone() {
        return new CountersValue(this);
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        CSSValueSyntax.Category category = cSSValueSyntax.getCategory();
        if (category == CSSValueSyntax.Category.universal || category == CSSValueSyntax.Category.counter) {
            return CSSValueSyntax.Match.TRUE;
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getCssText() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("counters(").append(this.getName());
        String string2 = this.getSeparator();
        stringBuilder.append(", ");
        CountersValue.quoteSeparator(string2, stringBuilder);
        PrimitiveValue primitiveValue = this.getCounterStyle();
        if (primitiveValue != null && !"decimal".equalsIgnoreCase(string = primitiveValue.getCssText())) {
            stringBuilder.append(", ").append(string);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("counters(").append(this.getName());
        String string3 = this.getSeparator();
        stringBuilder.append(',');
        CountersValue.quoteSeparator(string3, stringBuilder);
        PrimitiveValue primitiveValue = this.getCounterStyle();
        if (primitiveValue != null && !"decimal".equalsIgnoreCase(string2 = primitiveValue.getCssText())) {
            stringBuilder.append(',').append(string2);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)"counters(");
        simpleWriter.write((CharSequence)this.getName());
        String string = this.getSeparator();
        simpleWriter.write((CharSequence)", ");
        if (!string.contains("'")) {
            simpleWriter.write('\'');
            simpleWriter.write((CharSequence)string);
            simpleWriter.write('\'');
        } else {
            simpleWriter.write('\"');
            simpleWriter.write((CharSequence)string);
            simpleWriter.write('\"');
        }
        PrimitiveValue primitiveValue = this.getCounterStyle();
        if (primitiveValue != null && !CountersValue.isCSSIdentifier(primitiveValue, "decimal")) {
            simpleWriter.write((CharSequence)", ");
            primitiveValue.writeCssText(simpleWriter);
        }
        simpleWriter.write(')');
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        CountersValue countersValue = (CountersValue)object;
        if (this.separator == null) {
            return countersValue.separator == null;
        }
        return this.separator.equals(countersValue.separator);
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        if (this.separator != null) {
            n2 = 31 * n2 + this.separator.hashCode();
        }
        return n2;
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(CountersValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                this.checkProxyValue(lexicalUnit2);
                throw new DOMException(17, "Invalid counters() name.");
            }
            CountersValue.this.setName(lexicalUnit2.getStringValue());
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2 != null) {
                if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                        this.badSyntax(lexicalUnit);
                    }
                    if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.STRING) {
                        CountersValue.this.setSeparator(lexicalUnit2.getStringValue());
                    } else {
                        this.checkProxyValue(lexicalUnit2);
                        this.badSyntax(lexicalUnit);
                    }
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    if (lexicalUnit2 != null) {
                        if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            LexicalUnit.LexicalType lexicalType;
                            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                                this.badSyntax(lexicalUnit);
                            }
                            if ((lexicalType = lexicalUnit2.getLexicalUnitType()) == LexicalUnit.LexicalType.IDENT || lexicalType == LexicalUnit.LexicalType.FUNCTION && "symbols".equalsIgnoreCase(lexicalUnit2.getFunctionName())) {
                                ValueFactory valueFactory = new ValueFactory();
                                PrimitiveValue.LexicalSetter lexicalSetter = valueFactory.createCSSPrimitiveValueItem(lexicalUnit2, false, false);
                                CountersValue.this.setCounterStyle(lexicalSetter.getCSSValue());
                                if (lexicalSetter.getNextLexicalUnit() != null) {
                                    this.badSyntax(lexicalUnit);
                                }
                            } else {
                                this.checkProxyValue(lexicalUnit2);
                                this.badSyntax(lexicalUnit);
                            }
                        } else {
                            this.checkProxyValue(lexicalUnit2);
                            this.badSyntax(lexicalUnit);
                        }
                    }
                } else {
                    this.checkProxyValue(lexicalUnit2);
                    this.badSyntax(lexicalUnit);
                }
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private void badSyntax(LexicalUnit lexicalUnit) {
            throw new DOMException(12, "Bad counters syntax: " + lexicalUnit.toString());
        }
    }
}

