/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class StringValue
extends AbstractTextValue {
    private static final long serialVersionUID = 1L;
    private String stringValue = null;
    private final short flags;
    char quote;

    public StringValue() {
        this(0);
    }

    public StringValue(short s) {
        this(CSSValue.Type.STRING, s);
    }

    StringValue(CSSValue.Type type, short s) {
        super(type);
        this.flags = s;
        this.quote = (char)39;
        this.setQuote();
    }

    protected StringValue(StringValue stringValue) {
        super(stringValue);
        this.stringValue = stringValue.stringValue;
        this.flags = stringValue.flags;
        this.quote = stringValue.quote;
    }

    private void setQuote() {
        if (this.isDoubleQuoteSet()) {
            this.quote = (char)34;
        } else if ((this.flags & 1) == 1) {
            this.quote = (char)39;
        }
    }

    private boolean isDoubleQuoteSet() {
        return (this.flags & 2) == 2;
    }

    private boolean isNoQuotePreferenceSet() {
        return (this.flags & 3) == 0;
    }

    @Override
    public void setCssText(String string) throws DOMException {
        this.checkModifiableProperty();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string = string.trim();
        int n = string.length() - 1;
        if (n > 1) {
            char c = string.charAt(0);
            char c2 = string.charAt(n);
            if (c == '\'') {
                if (c2 == '\'') {
                    string2 = string.substring(1, n);
                    bl2 = true;
                }
            } else if (c == '\"' && c2 == '\"') {
                string2 = string.substring(1, n);
                bl = true;
            }
        }
        this.stringValue = ParseHelper.unescapeStringValue(string2);
        if (this.isNoQuotePreferenceSet() || this.isDoubleQuoteSet() && bl || !bl2 && !bl) {
            if (bl) {
                this.quote = (char)34;
            }
            string2 = ParseHelper.escapeControl(string2);
            this.setPlainCssText(ParseHelper.quote(string2, this.quote));
        } else {
            this.setUnescapedCssText(this.stringValue);
        }
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public void setStringValue(CSSValue.Type type, String string) throws DOMException {
        this.checkModifiableProperty();
        if (this.getPrimitiveType() != type) {
            throw new DOMException(13, "This value is a different type. To have a new type, set it at the style-declaration level.");
        }
        if (string == null) {
            throw new DOMException(5, "Null value.");
        }
        this.setStringValue(string);
        this.setUnescapedCssText(string);
    }

    protected void setStringValue(String string) {
        this.stringValue = string;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        switch (cSSValueSyntax.getCategory()) {
            case string: 
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    boolean usesDoubleQuote(String string) {
        return string.charAt(0) == '\"';
    }

    protected void setUnescapedCssText(String string) {
        this.setPlainCssText(StringValue.escapeControlBackslashAndQuote(string, this.quote));
    }

    private static String escapeControlBackslashAndQuote(String string, char c) {
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = string.indexOf(34) != -1;
        boolean bl4 = bl = string.indexOf(39) != -1;
        if (bl) {
            c = (char)34;
            if (bl3) {
                int n = string.length();
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    char c2 = string.charAt(i);
                    if (c2 == '\'') {
                        ++n2;
                        continue;
                    }
                    if (c2 != '\"') continue;
                    ++n3;
                }
                if (n2 > n3) {
                    c = (char)34;
                } else {
                    c = (char)39;
                    bl2 = false;
                }
            }
        } else if (bl3) {
            bl2 = false;
            c = (char)39;
        }
        string = ParseHelper.escapeString(string, c, true);
        string = bl || bl3 ? (bl2 ? '\"' + string + '\"' : '\'' + string + '\'') : c + string + c;
        return string;
    }

    @Override
    public String getMinifiedCssText(String string) {
        return StringValue.escapeControlBackslashAndQuote(this.stringValue, this.quote);
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)this.getCssText());
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        String string = this.getStringValue();
        n2 = 31 * n2 + (string == null ? 0 : string.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof StringValue)) {
            return false;
        }
        StringValue stringValue = (StringValue)object;
        if (this.stringValue == null) {
            return stringValue.stringValue == null;
        }
        return this.stringValue.equals(stringValue.stringValue);
    }

    @Override
    public StringValue clone() {
        return new StringValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            super.setLexicalUnit(lexicalUnit);
            String string = lexicalUnit.getStringValue();
            StringValue.this.setStringValue(string);
            if (StringValue.this.isNoQuotePreferenceSet() && lexicalUnit instanceof LexicalUnit) {
                String string2 = lexicalUnit.getCssText();
                if (string2.length() != 0 && StringValue.this.usesDoubleQuote(string2)) {
                    StringValue.this.quote = (char)34;
                }
                StringValue.this.setPlainCssText(string2);
            } else {
                StringValue.this.setUnescapedCssText(string);
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
    }
}

