/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class UnicodeWildcardValue
extends TypedValue {
    private static final long serialVersionUID = 1L;
    private String wildcard = null;

    public UnicodeWildcardValue() {
        super(CSSValue.Type.UNICODE_WILDCARD);
    }

    protected UnicodeWildcardValue(UnicodeWildcardValue unicodeWildcardValue) {
        super(unicodeWildcardValue);
        this.wildcard = unicodeWildcardValue.wildcard;
    }

    @Override
    public void setCssText(String string) throws DOMException {
        throw new DOMException(7, "This property is read-only.");
    }

    @Override
    public String getStringValue() {
        return this.wildcard;
    }

    @Override
    public void setStringValue(CSSValue.Type type, String string) throws DOMException {
        this.checkModifiableProperty();
        if (type != CSSValue.Type.UNICODE_WILDCARD) {
            throw new DOMException(13, "Only setting wildcards is supported.");
        }
        if (string == null) {
            throw new DOMException(5, "Null value.");
        }
        string = string.trim();
        this.checkWildcard(string);
        this.wildcard = string;
    }

    private void checkWildcard(String string) {
        int n = string.length();
        if (n == 0 || n > 6) {
            this.invalidWildcardError(string);
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '?' || UnicodeWildcardValue.isHexChar(c)) continue;
            this.invalidWildcardError(string);
        }
    }

    static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private void invalidWildcardError(String string) {
        throw new DOMException(12, "Not a valid wildcard: " + this.wildcard);
    }

    public void setWildcard(String string) {
        this.wildcard = string;
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)"U+");
        simpleWriter.write((CharSequence)this.wildcard);
    }

    @Override
    public String getCssText() {
        return "U+" + this.wildcard;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.wildcard == null ? 0 : this.wildcard.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UnicodeWildcardValue unicodeWildcardValue = (UnicodeWildcardValue)object;
        if (this.wildcard == null) {
            return unicodeWildcardValue.wildcard == null;
        }
        return this.wildcard.equals(unicodeWildcardValue.wildcard);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public UnicodeWildcardValue clone() {
        return new UnicodeWildcardValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            UnicodeWildcardValue.this.wildcard = lexicalUnit.getStringValue();
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
    }
}

