/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.layout;

import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Margin;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.util.PMVMatrix;
import java.util.List;

public class BoxLayout
implements Group.Layout {
    private final float cellWidth;
    private final float cellHeight;
    private final Margin margin;
    private final Padding padding;
    private static final boolean TRACE_LAYOUT = false;

    public BoxLayout(Padding padding) {
        this(0.0f, 0.0f, new Margin(), padding);
    }

    public BoxLayout(float f, float f2, Margin margin) {
        this(f, f2, margin, new Padding());
    }

    public BoxLayout(float f, float f2, Margin margin, Padding padding) {
        this.cellWidth = Math.max(0.0f, f);
        this.cellHeight = Math.max(0.0f, f2);
        this.margin = margin;
        this.padding = padding;
    }

    public Padding getPadding() {
        return this.padding;
    }

    public Margin getMargin() {
        return this.margin;
    }

    @Override
    public void layout(Group group, AABBox aABBox, PMVMatrix pMVMatrix) {
        boolean bl = !FloatUtil.isZero(this.cellWidth);
        boolean bl2 = !FloatUtil.isZero(this.cellHeight);
        List<Shape> list = group.getShapes();
        AABBox aABBox2 = new AABBox();
        for (int i = 0; i < list.size(); ++i) {
            Shape shape = list.get(i);
            pMVMatrix.glPushMatrix();
            shape.setTransform(pMVMatrix);
            shape.getBounds().transformMv(pMVMatrix, aABBox2);
            pMVMatrix.glPopMatrix();
            float f = aABBox2.getWidth() + this.padding.width();
            float f2 = aABBox2.getHeight() + this.padding.height();
            float f3 = bl ? this.cellWidth : f;
            float f4 = bl2 ? this.cellHeight : f2;
            float f5 = this.margin.left;
            float f6 = this.margin.bottom;
            if (!this.margin.isCenteredHoriz() && f <= f3) {
                f5 += this.padding.left;
            }
            if (!this.margin.isCenteredVert() && f2 <= f4) {
                f6 += this.padding.bottom;
            }
            float f7 = this.margin.isCenteredHoriz() ? 0.5f * (f3 - f) : 0.0f;
            float f8 = this.margin.isCenteredVert() ? 0.5f * (f4 - f2) : 0.0f;
            shape.move(f5 + f7, f6 + f8, 0.0f);
            shape.move(aABBox2.getLow().mul(-1.0f));
            aABBox.resize(f5 + aABBox2.getWidth() + this.padding.right, f6 + aABBox2.getHeight() + this.padding.top, 0.0f);
            aABBox.resize(f5 - this.padding.left, f6 - this.padding.bottom, 0.0f);
        }
    }

    public String toString() {
        return "Box[cell[" + this.cellWidth + " x " + this.cellHeight + "], " + this.margin + ", " + this.padding + "]";
    }
}

