/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.cff;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Dict {
    private final Map<Integer, Object> _entries = new HashMap<Integer, Object>();
    private final int[] _data;
    private int _index;

    public Dict(int[] nArray, int n, int n2) {
        this._data = nArray;
        this._index = n;
        while (this._index < n + n2) {
            this.addKeyAndValueEntry();
        }
    }

    public Dict(DataInput dataInput, int n) throws IOException {
        this._data = new int[n];
        for (int i = 0; i < n; ++i) {
            this._data[i] = dataInput.readUnsignedByte();
        }
        this._index = 0;
        while (this._index < n) {
            this.addKeyAndValueEntry();
        }
    }

    public Object getValue(int n) {
        return this._entries.get(n);
    }

    private void addKeyAndValueEntry() {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        while (this.isOperandAtIndex()) {
            object = this.nextOperand();
            arrayList.add(object);
        }
        if ((n = this._data[this._index++]) == 12) {
            n <<= 8;
            n |= this._data[this._index++];
        }
        if (arrayList.size() == 1) {
            this._entries.put(n, object);
        } else {
            this._entries.put(n, arrayList);
        }
    }

    private boolean isOperandAtIndex() {
        int n = this._data[this._index];
        return 32 <= n && n <= 254 || n == 28 || n == 29 || n == 30;
    }

    private Object nextOperand() {
        int n = this._data[this._index];
        if (32 <= n && n <= 246) {
            ++this._index;
            return n - 139;
        }
        if (247 <= n && n <= 250) {
            int n2 = this._data[this._index + 1];
            this._index += 2;
            return (n - 247) * 256 + n2 + 108;
        }
        if (251 <= n && n <= 254) {
            int n3 = this._data[this._index + 1];
            this._index += 2;
            return -(n - 251) * 256 - n3 - 108;
        }
        if (n == 28) {
            int n4 = this._data[this._index + 1];
            int n5 = this._data[this._index + 2];
            this._index += 3;
            return n4 << 8 | n5;
        }
        if (n == 29) {
            int n6 = this._data[this._index + 1];
            int n7 = this._data[this._index + 2];
            int n8 = this._data[this._index + 3];
            int n9 = this._data[this._index + 4];
            this._index += 5;
            return n6 << 24 | n7 << 16 | n8 << 8 | n9;
        }
        if (n == 30) {
            StringBuilder stringBuilder = new StringBuilder();
            int n10 = 0;
            int n11 = 0;
            ++this._index;
            while (n10 != 15 && n11 != 15) {
                n10 = this._data[this._index] >> 4;
                n11 = this._data[this._index] & 0xF;
                ++this._index;
                stringBuilder.append(this.decodeRealNibble(n10));
                stringBuilder.append(this.decodeRealNibble(n11));
            }
            return Float.valueOf(stringBuilder.toString());
        }
        return null;
    }

    private String decodeRealNibble(int n) {
        if (n < 10) {
            return Integer.toString(n);
        }
        if (n == 10) {
            return ".";
        }
        if (n == 11) {
            return "E";
        }
        if (n == 12) {
            return "E-";
        }
        if (n == 14) {
            return "-";
        }
        return "";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n : this._entries.keySet()) {
            if ((n & 0xC00) == 3072) {
                stringBuilder.append("12 ").append((int)(n & 0xFF)).append(": ");
            } else {
                stringBuilder.append(n.toString()).append(": ");
            }
            stringBuilder.append(this._entries.get(n).toString()).append("\n");
        }
        return stringBuilder.toString();
    }
}

