/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.oatclass;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.dex.format.ClassDataItem;
import ghidra.file.formats.android.oat.oatclass.OatClass;
import ghidra.file.formats.android.oat.oatclass.OatClassType;
import ghidra.file.formats.android.oat.oatmethod.OatMethodOffsets;
import ghidra.file.formats.android.oat.oatmethod.OatMethodOffsetsFactory;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class OatClass_Lollipop
extends OatClass {
    private int bitmap_size_;
    private byte[] bitmap_ = new byte[0];

    OatClass_Lollipop(BinaryReader reader, ClassDataItem classDataItem, String oatVersion) throws IOException {
        super(reader, oatVersion);
        int i;
        this.type_ = reader.readNextShort();
        int methodOffsetsCount = 0;
        if (this.type_ == OatClassType.kOatClassSomeCompiled.ordinal()) {
            this.bitmap_size_ = reader.readNextInt();
            this.bitmap_ = reader.readNextByteArray(this.bitmap_size_);
            for (i = 0; i < this.bitmap_size_; ++i) {
                methodOffsetsCount += Integer.bitCount(Byte.toUnsignedInt(this.bitmap_[i]));
            }
        } else if (this.type_ == OatClassType.kOatClassAllCompiled.ordinal()) {
            methodOffsetsCount = classDataItem.getDirectMethodsSize() + classDataItem.getVirtualMethodsSize();
        }
        for (i = 0; i < methodOffsetsCount; ++i) {
            this.methods_pointer_.add(OatMethodOffsetsFactory.getOatMethodOffsets(reader, oatVersion));
        }
    }

    public int getBitmapSize() {
        return this.bitmap_size_;
    }

    public byte[] getBitmap() {
        return this.bitmap_;
    }

    @Override
    public boolean isMethodNative(int methodIndex) {
        int bytePos = methodIndex / 8;
        int bitPos = methodIndex % 8;
        return (this.bitmap_[bytePos] >> bitPos & 1) == 1;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        Object className = OatClass_Lollipop.class.getSimpleName();
        if (this.bitmap_size_ > 0) {
            className = (String)className + "_" + this.bitmap_size_;
        }
        if (this.methods_pointer_.size() > 0) {
            className = (String)className + "_" + this.methods_pointer_.size();
        }
        StructureDataType structure = new StructureDataType((String)className, 0);
        structure.add(this.statusEnum.toDataType(), "status_", null);
        structure.add(WORD, "type_", null);
        if (this.type_ == OatClassType.kOatClassSomeCompiled.ordinal()) {
            structure.add(DWORD, "bitmap_size_", null);
            if (this.bitmap_size_ > 0) {
                ArrayDataType bitmapDataType = new ArrayDataType(BYTE, this.bitmap_size_, BYTE.getLength());
                structure.add((DataType)bitmapDataType, "bitmap_", null);
            }
        }
        for (int i = 0; i < this.methods_pointer_.size(); ++i) {
            structure.add(((OatMethodOffsets)this.methods_pointer_.get(i)).toDataType(), "methods_pointer_" + i, null);
        }
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

