/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dtb;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.dtb.DtTableEntry;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DtTableHeader
implements StructConverter {
    private int magic;
    private int total_size;
    private int header_size;
    private int dt_entry_size;
    private int dt_entry_count;
    private int dt_entries_offset;
    private int page_size;
    private int version;
    private List<DtTableEntry> _entries = new ArrayList<DtTableEntry>();

    public DtTableHeader(BinaryReader reader) throws IOException {
        if (!reader.isBigEndian()) {
            throw new IOException("DTB is always big endian.");
        }
        this.magic = reader.readNextInt();
        if (this.magic != -675828962) {
            throw new IOException("Invalid DTB Header magic.");
        }
        this.total_size = reader.readNextInt();
        this.header_size = reader.readNextInt();
        this.dt_entry_size = reader.readNextInt();
        this.dt_entry_count = reader.readNextInt();
        this.dt_entries_offset = reader.readNextInt();
        this.page_size = reader.readNextInt();
        this.version = reader.readNextInt();
        reader.setPointerIndex(this.dt_entries_offset);
        for (int i = 0; i < this.dt_entry_count; ++i) {
            this._entries.add(new DtTableEntry(reader));
        }
    }

    public int getMagic() {
        return this.magic;
    }

    public int getTotalSize() {
        return this.total_size;
    }

    public int getHeaderSize() {
        return this.header_size;
    }

    public int getDtEntrySize() {
        return this.dt_entry_size;
    }

    public int getDtEntryCount() {
        return this.dt_entry_count;
    }

    public int getDtEntriesOffset() {
        return this.dt_entries_offset;
    }

    public int getPageSize() {
        return this.page_size;
    }

    public int getVersion() {
        return this.version;
    }

    public List<DtTableEntry> getEntries() {
        return this._entries;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType((Object)this);
    }
}

