/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.gzip;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.gzip.GZipFileSystemFactory;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.SingleFileSystemIndexHelper;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.io.FilenameUtils;

@FileSystemInfo(type="gzip", description="GZIP", priority=-10, factory=GZipFileSystemFactory.class)
public class GZipFileSystem
implements GFileSystem {
    public static final String GZIP_PAYLOAD_FILENAME = "gzip_decompressed";
    private final FSRLRoot fsFSRL;
    private final FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private final SingleFileSystemIndexHelper fsIndex;
    private final FileSystemService fsService;
    private ByteProvider container;
    private ByteProvider payloadProvider;
    private String payloadFilename;
    private String payloadKey;
    private String origComment;
    private long origDate;

    public GZipFileSystem(ByteProvider container, FSRLRoot fsFSRL, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        this.fsFSRL = fsFSRL;
        this.fsService = fsService;
        this.container = container;
        this.readGzipMetadata(monitor);
        this.payloadProvider = this.getPayloadByteProvider(monitor);
        this.fsIndex = new SingleFileSystemIndexHelper((GFileSystem)this, fsFSRL, this.payloadFilename, this.payloadProvider.length(), this.payloadProvider.getFSRL().getMD5());
    }

    private void readGzipMetadata(TaskMonitor monitor) throws IOException {
        try (GzipCompressorInputStream gzcis = new GzipCompressorInputStream(this.container.getInputStream(0L));){
            String containerName;
            GzipParameters metaData = gzcis.getMetaData();
            this.payloadFilename = metaData.getFilename();
            this.payloadFilename = this.payloadFilename == null ? ((containerName = this.fsFSRL.getContainer().getName()).toLowerCase().endsWith(".gz") ? FilenameUtils.removeExtension((String)containerName) : GZIP_PAYLOAD_FILENAME) : FSUtilities.getSafeFilename((String)this.payloadFilename);
            this.origComment = metaData.getComment();
            this.origDate = metaData.getModificationTime();
            this.payloadKey = "uncompressed " + this.payloadFilename;
        }
    }

    private ByteProvider getPayloadByteProvider(TaskMonitor monitor) throws CancelledException, IOException {
        UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor, this.container.length());
        return this.fsService.getDerivedByteProvider(this.container.getFSRL(), null, this.payloadKey, -1L, () -> new GzipCompressorInputStream(this.container.getInputStream(0L)), (TaskMonitor)upwtm);
    }

    public GFile getPayloadFile() {
        return this.fsIndex.getPayloadFile();
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndex.clear();
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
        if (this.payloadProvider != null) {
            this.payloadProvider.close();
            this.payloadProvider = null;
        }
    }

    public boolean isClosed() {
        return this.fsIndex.isClosed();
    }

    public GFile lookup(String path) {
        return this.fsIndex.lookup(path);
    }

    public GFile lookup(String path, Comparator<String> nameComp) throws IOException {
        return this.fsIndex.lookup(null, path, nameComp);
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.fsIndex.isPayloadFile(file)) {
            return new ByteProviderWrapper(this.payloadProvider, file.getFSRL());
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndex.getListing(directory);
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        long compSize = 0L;
        long payloadSize = 0L;
        try {
            compSize = this.container.length();
            payloadSize = this.payloadProvider.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GFile payload = this.fsIndex.getPayloadFile();
        FileAttributes result = new FileAttributes();
        result.add(FileAttributeType.NAME_ATTR, (Object)payload.getName());
        result.add(FileAttributeType.SIZE_ATTR, (Object)payloadSize);
        result.add(FileAttributeType.COMPRESSED_SIZE_ATTR, (Object)compSize);
        result.add(FileAttributeType.MODIFIED_DATE_ATTR, (Object)(this.origDate != 0L ? new Date(this.origDate) : null));
        result.add(FileAttributeType.COMMENT_ATTR, (Object)this.origComment);
        result.add("MD5", (Object)payload.getFSRL().getMD5());
        return result;
    }

    public Map<String, String> getInfoMap() {
        long compSize = 0L;
        long payloadSize = 0L;
        try {
            compSize = this.container.length();
            payloadSize = this.payloadProvider.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GFile payload = this.fsIndex.getPayloadFile();
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("Name", payload.getName());
        info.put("Size", FSUtilities.formatSize((Long)payloadSize));
        info.put("Compressed Size", FSUtilities.formatSize((Long)compSize));
        info.put("Date", FSUtilities.formatFSTimestamp((Date)(this.origDate != 0L ? new Date(this.origDate) : null)));
        info.put("Comment", Objects.requireNonNullElse(this.origComment, "unknown"));
        info.put("MD5", payload.getFSRL().getMD5());
        return info;
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }
}

